/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.broker;

import java.net.URI;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.actiontoken.idpverifyemail.IdpVerifyAccountLinkActionToken;
import org.keycloak.authentication.authenticators.broker.AbstractIdpAuthenticator;
import org.keycloak.authentication.authenticators.broker.util.SerializedBrokeredIdentityContext;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.common.util.Time;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailTemplateProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.Urls;
import org.keycloak.sessions.AuthenticationSessionCompoundId;
import org.keycloak.sessions.AuthenticationSessionModel;

public class IdpEmailVerificationAuthenticator
extends AbstractIdpAuthenticator {
    private static Logger logger = Logger.getLogger(IdpEmailVerificationAuthenticator.class);
    public static final String VERIFY_ACCOUNT_IDP_USERNAME = "VERIFY_ACCOUNT_IDP_USERNAME";

    @Override
    protected void authenticateImpl(AuthenticationFlowContext context, SerializedBrokeredIdentityContext serializedCtx, BrokeredIdentityContext brokerContext) {
        KeycloakSession session = context.getSession();
        RealmModel realm = context.getRealm();
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        if (realm.getSmtpConfig().isEmpty()) {
            ServicesLogger.LOGGER.smtpNotConfigured();
            context.attempted();
            return;
        }
        if (Objects.equals(authSession.getAuthNote(VERIFY_ACCOUNT_IDP_USERNAME), brokerContext.getUsername())) {
            UserModel existingUser = IdpEmailVerificationAuthenticator.getExistingUser(session, realm, authSession);
            logger.debugf("User '%s' confirmed that wants to link with identity provider '%s' . Identity provider username is '%s' ", (Object)existingUser.getUsername(), (Object)brokerContext.getIdpConfig().getAlias(), (Object)brokerContext.getUsername());
            context.setUser(existingUser);
            context.success();
            return;
        }
        UserModel existingUser = IdpEmailVerificationAuthenticator.getExistingUser(session, realm, authSession);
        if (!Objects.equals(authSession.getAuthNote("VERIFY_EMAIL_KEY"), existingUser.getEmail())) {
            authSession.setAuthNote("VERIFY_EMAIL_KEY", existingUser.getEmail());
            this.sendVerifyEmail(session, context, existingUser, brokerContext);
        } else {
            this.showEmailSentPage(context, brokerContext);
        }
    }

    @Override
    protected void actionImpl(AuthenticationFlowContext context, SerializedBrokeredIdentityContext serializedCtx, BrokeredIdentityContext brokerContext) {
        logger.debugf("Re-sending email requested for user, details follow", new Object[0]);
        context.getAuthenticationSession().removeAuthNote("VERIFY_EMAIL_KEY");
        this.authenticateImpl(context, serializedCtx, brokerContext);
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return false;
    }

    private void sendVerifyEmail(KeycloakSession session, AuthenticationFlowContext context, UserModel existingUser, BrokeredIdentityContext brokerContext) throws UriBuilderException, IllegalArgumentException {
        RealmModel realm = session.getContext().getRealm();
        UriInfo uriInfo = session.getContext().getUri();
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        int validityInSecs = realm.getActionTokenGeneratedByUserLifespan("idp-verify-account-via-email");
        int absoluteExpirationInSecs = Time.currentTime() + validityInSecs;
        EventBuilder event = context.getEvent().clone().event(EventType.SEND_IDENTITY_PROVIDER_LINK).user(existingUser).detail("username", existingUser.getUsername()).detail("email", existingUser.getEmail()).detail("code_id", authSession.getParentSession().getId()).removeDetail("auth_method").removeDetail("auth_type");
        String authSessionEncodedId = AuthenticationSessionCompoundId.fromAuthSession((AuthenticationSessionModel)authSession).getEncodedId();
        IdpVerifyAccountLinkActionToken token = new IdpVerifyAccountLinkActionToken(existingUser.getId(), absoluteExpirationInSecs, authSessionEncodedId, brokerContext.getUsername(), brokerContext.getIdpConfig().getAlias());
        UriBuilder builder = Urls.actionTokenBuilder(uriInfo.getBaseUri(), token.serialize(session, realm, uriInfo), authSession.getClient().getClientId(), authSession.getTabId());
        String link = builder.queryParam("execution", new Object[]{context.getExecution().getId()}).build(new Object[]{realm.getName()}).toString();
        long expirationInMinutes = TimeUnit.SECONDS.toMinutes(validityInSecs);
        try {
            ((EmailTemplateProvider)context.getSession().getProvider(EmailTemplateProvider.class)).setRealm(realm).setAuthenticationSession(authSession).setUser(existingUser).setAttribute("identityProviderBrokerCtx", (Object)brokerContext).sendConfirmIdentityBrokerLink(link, expirationInMinutes);
            event.success();
        }
        catch (EmailException e) {
            event.error("email_send_failed");
            ServicesLogger.LOGGER.confirmBrokerEmailFailed(e);
            Response challenge = context.form().setError("emailSendErrorMessage", new Object[0]).createErrorPage(Response.Status.INTERNAL_SERVER_ERROR);
            context.failure(AuthenticationFlowError.INTERNAL_ERROR, challenge);
            return;
        }
        this.showEmailSentPage(context, brokerContext);
    }

    protected void showEmailSentPage(AuthenticationFlowContext context, BrokeredIdentityContext brokerContext) {
        String accessCode = context.generateAccessCode();
        URI action = context.getActionUrl(accessCode);
        Response challenge = context.form().setStatus(Response.Status.OK).setAttribute("identityProviderBrokerCtx", (Object)brokerContext).setActionUri(action).setExecution(context.getExecution().getId()).createIdpLinkEmailPage();
        context.forceChallenge(challenge);
    }
}

