/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import java.util.HashMap;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.models.ClientModel;
import org.keycloak.representations.idm.ClientRepresentation;

public class OIDCAdvancedConfigWrapper {
    private static final String USER_INFO_RESPONSE_SIGNATURE_ALG = "user.info.response.signature.alg";
    private static final String REQUEST_OBJECT_SIGNATURE_ALG = "request.object.signature.alg";
    private static final String REQUEST_OBJECT_REQUIRED = "request.object.required";
    public static final String REQUEST_OBJECT_REQUIRED_REQUEST_OR_REQUEST_URI = "request or request_uri";
    public static final String REQUEST_OBJECT_REQUIRED_REQUEST = "request only";
    public static final String REQUEST_OBJECT_REQUIRED_REQUEST_URI = "request_uri only";
    private static final String JWKS_URL = "jwks.url";
    private static final String USE_JWKS_URL = "use.jwks.url";
    private static final String EXCLUDE_SESSION_STATE_FROM_AUTH_RESPONSE = "exclude.session.state.from.auth.response";
    private static final String USE_MTLS_HOK_TOKEN = "tls.client.certificate.bound.access.tokens";
    private final ClientModel clientModel;
    private final ClientRepresentation clientRep;

    private OIDCAdvancedConfigWrapper(ClientModel client, ClientRepresentation clientRep) {
        this.clientModel = client;
        this.clientRep = clientRep;
    }

    public static OIDCAdvancedConfigWrapper fromClientModel(ClientModel client) {
        return new OIDCAdvancedConfigWrapper(client, null);
    }

    public static OIDCAdvancedConfigWrapper fromClientRepresentation(ClientRepresentation clientRep) {
        return new OIDCAdvancedConfigWrapper(null, clientRep);
    }

    public Algorithm getUserInfoSignedResponseAlg() {
        String alg = this.getAttribute(USER_INFO_RESPONSE_SIGNATURE_ALG);
        return alg == null ? null : Enum.valueOf(Algorithm.class, alg);
    }

    public void setUserInfoSignedResponseAlg(Algorithm alg) {
        String algStr = alg == null ? null : alg.toString();
        this.setAttribute(USER_INFO_RESPONSE_SIGNATURE_ALG, algStr);
    }

    public boolean isUserInfoSignatureRequired() {
        return this.getUserInfoSignedResponseAlg() != null;
    }

    public Algorithm getRequestObjectSignatureAlg() {
        String alg = this.getAttribute(REQUEST_OBJECT_SIGNATURE_ALG);
        return alg == null ? null : Enum.valueOf(Algorithm.class, alg);
    }

    public void setRequestObjectSignatureAlg(Algorithm alg) {
        String algStr = alg == null ? null : alg.toString();
        this.setAttribute(REQUEST_OBJECT_SIGNATURE_ALG, algStr);
    }

    public String getRequestObjectRequired() {
        return this.getAttribute(REQUEST_OBJECT_REQUIRED);
    }

    public void setRequestObjectRequired(String requestObjectRequired) {
        this.setAttribute(REQUEST_OBJECT_REQUIRED, requestObjectRequired);
    }

    public boolean isUseJwksUrl() {
        String useJwksUrl = this.getAttribute(USE_JWKS_URL);
        return Boolean.parseBoolean(useJwksUrl);
    }

    public void setUseJwksUrl(boolean useJwksUrl) {
        String val = String.valueOf(useJwksUrl);
        this.setAttribute(USE_JWKS_URL, val);
    }

    public String getJwksUrl() {
        return this.getAttribute(JWKS_URL);
    }

    public void setJwksUrl(String jwksUrl) {
        this.setAttribute(JWKS_URL, jwksUrl);
    }

    public boolean isExcludeSessionStateFromAuthResponse() {
        String excludeSessionStateFromAuthResponse = this.getAttribute(EXCLUDE_SESSION_STATE_FROM_AUTH_RESPONSE);
        return Boolean.parseBoolean(excludeSessionStateFromAuthResponse);
    }

    public void setExcludeSessionStateFromAuthResponse(boolean excludeSessionStateFromAuthResponse) {
        String val = String.valueOf(excludeSessionStateFromAuthResponse);
        this.setAttribute(EXCLUDE_SESSION_STATE_FROM_AUTH_RESPONSE, val);
    }

    public boolean isUseMtlsHokToken() {
        String useUtlsHokToken = this.getAttribute(USE_MTLS_HOK_TOKEN);
        return Boolean.parseBoolean(useUtlsHokToken);
    }

    public void setUseMtlsHoKToken(boolean useUtlsHokToken) {
        String val = String.valueOf(useUtlsHokToken);
        this.setAttribute(USE_MTLS_HOK_TOKEN, val);
    }

    private String getAttribute(String attrKey) {
        if (this.clientModel != null) {
            return this.clientModel.getAttribute(attrKey);
        }
        return this.clientRep.getAttributes() == null ? null : (String)this.clientRep.getAttributes().get(attrKey);
    }

    private void setAttribute(String attrKey, String attrValue) {
        if (this.clientModel != null) {
            if (attrValue != null) {
                this.clientModel.setAttribute(attrKey, attrValue);
            } else {
                this.clientModel.removeAttribute(attrKey);
            }
        } else if (attrValue != null) {
            if (this.clientRep.getAttributes() == null) {
                this.clientRep.setAttributes(new HashMap());
            }
            this.clientRep.getAttributes().put(attrKey, attrValue);
        } else if (this.clientRep.getAttributes() != null) {
            this.clientRep.getAttributes().put(attrKey, null);
        }
    }
}

