/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.mappers.AbstractUserRoleMappingMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.IDToken;

public class UserClientRoleMappingMapper
extends AbstractUserRoleMappingMapper {
    public static final String PROVIDER_ID = "oidc-usermodel-client-role-mapper";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = new ArrayList<ProviderConfigProperty>();

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "User Client Role";
    }

    public String getDisplayCategory() {
        return "Token mapper";
    }

    public String getHelpText() {
        return "Map a user client role to a token claim.";
    }

    @Override
    protected void setClaim(IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession) {
        String clientId = (String)mappingModel.getConfig().get("usermodel.clientRoleMapping.clientId");
        String rolePrefix = (String)mappingModel.getConfig().get("usermodel.clientRoleMapping.rolePrefix");
        UserClientRoleMappingMapper.setClaim(token, mappingModel, userSession, UserClientRoleMappingMapper.getClientRoleFilter(clientId, userSession), rolePrefix);
    }

    private static Predicate<RoleModel> getClientRoleFilter(String clientId, UserSessionModel userSession) {
        if (clientId == null) {
            return RoleModel::isClientRole;
        }
        RealmModel clientRealm = userSession.getRealm();
        ClientModel client = clientRealm.getClientByClientId(clientId.trim());
        if (client == null) {
            return RoleModel::isClientRole;
        }
        boolean fullScopeAllowed = client.isFullScopeAllowed();
        Set clientRoleMappings = client.getRoles();
        if (fullScopeAllowed) {
            return clientRoleMappings::contains;
        }
        HashSet scopeMappings = new HashSet();
        String scopeParam = null;
        AuthenticatedClientSessionModel authClientSession = userSession.getAuthenticatedClientSessionByClient(client.getId());
        if (authClientSession != null) {
            scopeParam = authClientSession.getNote("scope");
        }
        Set<ClientScopeModel> clientScopes = TokenManager.getRequestedClientScopes(scopeParam, client);
        for (ClientScopeModel clientScope : clientScopes) {
            scopeMappings.addAll(clientScope.getScopeMappings());
        }
        return role -> clientRoleMappings.contains(role) && scopeMappings.contains(role);
    }

    public static ProtocolMapperModel create(String clientId, String clientRolePrefix, String name, String tokenClaimName, boolean accessToken, boolean idToken) {
        return UserClientRoleMappingMapper.create(clientId, clientRolePrefix, name, tokenClaimName, accessToken, idToken, false);
    }

    public static ProtocolMapperModel create(String clientId, String clientRolePrefix, String name, String tokenClaimName, boolean accessToken, boolean idToken, boolean multiValued) {
        ProtocolMapperModel mapper = OIDCAttributeMapperHelper.createClaimMapper(name, "foo", tokenClaimName, "String", accessToken, idToken, PROVIDER_ID);
        mapper.getConfig().put("multivalued", String.valueOf(multiValued));
        mapper.getConfig().put("usermodel.clientRoleMapping.clientId", clientId);
        mapper.getConfig().put("usermodel.clientRoleMapping.rolePrefix", clientRolePrefix);
        return mapper;
    }

    static {
        ProviderConfigProperty clientId = new ProviderConfigProperty();
        clientId.setName("usermodel.clientRoleMapping.clientId");
        clientId.setLabel("usermodel.clientRoleMapping.clientId.label");
        clientId.setHelpText("usermodel.clientRoleMapping.clientId.tooltip");
        clientId.setType("ClientList");
        CONFIG_PROPERTIES.add(clientId);
        ProviderConfigProperty clientRolePrefix = new ProviderConfigProperty();
        clientRolePrefix.setName("usermodel.clientRoleMapping.rolePrefix");
        clientRolePrefix.setLabel("usermodel.clientRoleMapping.rolePrefix.label");
        clientRolePrefix.setHelpText("usermodel.clientRoleMapping.rolePrefix.tooltip");
        clientRolePrefix.setType("String");
        CONFIG_PROPERTIES.add(clientRolePrefix);
        ProviderConfigProperty multiValued = new ProviderConfigProperty();
        multiValued.setName("multivalued");
        multiValued.setLabel("multivalued.label");
        multiValued.setHelpText("multivalued.tooltip");
        multiValued.setType("boolean");
        multiValued.setDefaultValue((Object)false);
        CONFIG_PROPERTIES.add(multiValued);
        OIDCAttributeMapperHelper.addAttributeConfig(CONFIG_PROPERTIES, UserClientRoleMappingMapper.class);
    }
}

