/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;

public class AuthRequest {
    private String id;
    private URI authUri;
    private Map<String, String> attributes;

    public static AuthRequestBuilder create(String id, String path) {
        AuthRequestBuilder req = new AuthRequestBuilder();
        req.id = id;
        req.b = UriBuilder.fromUri((String)path);
        req.attributes = new HashMap();
        return req;
    }

    private AuthRequest(String id, URI authUri, Map<String, String> attributes) {
        this.id = id;
        this.authUri = authUri;
        this.attributes = attributes;
    }

    public String getId() {
        return this.id;
    }

    public URI getAuthUri() {
        return this.authUri;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public static class AuthRequestBuilder {
        private UriBuilder b;
        private Map<String, String> attributes;
        private String id;

        private AuthRequestBuilder() {
        }

        public AuthRequestBuilder setQueryParam(String name, String value) {
            this.b.queryParam(name, new Object[]{value});
            return this;
        }

        public AuthRequestBuilder setAttribute(String name, String value) {
            this.attributes.put(name, value);
            return this;
        }

        public AuthRequest build() {
            return new AuthRequest(this.id, this.b.build(new Object[0]), this.attributes);
        }
    }
}

