/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.google;

import org.codehaus.jackson.JsonNode;
import org.keycloak.social.AbstractOAuth2Provider;
import org.keycloak.social.SocialProviderException;
import org.keycloak.social.SocialUser;
import org.keycloak.social.utils.SimpleHttp;

public class GoogleProvider
extends AbstractOAuth2Provider {
    private static final String ID = "google";
    private static final String NAME = "Google";
    private static final String AUTH_URL = "https://accounts.google.com/o/oauth2/auth";
    private static final String TOKEN_URL = "https://accounts.google.com/o/oauth2/token";
    private static final String PROFILE_URL = "https://www.googleapis.com/plus/v1/people/me/openIdConnect";
    private static final String DEFAULT_SCOPE = "openid profile email";

    public String getId() {
        return ID;
    }

    public String getName() {
        return NAME;
    }

    protected String getScope() {
        return DEFAULT_SCOPE;
    }

    protected String getAuthUrl() {
        return AUTH_URL;
    }

    protected String getTokenUrl() {
        return TOKEN_URL;
    }

    protected SocialUser getProfile(String accessToken) throws SocialProviderException {
        try {
            JsonNode profile = SimpleHttp.doGet((String)PROFILE_URL).header("Authorization", "Bearer " + accessToken).asJson();
            SocialUser user = new SocialUser(profile.get("sub").getTextValue(), profile.get("email").getTextValue());
            user.setName(profile.has("given_name") ? profile.get("given_name").getTextValue() : null, profile.has("family_name") ? profile.get("family_name").getTextValue() : null);
            user.setEmail(profile.has("email") ? profile.get("email").getTextValue() : null);
            return user;
        }
        catch (Exception e) {
            throw new SocialProviderException((Throwable)e);
        }
    }
}

