/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.extension.authserver;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.keycloak.subsystem.extension.KeycloakAdapterConfigService;
import org.keycloak.subsystem.extension.authserver.AuthServerDefinition;
import org.keycloak.subsystem.extension.authserver.AuthServerUtil;

public final class AuthServerAddHandler
extends AbstractAddStepHandler {
    public static AuthServerAddHandler INSTANCE = new AuthServerAddHandler();

    private AuthServerAddHandler() {
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        if (!operation.get("operation").asString().equals("add")) {
            throw new OperationFailedException("Unexpected operation for add Auth Server. operation=" + operation.toString());
        }
        ModelNode model = resource.getModel();
        for (AttributeDefinition attributeDefinition : AuthServerDefinition.ALL_ATTRIBUTES) {
            attributeDefinition.validateAndSet(operation, model);
        }
        model = context.resolveExpressions(model);
        if (!this.requiresRuntime(context)) {
            return;
        }
        if (!context.isNormalServer()) {
            return;
        }
        ModelNode webContextNode = model.get(AuthServerDefinition.WEB_CONTEXT.getName());
        if (!webContextNode.isDefined()) {
            webContextNode = AuthServerDefinition.WEB_CONTEXT.getDefaultValue();
        }
        String string = webContextNode.asString();
        ModelNode isEnabled = model.get("enabled");
        boolean enabled = isEnabled.isDefined() && isEnabled.asBoolean();
        AuthServerUtil authServerUtil = new AuthServerUtil(operation);
        authServerUtil.addStepToUploadAuthServer(context, enabled);
        KeycloakAdapterConfigService.INSTANCE.addServerDeployment(authServerUtil.getDeploymentName(), string);
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }
}

