/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.helper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.client.registration.Auth;
import org.keycloak.client.registration.ClientRegistration;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.representations.idm.ClientInitialAccessCreatePresentation;
import org.keycloak.representations.idm.ClientInitialAccessPresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

public class TestsHelper {
    public static String baseUrl;
    public static String keycloakBaseUrl;
    public static String testRealm;
    public static String initialAccessCode;
    public static String appName;
    protected static String clientConfiguration;
    protected static String registrationAccessCode;

    public static String createClient(ClientRepresentation clientRepresentation) {
        ClientRegistration reg = ClientRegistration.create().url(keycloakBaseUrl, testRealm).build();
        reg.auth(Auth.token((String)initialAccessCode));
        try {
            clientRepresentation = reg.create(clientRepresentation);
            registrationAccessCode = clientRepresentation.getRegistrationAccessToken();
            ObjectMapper mapper = new ObjectMapper();
            reg.auth(Auth.token((String)registrationAccessCode));
            clientConfiguration = mapper.writeValueAsString((Object)reg.getAdapterConfig(clientRepresentation.getClientId()));
        }
        catch (ClientRegistrationException e) {
            e.printStackTrace();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return clientConfiguration;
    }

    public static String createDirectGrantClient() {
        ClientRepresentation clientRepresentation = new ClientRepresentation();
        clientRepresentation.setClientId("test-dga");
        clientRepresentation.setFullScopeAllowed(Boolean.valueOf(true));
        clientRepresentation.setPublicClient(Boolean.TRUE);
        clientRepresentation.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
        ClientRegistration reg = ClientRegistration.create().url(keycloakBaseUrl, testRealm).build();
        reg.auth(Auth.token((String)initialAccessCode));
        try {
            clientRepresentation = reg.create(clientRepresentation);
            registrationAccessCode = clientRepresentation.getRegistrationAccessToken();
            ObjectMapper mapper = new ObjectMapper();
            reg.auth(Auth.token((String)registrationAccessCode));
            clientConfiguration = mapper.writeValueAsString((Object)reg.getAdapterConfig(clientRepresentation.getClientId()));
        }
        catch (ClientRegistrationException e) {
            e.printStackTrace();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return clientConfiguration;
    }

    public static void deleteClient(String clientId) {
        ClientRegistration reg = ClientRegistration.create().url(keycloakBaseUrl, testRealm).build();
        try {
            reg.auth(Auth.token((String)registrationAccessCode));
            reg.delete(clientId);
        }
        catch (ClientRegistrationException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testGetWithAuth(String endpoint, String token) throws IOException {
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            boolean bl;
            HttpGet get = new HttpGet(baseUrl + endpoint);
            get.addHeader("Authorization", "Bearer " + token);
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() != 200) {
                boolean bl2 = false;
                return bl2;
            }
            HttpEntity entity = response.getEntity();
            InputStream is = entity.getContent();
            try {
                bl = true;
            }
            catch (Throwable throwable) {
                is.close();
                throw throwable;
            }
            is.close();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean returnsForbidden(String endpoint) throws IOException {
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            HttpGet get = new HttpGet(baseUrl + endpoint);
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() == 403 || response.getStatusLine().getStatusCode() == 401) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static String getToken(String username, String password, String realm) {
        Keycloak keycloak = Keycloak.getInstance((String)keycloakBaseUrl, (String)realm, (String)username, (String)password, (String)"test-dga");
        return keycloak.tokenManager().getAccessTokenString();
    }

    public static boolean ImportTestRealm(String username, String password, String realmJsonPath) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ClassLoader classLoader = TestsHelper.class.getClassLoader();
        InputStream stream = TestsHelper.class.getResourceAsStream(realmJsonPath);
        RealmRepresentation realmRepresentation = (RealmRepresentation)mapper.readValue(stream, RealmRepresentation.class);
        Keycloak keycloak = Keycloak.getInstance((String)keycloakBaseUrl, (String)"master", (String)username, (String)password, (String)"admin-cli");
        keycloak.realms().create(realmRepresentation);
        testRealm = realmRepresentation.getRealm();
        ClientInitialAccessCreatePresentation rep = new ClientInitialAccessCreatePresentation();
        rep.setCount(Integer.valueOf(2));
        rep.setExpiration(Integer.valueOf(100));
        ClientInitialAccessPresentation initialAccess = keycloak.realms().realm(testRealm).clientInitialAccess().create(rep);
        initialAccessCode = initialAccess.getToken();
        return true;
    }

    public static boolean ImportTestRealm(String username, String password) throws IOException {
        testRealm = appName + "-realm";
        RealmRepresentation realmRepresentation = new RealmRepresentation();
        realmRepresentation.setRealm(testRealm);
        realmRepresentation.setEnabled(Boolean.valueOf(true));
        Keycloak keycloak = Keycloak.getInstance((String)keycloakBaseUrl, (String)"master", (String)username, (String)password, (String)"admin-cli");
        keycloak.realms().create(realmRepresentation);
        ClientInitialAccessCreatePresentation rep = new ClientInitialAccessCreatePresentation();
        rep.setCount(Integer.valueOf(2));
        rep.setExpiration(Integer.valueOf(100));
        ClientInitialAccessPresentation initialAccess = keycloak.realms().realm(testRealm).clientInitialAccess().create(rep);
        initialAccessCode = initialAccess.getToken();
        return true;
    }

    public static boolean deleteRealm(String username, String password, String realmName) throws IOException {
        Keycloak keycloak = Keycloak.getInstance((String)keycloakBaseUrl, (String)"master", (String)username, (String)password, (String)"admin-cli");
        keycloak.realms().realm(realmName).remove();
        return true;
    }

    public static boolean createTestUser(String username, String password, String realmName) throws IOException {
        Keycloak keycloak = Keycloak.getInstance((String)keycloakBaseUrl, (String)"master", (String)username, (String)password, (String)"admin-cli");
        UserRepresentation userRepresentation = new UserRepresentation();
        userRepresentation.setUsername("testuser");
        userRepresentation.setEnabled(Boolean.TRUE);
        Response response = keycloak.realms().realm(realmName).users().create(userRepresentation);
        String userId = TestsHelper.getCreatedId(response);
        response.close();
        CredentialRepresentation rep = new CredentialRepresentation();
        rep.setType("password");
        rep.setValue("password");
        rep.setTemporary(Boolean.valueOf(false));
        keycloak.realms().realm(realmName).users().get(userId).resetPassword(rep);
        RoleRepresentation representation = new RoleRepresentation();
        representation.setName("user");
        keycloak.realms().realm(realmName).roles().create(representation);
        RoleRepresentation realmRole = keycloak.realms().realm(realmName).roles().get("user").toRepresentation();
        keycloak.realms().realm(realmName).users().get(userId).roles().realmLevel().add(Arrays.asList(realmRole));
        return true;
    }

    public static String getCreatedId(Response response) {
        URI location = response.getLocation();
        if (!response.getStatusInfo().equals(Response.Status.CREATED)) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new WebApplicationException("Create method returned status " + statusInfo.getReasonPhrase() + " (Code: " + statusInfo.getStatusCode() + "); expected status: Created (201)", response);
        }
        if (location == null) {
            return null;
        }
        String path = location.getPath();
        return path.substring(path.lastIndexOf(47) + 1);
    }

    static {
        keycloakBaseUrl = "http://localhost:8180/auth";
        testRealm = "test-realm";
    }
}

