/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto.def;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v1CertificateBuilder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.keycloak.common.crypto.CertificateUtilsProvider;
import org.keycloak.common.util.BouncyIntegration;

public class BCCertificateUtilsProvider
implements CertificateUtilsProvider {
    public X509Certificate generateV3Certificate(KeyPair keyPair, PrivateKey caPrivateKey, X509Certificate caCert, String subject) throws Exception {
        try {
            X500Name subjectDN = new X500Name("CN=" + subject);
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            BigInteger serialNumber = BigInteger.valueOf(Math.abs(random.nextInt()));
            Date notBefore = new Date(System.currentTimeMillis());
            Date notAfter = new Date(System.currentTimeMillis() + 93312000000L);
            SubjectPublicKeyInfo subjPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded());
            X509v3CertificateBuilder certGen = new X509v3CertificateBuilder(new X500Name(caCert.getSubjectDN().getName()), serialNumber, notBefore, notAfter, subjectDN, subjPubKeyInfo);
            JcaX509ExtensionUtils x509ExtensionUtils = new JcaX509ExtensionUtils();
            certGen.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)x509ExtensionUtils.createSubjectKeyIdentifier(subjPubKeyInfo));
            certGen.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)x509ExtensionUtils.createAuthorityKeyIdentifier(subjPubKeyInfo));
            certGen.addExtension(Extension.keyUsage, false, (ASN1Encodable)new KeyUsage(134));
            KeyPurposeId[] EKU = new KeyPurposeId[]{KeyPurposeId.id_kp_emailProtection, KeyPurposeId.id_kp_serverAuth};
            certGen.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(EKU));
            certGen.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(0));
            ContentSigner sigGen = new JcaContentSignerBuilder("SHA1WithRSAEncryption").setProvider(BouncyIntegration.PROVIDER).build(caPrivateKey);
            return new JcaX509CertificateConverter().setProvider(BouncyIntegration.PROVIDER).getCertificate(certGen.build(sigGen));
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating X509v3Certificate.", e);
        }
    }

    public X509Certificate generateV1SelfSignedCertificate(KeyPair caKeyPair, String subject) {
        return this.generateV1SelfSignedCertificate(caKeyPair, subject, BigInteger.valueOf(System.currentTimeMillis()));
    }

    public X509Certificate generateV1SelfSignedCertificate(KeyPair caKeyPair, String subject, BigInteger serialNumber) {
        try {
            X500Name subjectDN = new X500Name("CN=" + subject);
            Date validityStartDate = new Date(System.currentTimeMillis() - 100000L);
            Calendar calendar = Calendar.getInstance();
            calendar.add(1, 10);
            Date validityEndDate = new Date(calendar.getTime().getTime());
            SubjectPublicKeyInfo subPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)caKeyPair.getPublic().getEncoded());
            X509v1CertificateBuilder builder = new X509v1CertificateBuilder(subjectDN, serialNumber, validityStartDate, validityEndDate, subjectDN, subPubKeyInfo);
            X509CertificateHolder holder = builder.build(this.createSigner(caKeyPair.getPrivate()));
            return new JcaX509CertificateConverter().getCertificate(holder);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating X509v1Certificate.", e);
        }
    }

    private ContentSigner createSigner(PrivateKey privateKey) {
        try {
            JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider(BouncyIntegration.PROVIDER);
            return signerBuilder.build(privateKey);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create content signer.", e);
        }
    }
}

