/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.user;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;

public interface UserQueryProvider {
    default public int getUsersCount(RealmModel realm) {
        return this.getUsersCount(realm, false);
    }

    default public int getUsersCount(RealmModel realm, Set<String> groupIds) {
        if (groupIds == null || groupIds.isEmpty()) {
            return 0;
        }
        return UserQueryProvider.countUsersInGroups(this.searchForUserStream(realm, Collections.emptyMap()), groupIds);
    }

    default public int getUsersCount(RealmModel realm, String search) {
        return (int)this.searchForUserStream(realm, search).count();
    }

    default public int getUsersCount(RealmModel realm, String search, Set<String> groupIds) {
        if (groupIds == null || groupIds.isEmpty()) {
            return 0;
        }
        return UserQueryProvider.countUsersInGroups(this.searchForUserStream(realm, search), groupIds);
    }

    default public int getUsersCount(RealmModel realm, Map<String, String> params) {
        return (int)this.searchForUserStream(realm, params).count();
    }

    default public int getUsersCount(RealmModel realm, Map<String, String> params, Set<String> groupIds) {
        if (groupIds == null || groupIds.isEmpty()) {
            return 0;
        }
        return UserQueryProvider.countUsersInGroups(this.searchForUserStream(realm, params), groupIds);
    }

    public static int countUsersInGroups(Stream<UserModel> users, Set<String> groupIds) {
        return (int)users.filter(u -> u.getGroupsStream().map(GroupModel::getId).anyMatch(groupIds::contains)).count();
    }

    default public int getUsersCount(RealmModel realm, boolean includeServiceAccount) {
        throw new RuntimeException("Not implemented");
    }

    @Deprecated
    default public Stream<UserModel> getUsersStream(RealmModel realm) {
        return this.searchForUserStream(realm, Collections.emptyMap());
    }

    @Deprecated
    default public Stream<UserModel> getUsersStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        return this.searchForUserStream(realm, Collections.emptyMap(), firstResult, maxResults);
    }

    default public Stream<UserModel> searchForUserStream(RealmModel realm, String search) {
        return this.searchForUserStream(realm, search, null, null);
    }

    public Stream<UserModel> searchForUserStream(RealmModel var1, String var2, Integer var3, Integer var4);

    default public Stream<UserModel> searchForUserStream(RealmModel realm, Map<String, String> params) {
        return this.searchForUserStream(realm, params, null, null);
    }

    public Stream<UserModel> searchForUserStream(RealmModel var1, Map<String, String> var2, Integer var3, Integer var4);

    default public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group) {
        return this.getGroupMembersStream(realm, group, null, null);
    }

    public Stream<UserModel> getGroupMembersStream(RealmModel var1, GroupModel var2, Integer var3, Integer var4);

    default public Stream<UserModel> getRoleMembersStream(RealmModel realm, RoleModel role) {
        return this.getRoleMembersStream(realm, role, null, null);
    }

    default public Stream<UserModel> getRoleMembersStream(RealmModel realm, RoleModel role, Integer firstResult, Integer maxResults) {
        return Stream.empty();
    }

    public Stream<UserModel> searchForUserByUserAttributeStream(RealmModel var1, String var2, String var3);

    @Deprecated
    public static interface Streams
    extends UserQueryProvider {
    }
}

