/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;

public class CollectionUtil {
    public static String join(Collection<String> strings) {
        return CollectionUtil.join(strings, ", ");
    }

    public static String join(Collection<String> strings, String separator) {
        Iterator<String> iter = strings.iterator();
        StringBuilder sb = new StringBuilder();
        if (iter.hasNext()) {
            sb.append(iter.next());
            while (iter.hasNext()) {
                sb.append(separator).append(iter.next());
            }
        }
        return sb.toString();
    }

    public static <T> boolean collectionEquals(Collection<T> col1, Collection<T> col2) {
        Integer v;
        if (col1.size() != col2.size()) {
            return false;
        }
        HashMap<T, Integer> countMap = new HashMap<T, Integer>();
        Iterator<Object> iterator = col1.iterator();
        while (iterator.hasNext()) {
            T o;
            v = (Integer)countMap.get(o = iterator.next());
            countMap.put(o, v == null ? 1 : v + 1);
        }
        for (T o : col2) {
            v = (Integer)countMap.get(o);
            if (v == null) {
                return false;
            }
            countMap.put(o, v - 1);
        }
        for (Integer count : countMap.values()) {
            if (count == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionUtil.isEmpty(collection);
    }

    public static <T> Set<T> intersection(Collection<T> col1, Collection<T> col2) {
        if (CollectionUtil.isEmpty(col1) || CollectionUtil.isEmpty(col2)) {
            return Collections.emptySet();
        }
        Collection<T> iteratorCollection = col1.size() <= col2.size() ? col1 : col2;
        Collection<T> searchCollection = iteratorCollection.equals(col1) ? col2 : col1;
        return iteratorCollection.stream().filter(searchCollection::contains).collect(Collectors.toSet());
    }
}

