/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.tomcat;

import java.security.Principal;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.catalina.connector.Request;
import org.apache.catalina.realm.GenericPrincipal;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.AdapterUtils;
import org.keycloak.adapters.CookieTokenStore;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OidcKeycloakAccount;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.tomcat.GenericPrincipalFactory;

public class CatalinaCookieTokenStore
implements AdapterTokenStore {
    private static final Logger log = Logger.getLogger("" + CatalinaCookieTokenStore.class);
    private Request request;
    private HttpFacade facade;
    private KeycloakDeployment deployment;
    private GenericPrincipalFactory principalFactory;
    private KeycloakPrincipal<RefreshableKeycloakSecurityContext> authenticatedPrincipal;

    public CatalinaCookieTokenStore(Request request, HttpFacade facade, KeycloakDeployment deployment, GenericPrincipalFactory principalFactory) {
        this.request = request;
        this.facade = facade;
        this.deployment = deployment;
        this.principalFactory = principalFactory;
    }

    public void checkCurrentToken() {
        this.authenticatedPrincipal = this.checkPrincipalFromCookie();
    }

    public boolean isCached(RequestAuthenticator authenticator) {
        if (this.authenticatedPrincipal != null) {
            log.fine("remote logged in already. Establish state from cookie");
            RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)this.authenticatedPrincipal.getKeycloakSecurityContext();
            if (!securityContext.getRealm().equals(this.deployment.getRealm())) {
                log.fine("Account from cookie is from a different realm than for the request.");
                return false;
            }
            securityContext.setCurrentRequestInfo(this.deployment, (AdapterTokenStore)this);
            Set roles = AdapterUtils.getRolesFromSecurityContext((RefreshableKeycloakSecurityContext)securityContext);
            GenericPrincipal principal = this.principalFactory.createPrincipal(this.request.getContext().getRealm(), this.authenticatedPrincipal, roles);
            this.request.setAttribute(KeycloakSecurityContext.class.getName(), (Object)securityContext);
            this.request.setUserPrincipal((Principal)principal);
            this.request.setAuthType("KEYCLOAK");
            return true;
        }
        return false;
    }

    public void saveAccountInfo(OidcKeycloakAccount account) {
        RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)account.getKeycloakSecurityContext();
        CookieTokenStore.setTokenCookie((KeycloakDeployment)this.deployment, (HttpFacade)this.facade, (RefreshableKeycloakSecurityContext)securityContext);
    }

    public void logout() {
        CookieTokenStore.removeCookie((HttpFacade)this.facade);
    }

    public void refreshCallback(RefreshableKeycloakSecurityContext secContext) {
        CookieTokenStore.setTokenCookie((KeycloakDeployment)this.deployment, (HttpFacade)this.facade, (RefreshableKeycloakSecurityContext)secContext);
    }

    public void saveRequest() {
    }

    public boolean restoreRequest() {
        return false;
    }

    protected KeycloakPrincipal<RefreshableKeycloakSecurityContext> checkPrincipalFromCookie() {
        KeycloakPrincipal principal = CookieTokenStore.getPrincipalFromCookie((KeycloakDeployment)this.deployment, (HttpFacade)this.facade, (AdapterTokenStore)this);
        if (principal == null) {
            log.fine("Account was not in cookie or was invalid");
            return null;
        }
        RefreshableKeycloakSecurityContext session = (RefreshableKeycloakSecurityContext)principal.getKeycloakSecurityContext();
        if (session.isActive() && !session.getDeployment().isAlwaysRefreshToken()) {
            return principal;
        }
        boolean success = session.refreshExpiredToken(false);
        if (success && session.isActive()) {
            return principal;
        }
        log.fine("Cleanup and expire cookie for user " + principal.getName() + " after failed refresh");
        this.request.setUserPrincipal(null);
        this.request.setAuthType(null);
        CookieTokenStore.removeCookie((HttpFacade)this.facade);
        return null;
    }
}

