/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.util;

import java.io.IOException;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.representations.RefreshToken;
import org.keycloak.util.JsonSerialization;

public class TokenUtil {
    public static final String TOKEN_TYPE_BEARER = "Bearer";
    public static final String TOKEN_TYPE_ID = "ID";
    public static final String TOKEN_TYPE_REFRESH = "Refresh";
    public static final String TOKEN_TYPE_OFFLINE = "Offline";

    public static String attachOIDCScope(String scopeParam) {
        if (scopeParam == null || scopeParam.isEmpty()) {
            return "openid";
        }
        return "openid " + scopeParam;
    }

    public static boolean isOIDCRequest(String scopeParam) {
        return TokenUtil.hasScope(scopeParam, "openid");
    }

    public static boolean isOfflineTokenRequested(String scopeParam) {
        return TokenUtil.hasScope(scopeParam, "offline_access");
    }

    public static boolean hasScope(String scopeParam, String targetScope) {
        String[] scopes;
        if (scopeParam == null || targetScope == null) {
            return false;
        }
        for (String scope : scopes = scopeParam.split(" ")) {
            if (!targetScope.equals(scope)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPrompt(String promptParam, String targetPrompt) {
        String[] prompts;
        if (promptParam == null || targetPrompt == null) {
            return false;
        }
        for (String prompt : prompts = promptParam.split(" ")) {
            if (!targetPrompt.equals(prompt)) continue;
            return true;
        }
        return false;
    }

    public static RefreshToken getRefreshToken(byte[] decodedToken) throws JWSInputException {
        try {
            return JsonSerialization.readValue(decodedToken, RefreshToken.class);
        }
        catch (IOException e) {
            throw new JWSInputException(e);
        }
    }

    public static RefreshToken getRefreshToken(String refreshToken) throws JWSInputException {
        byte[] encodedContent = new JWSInput(refreshToken).getContent();
        return TokenUtil.getRefreshToken(encodedContent);
    }

    public static boolean isOfflineToken(String refreshToken) throws JWSInputException {
        RefreshToken token = TokenUtil.getRefreshToken(refreshToken);
        return token.getType().equals(TOKEN_TYPE_OFFLINE);
    }
}

