/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.tomcat7;

import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.realm.GenericPrincipal;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OAuthRequestAuthenticator;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.tomcat7.CatalinaHttpFacade;
import org.keycloak.adapters.tomcat7.CatalinaSecurityContextHelper;
import org.keycloak.adapters.tomcat7.CatalinaUserSessionManagement;
import org.keycloak.adapters.tomcat7.KeycloakAuthenticatorValve;
import org.keycloak.representations.AccessToken;

public class CatalinaRequestAuthenticator
extends RequestAuthenticator {
    private static final Logger log = Logger.getLogger("" + CatalinaRequestAuthenticator.class);
    protected KeycloakAuthenticatorValve valve;
    protected CatalinaUserSessionManagement userSessionManagement;
    protected Request request;

    public CatalinaRequestAuthenticator(KeycloakDeployment deployment, KeycloakAuthenticatorValve valve, CatalinaUserSessionManagement userSessionManagement, CatalinaHttpFacade facade, Request request) {
        super((HttpFacade)facade, deployment, request.getConnector().getRedirectPort());
        this.valve = valve;
        this.userSessionManagement = userSessionManagement;
        this.request = request;
    }

    protected OAuthRequestAuthenticator createOAuthAuthenticator() {
        return new OAuthRequestAuthenticator(this.facade, this.deployment, this.sslRedirectPort){

            protected void saveRequest() {
                try {
                    CatalinaRequestAuthenticator.this.valve.keycloakSaveRequest(CatalinaRequestAuthenticator.this.request);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    protected void completeOAuthAuthentication(KeycloakPrincipal skp, RefreshableKeycloakSecurityContext securityContext) {
        this.request.setAttribute(KeycloakSecurityContext.class.getName(), (Object)securityContext);
        Set<String> roles = this.getRolesFromToken(securityContext);
        GenericPrincipal principal = new CatalinaSecurityContextHelper().createPrincipal(this.request.getContext().getRealm(), (Principal)skp, roles, (KeycloakSecurityContext)securityContext);
        Session session = this.request.getSessionInternal(true);
        session.setPrincipal((Principal)principal);
        session.setAuthType("OAUTH");
        session.setNote(KeycloakSecurityContext.class.getName(), (Object)securityContext);
        String username = securityContext.getToken().getSubject();
        log.finer("userSessionManage.login: " + username);
        this.userSessionManagement.login(session, username, securityContext.getToken().getSessionState());
    }

    protected void completeBearerAuthentication(KeycloakPrincipal principal, RefreshableKeycloakSecurityContext securityContext) {
        Set<String> roles = this.getRolesFromToken(securityContext);
        for (String role : roles) {
            log.info("Bearer role: " + role);
        }
        GenericPrincipal generalPrincipal = new CatalinaSecurityContextHelper().createPrincipal(this.request.getContext().getRealm(), (Principal)principal, roles, (KeycloakSecurityContext)securityContext);
        this.request.setUserPrincipal((Principal)generalPrincipal);
        this.request.setAuthType("KEYCLOAK");
        this.request.setAttribute(KeycloakSecurityContext.class.getName(), (Object)securityContext);
    }

    protected Set<String> getRolesFromToken(RefreshableKeycloakSecurityContext session) {
        Set roles = null;
        if (this.deployment.isUseResourceRoleMappings()) {
            AccessToken.Access access = session.getToken().getResourceAccess(this.deployment.getResourceName());
            if (access != null) {
                roles = access.getRoles();
            }
        } else {
            AccessToken.Access access = session.getToken().getRealmAccess();
            if (access != null) {
                roles = access.getRoles();
            }
        }
        if (roles == null) {
            roles = Collections.emptySet();
        }
        return roles;
    }

    protected boolean isCached() {
        RefreshableKeycloakSecurityContext securityContext;
        if (this.request.getSessionInternal(false) == null || this.request.getSessionInternal().getPrincipal() == null) {
            return false;
        }
        log.finer("remote logged in already");
        GenericPrincipal principal = (GenericPrincipal)this.request.getSessionInternal().getPrincipal();
        this.request.setUserPrincipal((Principal)principal);
        this.request.setAuthType("KEYCLOAK");
        Session session = this.request.getSessionInternal();
        if (session != null && (securityContext = (RefreshableKeycloakSecurityContext)session.getNote(KeycloakSecurityContext.class.getName())) != null) {
            securityContext.setDeployment(this.deployment);
            this.request.setAttribute(KeycloakSecurityContext.class.getName(), (Object)securityContext);
        }
        this.restoreRequest();
        return true;
    }

    protected void restoreRequest() {
        if (this.request.getSessionInternal().getNote("org.apache.catalina.authenticator.REQUEST") != null) {
            if (this.valve.keycloakRestoreRequest(this.request)) {
                log.finer("restoreRequest");
            } else {
                log.finer("Restore of original request failed");
                throw new RuntimeException("Restore of original request failed");
            }
        }
    }
}

