/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.tomcat7;

import java.util.logging.Logger;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.keycloak.adapters.KeycloakDeployment;

public class CorsPreflightChecker {
    private static final Logger log = Logger.getLogger("" + CorsPreflightChecker.class);
    protected KeycloakDeployment deployment;

    public CorsPreflightChecker(KeycloakDeployment deployment) {
        this.deployment = deployment;
    }

    public boolean checkCorsPreflight(Request request, Response response) {
        String allowHeaders;
        log.finer("checkCorsPreflight " + request.getRequestURI());
        if (!request.getMethod().equalsIgnoreCase("OPTIONS")) {
            log.finer("checkCorsPreflight: not options ");
            return false;
        }
        if (request.getHeader("Origin") == null) {
            log.finer("checkCorsPreflight: no origin header");
            return false;
        }
        log.finer("Preflight request returning");
        response.setStatus(200);
        String origin = request.getHeader("Origin");
        response.setHeader("Access-Control-Allow-Origin", origin);
        response.setHeader("Access-Control-Allow-Credentials", "true");
        String requestMethods = request.getHeader("Access-Control-Request-Method");
        if (requestMethods != null) {
            if (this.deployment.getCorsAllowedMethods() != null) {
                requestMethods = this.deployment.getCorsAllowedMethods();
            }
            response.setHeader("Access-Control-Allow-Methods", requestMethods);
        }
        if ((allowHeaders = request.getHeader("Access-Control-Request-Headers")) != null) {
            if (this.deployment.getCorsAllowedHeaders() != null) {
                allowHeaders = this.deployment.getCorsAllowedHeaders();
            }
            response.setHeader("Access-Control-Allow-Headers", allowHeaders);
        }
        if (this.deployment.getCorsMaxAge() > -1) {
            response.setHeader("Access-Control-Max-Age", Integer.toString(this.deployment.getCorsMaxAge()));
        }
        return true;
    }
}

