/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.tomcat7;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.LoginConfig;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.AuthChallenge;
import org.keycloak.adapters.AuthOutcome;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakConfigResolver;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.NodesRegistrationManagement;
import org.keycloak.adapters.PreAuthActionsHandler;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.UserSessionManagement;
import org.keycloak.adapters.tomcat7.AuthenticatedActionsValve;
import org.keycloak.adapters.tomcat7.CatalinaCookieTokenStore;
import org.keycloak.adapters.tomcat7.CatalinaHttpFacade;
import org.keycloak.adapters.tomcat7.CatalinaRequestAuthenticator;
import org.keycloak.adapters.tomcat7.CatalinaSessionTokenStore;
import org.keycloak.adapters.tomcat7.CatalinaUserSessionManagement;
import org.keycloak.adapters.tomcat7.CatalinaUserSessionManagementWrapper;
import org.keycloak.enums.TokenStore;

public class KeycloakAuthenticatorValve
extends FormAuthenticator
implements LifecycleListener {
    public static final String TOKEN_STORE_NOTE = "TOKEN_STORE_NOTE";
    private static final Logger log = Logger.getLogger("" + KeycloakAuthenticatorValve.class);
    protected CatalinaUserSessionManagement userSessionManagement = new CatalinaUserSessionManagement();
    protected AdapterDeploymentContext deploymentContext;
    protected NodesRegistrationManagement nodesRegistrationManagement;

    public void lifecycleEvent(LifecycleEvent event) {
        if ("start".equals(event.getType())) {
            try {
                this.startDeployment();
            }
            catch (LifecycleException e) {
                log.severe("Error starting deployment. " + e.getMessage());
            }
        } else if ("after_start".equals(event.getType())) {
            this.initInternal();
        } else if (event.getType() == "before_stop") {
            this.beforeStop();
        }
    }

    public void logout(Request request) throws ServletException {
        KeycloakSecurityContext ksc = (KeycloakSecurityContext)request.getAttribute(KeycloakSecurityContext.class.getName());
        if (ksc != null) {
            CatalinaHttpFacade facade = new CatalinaHttpFacade(request, null);
            KeycloakDeployment deployment = this.deploymentContext.resolveDeployment((HttpFacade)facade);
            if (ksc instanceof RefreshableKeycloakSecurityContext) {
                ((RefreshableKeycloakSecurityContext)ksc).logout(deployment);
            }
            AdapterTokenStore tokenStore = this.getTokenStore(request, facade, deployment);
            tokenStore.logout();
            request.removeAttribute(KeycloakSecurityContext.class.getName());
        }
        super.logout(request);
    }

    public void startDeployment() throws LifecycleException {
        super.start();
        StandardContext standardContext = (StandardContext)this.context;
        standardContext.addLifecycleListener((LifecycleListener)this);
        this.cache = false;
    }

    public void initInternal() {
        String configResolverClass = this.context.getServletContext().getInitParameter("keycloak.config.resolver");
        if (configResolverClass != null) {
            try {
                KeycloakConfigResolver configResolver = (KeycloakConfigResolver)this.context.getLoader().getClassLoader().loadClass(configResolverClass).newInstance();
                this.deploymentContext = new AdapterDeploymentContext(configResolver);
                log.log(Level.INFO, "Using {0} to resolve Keycloak configuration on a per-request basis.", configResolverClass);
            }
            catch (Exception ex) {
                log.log(Level.FINE, "The specified resolver {0} could NOT be loaded. Keycloak is unconfigured and will deny all requests. Reason: {1}", new Object[]{configResolverClass, ex.getMessage()});
                this.deploymentContext = new AdapterDeploymentContext(new KeycloakDeployment());
            }
        } else {
            KeycloakDeployment kd;
            InputStream configInputStream = KeycloakAuthenticatorValve.getConfigInputStream(this.context);
            if (configInputStream == null) {
                log.fine("No adapter configuration. Keycloak is unconfigured and will deny all requests.");
                kd = new KeycloakDeployment();
            } else {
                kd = KeycloakDeploymentBuilder.build((InputStream)configInputStream);
            }
            this.deploymentContext = new AdapterDeploymentContext(kd);
            log.fine("Keycloak is using a per-deployment configuration.");
        }
        this.context.getServletContext().setAttribute(AdapterDeploymentContext.class.getName(), (Object)this.deploymentContext);
        AuthenticatedActionsValve actions = new AuthenticatedActionsValve(this.deploymentContext, this.getNext(), this.getContainer());
        this.setNext((Valve)actions);
        this.nodesRegistrationManagement = new NodesRegistrationManagement();
    }

    protected void beforeStop() {
        this.nodesRegistrationManagement.stop();
    }

    private static InputStream getJSONFromServletContext(ServletContext servletContext) {
        String json = servletContext.getInitParameter("org.keycloak.json.adapterConfig");
        if (json == null) {
            return null;
        }
        log.finest("**** using org.keycloak.json.adapterConfig");
        log.finest(json);
        return new ByteArrayInputStream(json.getBytes());
    }

    private static InputStream getConfigInputStream(Context context) {
        InputStream is = KeycloakAuthenticatorValve.getJSONFromServletContext(context.getServletContext());
        if (is == null) {
            String path = context.getServletContext().getInitParameter("keycloak.config.file");
            if (path == null) {
                log.finest("**** using /WEB-INF/keycloak.json");
                is = context.getServletContext().getResourceAsStream("/WEB-INF/keycloak.json");
            } else {
                try {
                    is = new FileInputStream(path);
                }
                catch (FileNotFoundException e) {
                    log.severe("NOT FOUND /WEB-INF/keycloak.json");
                    throw new RuntimeException(e);
                }
            }
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        CatalinaHttpFacade facade = new CatalinaHttpFacade(request, (HttpServletResponse)response);
        Manager sessionManager = request.getContext().getManager();
        CatalinaUserSessionManagementWrapper sessionManagementWrapper = new CatalinaUserSessionManagementWrapper(this.userSessionManagement, sessionManager);
        PreAuthActionsHandler handler = new PreAuthActionsHandler((UserSessionManagement)sessionManagementWrapper, this.deploymentContext, (HttpFacade)facade);
        if (handler.handleRequest()) {
            return;
        }
        this.checkKeycloakSession(request, facade);
        super.invoke(request, response);
    }

    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        CatalinaHttpFacade facade = new CatalinaHttpFacade(request, response);
        KeycloakDeployment deployment = this.deploymentContext.resolveDeployment((HttpFacade)facade);
        if (deployment == null || !deployment.isConfigured()) {
            return false;
        }
        AdapterTokenStore tokenStore = this.getTokenStore(request, facade, deployment);
        this.nodesRegistrationManagement.tryRegister(deployment);
        CatalinaRequestAuthenticator authenticator = new CatalinaRequestAuthenticator(deployment, this, tokenStore, facade, request);
        AuthOutcome outcome = authenticator.authenticate();
        if (outcome == AuthOutcome.AUTHENTICATED) {
            return !facade.isEnded();
        }
        AuthChallenge challenge = authenticator.getChallenge();
        if (challenge != null) {
            challenge.challenge((HttpFacade)facade);
        }
        return false;
    }

    protected void checkKeycloakSession(Request request, HttpFacade facade) {
        KeycloakDeployment deployment = this.deploymentContext.resolveDeployment(facade);
        AdapterTokenStore tokenStore = this.getTokenStore(request, facade, deployment);
        tokenStore.checkCurrentToken();
    }

    public void keycloakSaveRequest(Request request) throws IOException {
        this.saveRequest(request, request.getSessionInternal(true));
    }

    public boolean keycloakRestoreRequest(Request request) {
        try {
            return this.restoreRequest(request, request.getSessionInternal());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected AdapterTokenStore getTokenStore(Request request, HttpFacade facade, KeycloakDeployment resolvedDeployment) {
        Object store = (AdapterTokenStore)request.getNote(TOKEN_STORE_NOTE);
        if (store != null) {
            return store;
        }
        store = resolvedDeployment.getTokenStore() == TokenStore.SESSION ? new CatalinaSessionTokenStore(request, resolvedDeployment, this.userSessionManagement) : new CatalinaCookieTokenStore(request, facade, resolvedDeployment);
        request.setNote(TOKEN_STORE_NOTE, store);
        return store;
    }
}

