/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.logging.Logger;
import org.keycloak.SkeletonKeySession;
import org.keycloak.adapters.undertow.KeycloakAuthenticationMechanism;

public class ServletPropagateSessionHandler
implements HttpHandler {
    private static final Logger log = Logger.getLogger(ServletPropagateSessionHandler.class);
    protected HttpHandler next;
    public static final HandlerWrapper WRAPPER = new HandlerWrapper(){

        public HttpHandler wrap(HttpHandler handler) {
            return new ServletPropagateSessionHandler(handler);
        }
    };

    protected ServletPropagateSessionHandler(HttpHandler next) {
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        log.info((Object)"handleRequest");
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequest req = (HttpServletRequest)servletRequestContext.getServletRequest();
        SkeletonKeySession skSession = (SkeletonKeySession)req.getAttribute(SkeletonKeySession.class.getName());
        if (skSession != null) {
            log.info((Object)"skSession is in request");
            this.next.handleRequest(exchange);
            return;
        }
        HttpSession session = req.getSession(false);
        if (session == null) {
            log.info((Object)"http session was null, nothing to propagate");
            this.next.handleRequest(exchange);
            return;
        }
        skSession = (SkeletonKeySession)session.getAttribute(SkeletonKeySession.class.getName());
        if (skSession == null) {
            log.info((Object)"skSession not in http session, nothing to propagate");
            this.next.handleRequest(exchange);
            return;
        }
        log.info((Object)"propagating");
        req.setAttribute(SkeletonKeySession.class.getName(), (Object)skSession);
        exchange.putAttachment(KeycloakAuthenticationMechanism.SKELETON_KEY_SESSION_ATTACHMENT_KEY, (Object)skSession);
        this.next.handleRequest(exchange);
    }
}

