/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.security.PublicKey;
import java.util.HashSet;
import javax.security.cert.X509Certificate;
import org.jboss.logging.Logger;
import org.keycloak.RSATokenVerifier;
import org.keycloak.VerificationException;
import org.keycloak.adapters.ResourceMetadata;
import org.keycloak.adapters.undertow.KeycloakChallenge;
import org.keycloak.representations.SkeletonKeyToken;

public class BearerTokenAuthenticator {
    protected ResourceMetadata resourceMetadata;
    protected Logger log = Logger.getLogger(BearerTokenAuthenticator.class);
    protected String tokenString;
    protected SkeletonKeyToken token;
    protected boolean useResourceRoleMappings;
    protected String surrogate;
    protected KeycloakChallenge challenge;

    public BearerTokenAuthenticator(ResourceMetadata resourceMetadata, boolean useResourceRoleMappings) {
        this.resourceMetadata = resourceMetadata;
        this.useResourceRoleMappings = useResourceRoleMappings;
    }

    public KeycloakChallenge getChallenge() {
        return this.challenge;
    }

    public ResourceMetadata getResourceMetadata() {
        return this.resourceMetadata;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public SkeletonKeyToken getToken() {
        return this.token;
    }

    public String getSurrogate() {
        return this.surrogate;
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange) {
        HeaderValues authHeaders = exchange.getRequestHeaders().get(Headers.AUTHORIZATION);
        if (authHeaders == null || authHeaders.size() == 0) {
            this.challenge = this.challengeResponse(exchange, null, null);
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
        }
        this.tokenString = null;
        for (String authHeader : authHeaders) {
            String[] split = authHeader.trim().split("\\s+");
            if (split == null || split.length != 2 || !split[0].equalsIgnoreCase("Bearer")) continue;
            this.tokenString = split[1];
        }
        if (this.tokenString == null) {
            this.challenge = this.challengeResponse(exchange, null, null);
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
        }
        try {
            this.token = RSATokenVerifier.verifyToken((String)this.tokenString, (PublicKey)this.resourceMetadata.getRealmKey(), (String)this.resourceMetadata.getRealm());
        }
        catch (VerificationException e) {
            this.log.error((Object)"Failed to verify token", (Throwable)e);
            this.challenge = this.challengeResponse(exchange, "invalid_token", e.getMessage());
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        boolean verifyCaller = false;
        HashSet roles = new HashSet();
        verifyCaller = this.useResourceRoleMappings ? this.token.isVerifyCaller(this.resourceMetadata.getResourceName()) : this.token.isVerifyCaller();
        this.surrogate = null;
        if (verifyCaller) {
            if (this.token.getTrustedCertificates() == null || this.token.getTrustedCertificates().size() == 0) {
                this.log.warn((Object)"No trusted certificates in token");
                this.challenge = this.clientCertChallenge();
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
            X509Certificate[] chain = new X509Certificate[]{};
            try {
                chain = exchange.getConnection().getSslSessionInfo().getPeerCertificateChain();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (chain == null || chain.length == 0) {
                this.log.warn((Object)"No certificates provided by undertow to verify the caller");
                this.challenge = this.clientCertChallenge();
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
            this.surrogate = chain[0].getSubjectDN().getName();
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
    }

    protected KeycloakChallenge clientCertChallenge() {
        return new KeycloakChallenge(){

            @Override
            public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange httpServerExchange, SecurityContext securityContext) {
                return new AuthenticationMechanism.ChallengeResult(false);
            }
        };
    }

    protected KeycloakChallenge challengeResponse(HttpServerExchange exchange, String error, String description) {
        StringBuilder header = new StringBuilder("Bearer realm=\"");
        header.append(this.resourceMetadata.getRealm()).append("\"");
        if (error != null) {
            header.append(", error=\"").append(error).append("\"");
        }
        if (description != null) {
            header.append(", error_description=\"").append(description).append("\"");
        }
        String challenge = header.toString();
        exchange.getResponseHeaders().add(Headers.WWW_AUTHENTICATE, challenge);
        return new KeycloakChallenge(){

            @Override
            public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange httpServerExchange, SecurityContext securityContext) {
                return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(401));
            }
        };
    }
}

