/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.handlers.security.CachedAuthenticatedSessionHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import org.jboss.logging.Logger;
import org.keycloak.adapters.KeycloakDeployment;

public class UndertowUserSessionManagement
implements SessionListener {
    private static final Logger log = Logger.getLogger(UndertowUserSessionManagement.class);
    private static final String AUTH_SESSION_NAME = CachedAuthenticatedSessionHandler.class.getName() + ".AuthenticatedSession";
    protected ConcurrentHashMap<String, UserSessions> userSessionMap = new ConcurrentHashMap();
    protected KeycloakDeployment deployment;

    public UndertowUserSessionManagement(KeycloakDeployment deployment) {
        this.deployment = deployment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveSessions() {
        int active = 0;
        ConcurrentHashMap<String, UserSessions> concurrentHashMap = this.userSessionMap;
        synchronized (concurrentHashMap) {
            for (UserSessions sessions : this.userSessionMap.values()) {
                active += sessions.getSessionIds().size();
            }
        }
        return active;
    }

    public Long getUserLoginTime(String username) {
        UserSessions sessions = this.userSessionMap.get(username);
        if (sessions == null) {
            return null;
        }
        return sessions.getLoggedIn();
    }

    public Set<String> getActiveUsers() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.userSessionMap.keySet());
        return set;
    }

    public void login(SessionManager manager, HttpSession session, String username) {
        String sessionId = session.getId();
        this.addAuthenticatedSession(username, sessionId);
        manager.registerSessionListener((SessionListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAuthenticatedSession(String username, String sessionId) {
        ConcurrentHashMap<String, UserSessions> concurrentHashMap = this.userSessionMap;
        synchronized (concurrentHashMap) {
            UserSessions sessions = this.userSessionMap.get(username);
            if (sessions == null) {
                sessions = new UserSessions();
                this.userSessionMap.put(username, sessions);
            }
            sessions.getSessionIds().add(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAuthenticatedSession(String sessionId, String username) {
        ConcurrentHashMap<String, UserSessions> concurrentHashMap = this.userSessionMap;
        synchronized (concurrentHashMap) {
            UserSessions sessions = this.userSessionMap.get(username);
            if (sessions == null) {
                return;
            }
            sessions.getSessionIds().remove(sessionId);
            if (sessions.getSessionIds().isEmpty()) {
                this.userSessionMap.remove(username);
            }
        }
    }

    public void logoutAll(SessionManager manager) {
        ArrayList users = new ArrayList();
        users.addAll(this.userSessionMap.keySet());
        for (String user : users) {
            this.logout(manager, user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(SessionManager manager, String user) {
        log.info((Object)("logoutUser: " + user));
        UserSessions sessions = null;
        ConcurrentHashMap<String, UserSessions> concurrentHashMap = this.userSessionMap;
        synchronized (concurrentHashMap) {
            sessions = this.userSessionMap.remove(user);
        }
        if (sessions == null) {
            log.info((Object)("no session for user: " + user));
            return;
        }
        log.info((Object)"found session for user");
        for (String id : sessions.getSessionIds()) {
            log.debug((Object)("invalidating session for user: " + user));
            Session session = manager.getSession(id);
            try {
                session.invalidate(null);
            }
            catch (Exception e) {
                log.warn((Object)"Session already invalidated.");
            }
        }
    }

    public void sessionCreated(Session session, HttpServerExchange exchange) {
    }

    public void sessionDestroyed(Session session, HttpServerExchange exchange, SessionListener.SessionDestroyedReason reason) {
        String username = this.getUsernameFromSession(session);
        if (username == null) {
            return;
        }
        String sessionId = session.getId();
        this.removeAuthenticatedSession(sessionId, username);
    }

    protected String getUsernameFromSession(Session session) {
        AuthenticatedSessionManager.AuthenticatedSession authSession = (AuthenticatedSessionManager.AuthenticatedSession)session.getAttribute(AUTH_SESSION_NAME);
        if (authSession == null) {
            return null;
        }
        return authSession.getAccount().getPrincipal().getName();
    }

    public void sessionIdChanged(Session session, String oldSessionId) {
        String username = this.getUsernameFromSession(session);
        if (username == null) {
            return;
        }
        this.removeAuthenticatedSession(oldSessionId, username);
        this.addAuthenticatedSession(session.getId(), username);
    }

    public void attributeAdded(Session session, String name, Object value) {
    }

    public void attributeUpdated(Session session, String name, Object newValue, Object oldValue) {
    }

    public void attributeRemoved(Session session, String name, Object oldValue) {
    }

    public static class UserSessions {
        protected Set<String> sessionIds = new HashSet<String>();
        protected long loggedIn = System.currentTimeMillis();

        public Set<String> getSessionIds() {
            return this.sessionIds;
        }

        public long getLoggedIn() {
            return this.loggedIn;
        }
    }
}

