/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.api.SecurityNotification;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Sessions;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.AuthChallenge;
import org.keycloak.adapters.AuthOutcome;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.undertow.KeycloakUndertowAccount;
import org.keycloak.adapters.undertow.UndertowHttpFacade;

public abstract class UndertowKeycloakAuthMech
implements AuthenticationMechanism {
    public static final AttachmentKey<AuthChallenge> KEYCLOAK_CHALLENGE_ATTACHMENT_KEY = AttachmentKey.create(AuthChallenge.class);
    protected AdapterDeploymentContext deploymentContext;

    public UndertowKeycloakAuthMech(AdapterDeploymentContext deploymentContext) {
        this.deploymentContext = deploymentContext;
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        UndertowHttpFacade facade;
        AuthChallenge challenge = (AuthChallenge)exchange.getAttachment(KEYCLOAK_CHALLENGE_ATTACHMENT_KEY);
        if (challenge != null && challenge.challenge((HttpFacade)(facade = new UndertowHttpFacade(exchange)))) {
            return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(exchange.getResponseCode()));
        }
        return new AuthenticationMechanism.ChallengeResult(false);
    }

    protected void registerNotifications(SecurityContext securityContext) {
        NotificationReceiver logoutReceiver = new NotificationReceiver(){

            public void handleNotification(SecurityNotification notification) {
                if (notification.getEventType() != SecurityNotification.EventType.LOGGED_OUT) {
                    return;
                }
                Session session = Sessions.getSession((HttpServerExchange)notification.getExchange());
                if (session == null) {
                    return;
                }
                KeycloakUndertowAccount account = (KeycloakUndertowAccount)session.getAttribute(KeycloakUndertowAccount.class.getName());
                if (account == null) {
                    return;
                }
                session.removeAttribute(KeycloakUndertowAccount.class.getName());
                if (account.getKeycloakSecurityContext() != null) {
                    UndertowHttpFacade facade = new UndertowHttpFacade(notification.getExchange());
                    account.getKeycloakSecurityContext().logout(UndertowKeycloakAuthMech.this.deploymentContext.resolveDeployment((HttpFacade)facade));
                }
            }
        };
        securityContext.registerNotificationReceiver(logoutReceiver);
    }

    protected AuthenticationMechanism.AuthenticationMechanismOutcome keycloakAuthenticate(HttpServerExchange exchange, SecurityContext securityContext, RequestAuthenticator authenticator) {
        AuthOutcome outcome = authenticator.authenticate();
        if (outcome == AuthOutcome.AUTHENTICATED) {
            this.registerNotifications(securityContext);
            return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
        }
        AuthChallenge challenge = authenticator.getChallenge();
        if (challenge != null) {
            exchange.putAttachment(KEYCLOAK_CHALLENGE_ATTACHMENT_KEY, (Object)challenge);
        }
        if (outcome == AuthOutcome.FAILED) {
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }
}

