/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.AuthMethodConfig;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.ServletSessionConfig;
import io.undertow.servlet.util.ImmediateInstanceHandle;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.ServletContext;
import org.jboss.logging.Logger;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.KeycloakConfigResolver;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.NodesRegistrationManagement;
import org.keycloak.adapters.undertow.ServletKeycloakAuthMech;
import org.keycloak.adapters.undertow.ServletPreAuthActionsHandler;
import org.keycloak.adapters.undertow.UndertowAuthenticatedActionsHandler;
import org.keycloak.adapters.undertow.UndertowNodesRegistrationManagementWrapper;
import org.keycloak.adapters.undertow.UndertowUserSessionManagement;

public class KeycloakServletExtension
implements ServletExtension {
    protected static Logger log = Logger.getLogger(KeycloakServletExtension.class);

    public boolean isAuthenticationMechanismPresent(DeploymentInfo deploymentInfo, String mechanismName) {
        LoginConfig loginConfig = deploymentInfo.getLoginConfig();
        if (loginConfig != null) {
            for (AuthMethodConfig method : loginConfig.getAuthMethods()) {
                if (!method.getName().equalsIgnoreCase(mechanismName)) continue;
                return true;
            }
        }
        return false;
    }

    private static InputStream getJSONFromServletContext(ServletContext servletContext) {
        String json = servletContext.getInitParameter("org.keycloak.json.adapterConfig");
        if (json == null) {
            return null;
        }
        return new ByteArrayInputStream(json.getBytes());
    }

    private static InputStream getConfigInputStream(ServletContext context) {
        InputStream is = KeycloakServletExtension.getJSONFromServletContext(context);
        if (is == null) {
            String path = context.getInitParameter("keycloak.config.file");
            if (path == null) {
                log.debug((Object)"using /WEB-INF/keycloak.json");
                is = context.getResourceAsStream("/WEB-INF/keycloak.json");
            } else {
                try {
                    is = new FileInputStream(path);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return is;
    }

    public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
        AdapterDeploymentContext deploymentContext;
        if (!this.isAuthenticationMechanismPresent(deploymentInfo, "KEYCLOAK")) {
            log.debug((Object)"auth-method is not keycloak!");
            return;
        }
        log.debug((Object)"KeycloakServletException initialization");
        String configResolverClass = servletContext.getInitParameter("keycloak.config.resolver");
        if (configResolverClass != null) {
            try {
                KeycloakConfigResolver configResolver = (KeycloakConfigResolver)deploymentInfo.getClassLoader().loadClass(configResolverClass).newInstance();
                deploymentContext = new AdapterDeploymentContext(configResolver);
                log.info((Object)("Using " + configResolverClass + " to resolve Keycloak configuration on a per-request basis."));
            }
            catch (Exception ex) {
                log.warn((Object)("The specified resolver " + configResolverClass + " could NOT be loaded. Keycloak is unconfigured and will deny all requests. Reason: " + ex.getMessage()));
                deploymentContext = new AdapterDeploymentContext(new KeycloakDeployment());
            }
        } else {
            KeycloakDeployment deployment;
            InputStream is = KeycloakServletExtension.getConfigInputStream(servletContext);
            if (is == null) {
                log.warn((Object)"No adapter configuration.  Keycloak is unconfigured and will deny all requests.");
                deployment = new KeycloakDeployment();
            } else {
                deployment = KeycloakDeploymentBuilder.build((InputStream)is);
            }
            deploymentContext = new AdapterDeploymentContext(deployment);
            log.debug((Object)"Keycloak is using a per-deployment configuration.");
        }
        servletContext.setAttribute(AdapterDeploymentContext.class.getName(), (Object)deploymentContext);
        UndertowUserSessionManagement userSessionManagement = new UndertowUserSessionManagement();
        final NodesRegistrationManagement nodesRegistrationManagement = new NodesRegistrationManagement();
        final ServletKeycloakAuthMech mech = this.createAuthenticationMechanism(deploymentInfo, deploymentContext, userSessionManagement, nodesRegistrationManagement);
        UndertowAuthenticatedActionsHandler.Wrapper actions = new UndertowAuthenticatedActionsHandler.Wrapper(deploymentContext);
        deploymentInfo.addOuterHandlerChainWrapper((HandlerWrapper)new ServletPreAuthActionsHandler.Wrapper(deploymentContext, userSessionManagement));
        deploymentInfo.addAuthenticationMechanism("KEYCLOAK", new AuthenticationMechanismFactory(){

            public AuthenticationMechanism create(String s, FormParserFactory formParserFactory, Map<String, String> stringStringMap) {
                return mech;
            }
        });
        deploymentInfo.addInnerHandlerChainWrapper((HandlerWrapper)actions);
        deploymentInfo.setIdentityManager(new IdentityManager(){

            public Account verify(Account account) {
                return account;
            }

            public Account verify(String id, Credential credential) {
                throw new IllegalStateException("Should never be called in Keycloak flow");
            }

            public Account verify(Credential credential) {
                throw new IllegalStateException("Should never be called in Keycloak flow");
            }
        });
        log.debug((Object)("Setting jsession cookie path to: " + deploymentInfo.getContextPath()));
        ServletSessionConfig cookieConfig = new ServletSessionConfig();
        cookieConfig.setPath(deploymentInfo.getContextPath());
        deploymentInfo.setServletSessionConfig(cookieConfig);
        deploymentInfo.addListener(new ListenerInfo(UndertowNodesRegistrationManagementWrapper.class, (InstanceFactory)new InstanceFactory<UndertowNodesRegistrationManagementWrapper>(){

            public InstanceHandle<UndertowNodesRegistrationManagementWrapper> createInstance() throws InstantiationException {
                UndertowNodesRegistrationManagementWrapper listener = new UndertowNodesRegistrationManagementWrapper(nodesRegistrationManagement);
                return new ImmediateInstanceHandle((Object)listener);
            }
        }));
    }

    protected ServletKeycloakAuthMech createAuthenticationMechanism(DeploymentInfo deploymentInfo, AdapterDeploymentContext deploymentContext, UndertowUserSessionManagement userSessionManagement, NodesRegistrationManagement nodesRegistrationManagement) {
        log.debug((Object)"creating ServletKeycloakAuthMech");
        return new ServletKeycloakAuthMech(deploymentContext, userSessionManagement, nodesRegistrationManagement, deploymentInfo.getConfidentialPortManager());
    }
}

