/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.picketlink;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthProviderStatus;
import org.keycloak.authentication.AuthUser;
import org.keycloak.authentication.AuthenticationProvider;
import org.keycloak.authentication.AuthenticationProviderException;
import org.keycloak.models.RealmModel;
import org.keycloak.picketlink.IdentityManagerProvider;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.credential.UsernamePasswordCredentials;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.basic.BasicModel;
import org.picketlink.idm.model.basic.User;

public class PicketlinkAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger logger = Logger.getLogger(PicketlinkAuthenticationProvider.class);
    private final IdentityManagerProvider identityManagerProvider;

    public PicketlinkAuthenticationProvider(IdentityManagerProvider identityManagerProvider) {
        this.identityManagerProvider = identityManagerProvider;
    }

    public String getName() {
        return "picketlink";
    }

    public List<String> getAvailableOptions() {
        return Collections.EMPTY_LIST;
    }

    public AuthUser getUser(RealmModel realm, Map<String, String> configuration, String username) throws AuthenticationProviderException {
        IdentityManager identityManager = this.getIdentityManager(realm);
        try {
            User picketlinkUser = BasicModel.getUser((IdentityManager)identityManager, (String)username);
            return picketlinkUser == null ? null : new AuthUser(picketlinkUser.getId(), picketlinkUser.getLoginName(), this.getName()).setName(picketlinkUser.getFirstName(), picketlinkUser.getLastName()).setEmail(picketlinkUser.getEmail()).setProviderName(this.getName());
        }
        catch (IdentityManagementException ie) {
            throw this.convertIDMException(ie);
        }
    }

    public String registerUser(RealmModel realm, Map<String, String> configuration, String username) throws AuthenticationProviderException {
        IdentityManager identityManager = this.getIdentityManager(realm);
        try {
            User picketlinkUser = new User(username);
            identityManager.add((IdentityType)picketlinkUser);
            return picketlinkUser.getId();
        }
        catch (IdentityManagementException ie) {
            throw this.convertIDMException(ie);
        }
    }

    public AuthProviderStatus validatePassword(RealmModel realm, Map<String, String> configuration, String username, String password) throws AuthenticationProviderException {
        IdentityManager identityManager = this.getIdentityManager(realm);
        try {
            UsernamePasswordCredentials credential = new UsernamePasswordCredentials();
            credential.setUsername(username);
            credential.setPassword(new Password(password.toCharArray()));
            identityManager.validateCredentials((Credentials)credential);
            if (credential.getStatus() == Credentials.Status.VALID) {
                return AuthProviderStatus.SUCCESS;
            }
            return AuthProviderStatus.INVALID_CREDENTIALS;
        }
        catch (IdentityManagementException ie) {
            throw this.convertIDMException(ie);
        }
    }

    public boolean updateCredential(RealmModel realm, Map<String, String> configuration, String username, String password) throws AuthenticationProviderException {
        IdentityManager identityManager = this.getIdentityManager(realm);
        try {
            User picketlinkUser = BasicModel.getUser((IdentityManager)identityManager, (String)username);
            if (picketlinkUser == null) {
                logger.debugf("User '%s' doesn't exists. Skip password update", (Object)username);
                return false;
            }
            identityManager.updateCredential((Account)picketlinkUser, (Object)new Password(password.toCharArray()));
            return true;
        }
        catch (IdentityManagementException ie) {
            throw this.convertIDMException(ie);
        }
    }

    public void close() {
    }

    public IdentityManager getIdentityManager(RealmModel realm) throws AuthenticationProviderException {
        return this.identityManagerProvider.getIdentityManager(realm);
    }

    private AuthenticationProviderException convertIDMException(IdentityManagementException ie) {
        Throwable realCause = ie;
        while (realCause.getCause() != null) {
            realCause = realCause.getCause();
        }
        return new AuthenticationProviderException(realCause.getMessage(), (Throwable)ie);
    }
}

