/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.AuthenticationLinkModel;
import org.keycloak.models.AuthenticationProviderModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UsernameLoginFailureModel;
import org.keycloak.models.jpa.ApplicationAdapter;
import org.keycloak.models.jpa.ClientAdapter;
import org.keycloak.models.jpa.OAuthClientAdapter;
import org.keycloak.models.jpa.RoleAdapter;
import org.keycloak.models.jpa.UserAdapter;
import org.keycloak.models.jpa.UserSessionAdapter;
import org.keycloak.models.jpa.UsernameLoginFailureAdapter;
import org.keycloak.models.jpa.entities.ApplicationEntity;
import org.keycloak.models.jpa.entities.ApplicationRoleEntity;
import org.keycloak.models.jpa.entities.AuthenticationLinkEntity;
import org.keycloak.models.jpa.entities.AuthenticationProviderEntity;
import org.keycloak.models.jpa.entities.CredentialEntity;
import org.keycloak.models.jpa.entities.OAuthClientEntity;
import org.keycloak.models.jpa.entities.RealmEntity;
import org.keycloak.models.jpa.entities.RealmRoleEntity;
import org.keycloak.models.jpa.entities.RequiredCredentialEntity;
import org.keycloak.models.jpa.entities.RoleEntity;
import org.keycloak.models.jpa.entities.ScopeMappingEntity;
import org.keycloak.models.jpa.entities.SocialLinkEntity;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.models.jpa.entities.UserRoleMappingEntity;
import org.keycloak.models.jpa.entities.UserSessionEntity;
import org.keycloak.models.jpa.entities.UsernameLoginFailureEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.Pbkdf2PasswordEncoder;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.util.Time;

public class RealmAdapter
implements RealmModel {
    protected RealmEntity realm;
    protected EntityManager em;
    protected volatile transient PublicKey publicKey;
    protected volatile transient PrivateKey privateKey;
    private PasswordPolicy passwordPolicy;

    public RealmAdapter(EntityManager em, RealmEntity realm) {
        this.em = em;
        this.realm = realm;
    }

    public RealmEntity getEntity() {
        return this.realm;
    }

    public String getId() {
        return this.realm.getId();
    }

    public String getName() {
        return this.realm.getName();
    }

    public void setName(String name) {
        this.realm.setName(name);
        this.em.flush();
    }

    public boolean isEnabled() {
        return this.realm.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.realm.setEnabled(enabled);
        this.em.flush();
    }

    public boolean isSslNotRequired() {
        return this.realm.isSslNotRequired();
    }

    public void setSslNotRequired(boolean sslNotRequired) {
        this.realm.setSslNotRequired(sslNotRequired);
        this.em.flush();
    }

    public boolean isPasswordCredentialGrantAllowed() {
        return this.realm.isPasswordCredentialGrantAllowed();
    }

    public void setPasswordCredentialGrantAllowed(boolean passwordCredentialGrantAllowed) {
        this.realm.setPasswordCredentialGrantAllowed(passwordCredentialGrantAllowed);
        this.em.flush();
    }

    public boolean isRegistrationAllowed() {
        return this.realm.isRegistrationAllowed();
    }

    public void setRegistrationAllowed(boolean registrationAllowed) {
        this.realm.setRegistrationAllowed(registrationAllowed);
        this.em.flush();
    }

    public boolean isRememberMe() {
        return this.realm.isRememberMe();
    }

    public void setRememberMe(boolean rememberMe) {
        this.realm.setRememberMe(rememberMe);
        this.em.flush();
    }

    public boolean isBruteForceProtected() {
        return this.realm.isBruteForceProtected();
    }

    public void setBruteForceProtected(boolean value) {
        this.realm.setBruteForceProtected(value);
    }

    public int getMaxFailureWaitSeconds() {
        return this.realm.getMaxFailureWaitSeconds();
    }

    public void setMaxFailureWaitSeconds(int val) {
        this.realm.setMaxFailureWaitSeconds(val);
    }

    public int getWaitIncrementSeconds() {
        return this.realm.getWaitIncrementSeconds();
    }

    public void setWaitIncrementSeconds(int val) {
        this.realm.setWaitIncrementSeconds(val);
    }

    public long getQuickLoginCheckMilliSeconds() {
        return this.realm.getQuickLoginCheckMilliSeconds();
    }

    public void setQuickLoginCheckMilliSeconds(long val) {
        this.realm.setQuickLoginCheckMilliSeconds(val);
    }

    public int getMinimumQuickLoginWaitSeconds() {
        return this.realm.getMinimumQuickLoginWaitSeconds();
    }

    public void setMinimumQuickLoginWaitSeconds(int val) {
        this.realm.setMinimumQuickLoginWaitSeconds(val);
    }

    public int getMaxDeltaTimeSeconds() {
        return this.realm.getMaxDeltaTimeSeconds();
    }

    public void setMaxDeltaTimeSeconds(int val) {
        this.realm.setMaxDeltaTimeSeconds(val);
    }

    public int getFailureFactor() {
        return this.realm.getFailureFactor();
    }

    public void setFailureFactor(int failureFactor) {
        this.realm.setFailureFactor(failureFactor);
    }

    public boolean isVerifyEmail() {
        return this.realm.isVerifyEmail();
    }

    public void setVerifyEmail(boolean verifyEmail) {
        this.realm.setVerifyEmail(verifyEmail);
        this.em.flush();
    }

    public boolean isResetPasswordAllowed() {
        return this.realm.isResetPasswordAllowed();
    }

    public void setResetPasswordAllowed(boolean resetPasswordAllowed) {
        this.realm.setResetPasswordAllowed(resetPasswordAllowed);
        this.em.flush();
    }

    public int getNotBefore() {
        return this.realm.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.realm.setNotBefore(notBefore);
    }

    public int getAccessTokenLifespan() {
        return this.realm.getAccessTokenLifespan();
    }

    public void setAccessTokenLifespan(int tokenLifespan) {
        this.realm.setAccessTokenLifespan(tokenLifespan);
        this.em.flush();
    }

    public int getSsoSessionIdleTimeout() {
        return this.realm.getSsoSessionIdleTimeout();
    }

    public void setSsoSessionIdleTimeout(int seconds) {
        this.realm.setSsoSessionIdleTimeout(seconds);
    }

    public int getSsoSessionMaxLifespan() {
        return this.realm.getSsoSessionMaxLifespan();
    }

    public void setSsoSessionMaxLifespan(int seconds) {
        this.realm.setSsoSessionMaxLifespan(seconds);
    }

    public int getAccessCodeLifespan() {
        return this.realm.getAccessCodeLifespan();
    }

    public void setAccessCodeLifespan(int accessCodeLifespan) {
        this.realm.setAccessCodeLifespan(accessCodeLifespan);
        this.em.flush();
    }

    public int getAccessCodeLifespanUserAction() {
        return this.realm.getAccessCodeLifespanUserAction();
    }

    public void setAccessCodeLifespanUserAction(int accessCodeLifespanUserAction) {
        this.realm.setAccessCodeLifespanUserAction(accessCodeLifespanUserAction);
        this.em.flush();
    }

    public String getPublicKeyPem() {
        return this.realm.getPublicKeyPem();
    }

    public void setPublicKeyPem(String publicKeyPem) {
        this.realm.setPublicKeyPem(publicKeyPem);
        this.em.flush();
    }

    public String getPrivateKeyPem() {
        return this.realm.getPrivateKeyPem();
    }

    public void setPrivateKeyPem(String privateKeyPem) {
        this.realm.setPrivateKeyPem(privateKeyPem);
        this.em.flush();
    }

    public PublicKey getPublicKey() {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        this.publicKey = KeycloakModelUtils.getPublicKey((String)this.getPublicKeyPem());
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        String publicKeyPem = KeycloakModelUtils.getPemFromKey((Key)publicKey);
        this.setPublicKeyPem(publicKeyPem);
    }

    public PrivateKey getPrivateKey() {
        if (this.privateKey != null) {
            return this.privateKey;
        }
        this.privateKey = KeycloakModelUtils.getPrivateKey((String)this.getPrivateKeyPem());
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        String privateKeyPem = KeycloakModelUtils.getPemFromKey((Key)privateKey);
        this.setPrivateKeyPem(privateKeyPem);
    }

    protected RequiredCredentialModel initRequiredCredentialModel(String type) {
        RequiredCredentialModel model = (RequiredCredentialModel)RequiredCredentialModel.BUILT_IN.get(type);
        if (model == null) {
            throw new RuntimeException("Unknown credential type " + type);
        }
        return model;
    }

    public void addRequiredCredential(String type) {
        RequiredCredentialModel model = this.initRequiredCredentialModel(type);
        this.addRequiredCredential(model);
        this.em.flush();
    }

    public void addRequiredCredential(RequiredCredentialModel model) {
        RequiredCredentialEntity entity = new RequiredCredentialEntity();
        entity.setInput(model.isInput());
        entity.setSecret(model.isSecret());
        entity.setType(model.getType());
        entity.setFormLabel(model.getFormLabel());
        this.em.persist((Object)entity);
        this.realm.getRequiredCredentials().add(entity);
        this.em.flush();
    }

    public void updateRequiredCredentials(Set<String> creds) {
        Collection<RequiredCredentialEntity> relationships = this.realm.getRequiredCredentials();
        if (relationships == null) {
            relationships = new ArrayList<RequiredCredentialEntity>();
        }
        HashSet<String> already = new HashSet<String>();
        ArrayList<RequiredCredentialEntity> remove = new ArrayList<RequiredCredentialEntity>();
        for (RequiredCredentialEntity rel : relationships) {
            if (!creds.contains(rel.getType())) {
                remove.add(rel);
                continue;
            }
            already.add(rel.getType());
        }
        for (RequiredCredentialEntity entity : remove) {
            relationships.remove(entity);
            this.em.remove((Object)entity);
        }
        for (String cred : creds) {
            if (already.contains(cred)) continue;
            this.addRequiredCredential(cred);
        }
        this.em.flush();
    }

    public List<RequiredCredentialModel> getRequiredCredentials() {
        ArrayList<RequiredCredentialModel> requiredCredentialModels = new ArrayList<RequiredCredentialModel>();
        Collection<RequiredCredentialEntity> entities = this.realm.getRequiredCredentials();
        if (entities == null) {
            return requiredCredentialModels;
        }
        for (RequiredCredentialEntity entity : entities) {
            RequiredCredentialModel model = new RequiredCredentialModel();
            model.setFormLabel(entity.getFormLabel());
            model.setType(entity.getType());
            model.setSecret(entity.isSecret());
            model.setInput(entity.isInput());
            requiredCredentialModels.add(model);
        }
        return requiredCredentialModels;
    }

    public UserModel getUser(String name) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserByLoginName", UserEntity.class);
        query.setParameter("loginName", (Object)name);
        query.setParameter("realm", (Object)this.realm);
        List results = query.getResultList();
        if (results.size() == 0) {
            return null;
        }
        return new UserAdapter((UserEntity)results.get(0));
    }

    public UsernameLoginFailureModel getUserLoginFailure(String username) {
        String id = username + "-" + this.realm.getId();
        UsernameLoginFailureEntity entity = (UsernameLoginFailureEntity)this.em.find(UsernameLoginFailureEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        return new UsernameLoginFailureAdapter(entity);
    }

    public UsernameLoginFailureModel addUserLoginFailure(String username) {
        UsernameLoginFailureModel model = this.getUserLoginFailure(username);
        if (model != null) {
            return model;
        }
        String id = username + "-" + this.realm.getId();
        UsernameLoginFailureEntity entity = new UsernameLoginFailureEntity();
        entity.setId(id);
        entity.setUsername(username);
        entity.setRealm(this.realm);
        this.em.persist((Object)entity);
        return new UsernameLoginFailureAdapter(entity);
    }

    public List<UsernameLoginFailureModel> getAllUserLoginFailures() {
        TypedQuery query = this.em.createNamedQuery("getAllFailures", UsernameLoginFailureEntity.class);
        List entities = query.getResultList();
        ArrayList<UsernameLoginFailureModel> models = new ArrayList<UsernameLoginFailureModel>();
        for (UsernameLoginFailureEntity entity : entities) {
            models.add(new UsernameLoginFailureAdapter(entity));
        }
        return models;
    }

    public UserModel getUserByEmail(String email) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserByEmail", UserEntity.class);
        query.setParameter("email", (Object)email);
        query.setParameter("realm", (Object)this.realm);
        List results = query.getResultList();
        return results.isEmpty() ? null : new UserAdapter((UserEntity)results.get(0));
    }

    public UserModel getUserById(String id) {
        UserEntity entity = (UserEntity)this.em.find(UserEntity.class, (Object)id);
        if (entity == null || !this.realm.equals(entity.getRealm())) {
            return null;
        }
        return new UserAdapter(entity);
    }

    public UserModel addUser(String username) {
        return this.addUser(KeycloakModelUtils.generateId(), username);
    }

    public UserModel addUser(String id, String username) {
        UserEntity entity = new UserEntity();
        entity.setId(id);
        entity.setLoginName(username);
        entity.setRealm(this.realm);
        this.em.persist((Object)entity);
        this.em.flush();
        UserAdapter userModel = new UserAdapter(entity);
        for (String r : this.getDefaultRoles()) {
            this.grantRole(userModel, this.getRole(r));
        }
        for (ApplicationModel application : this.getApplications()) {
            for (String r : application.getDefaultRoles()) {
                this.grantRole(userModel, application.getRole(r));
            }
        }
        return userModel;
    }

    public boolean removeUser(String name) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserByLoginName", UserEntity.class);
        query.setParameter("loginName", (Object)name);
        query.setParameter("realm", (Object)this.realm);
        List results = query.getResultList();
        if (results.size() == 0) {
            return false;
        }
        this.removeUser((UserEntity)results.get(0));
        return true;
    }

    private void removeUser(UserEntity user) {
        this.removeUserSessions(user);
        this.em.createQuery("delete from " + UserRoleMappingEntity.class.getSimpleName() + " where user = :user").setParameter("user", (Object)user).executeUpdate();
        this.em.createQuery("delete from " + SocialLinkEntity.class.getSimpleName() + " where user = :user").setParameter("user", (Object)user).executeUpdate();
        if (user.getAuthenticationLink() != null) {
            this.em.remove((Object)user.getAuthenticationLink());
        }
        this.em.remove((Object)user);
    }

    public List<String> getDefaultRoles() {
        Collection<RoleEntity> entities = this.realm.getDefaultRoles();
        ArrayList<String> roles = new ArrayList<String>();
        if (entities == null) {
            return roles;
        }
        for (RoleEntity entity : entities) {
            roles.add(entity.getName());
        }
        return roles;
    }

    public void addDefaultRole(String name) {
        RoleModel role = this.getRole(name);
        if (role == null) {
            role = this.addRole(name);
        }
        Collection<RoleEntity> entities = this.realm.getDefaultRoles();
        for (RoleEntity entity : entities) {
            if (!entity.getId().equals(role.getId())) continue;
            return;
        }
        entities.add(((RoleAdapter)role).getRole());
        this.em.flush();
    }

    public static boolean contains(String str, String[] array) {
        for (String s : array) {
            if (!str.equals(s)) continue;
            return true;
        }
        return false;
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        Collection<RoleEntity> entities = this.realm.getDefaultRoles();
        HashSet<String> already = new HashSet<String>();
        ArrayList<RoleEntity> remove = new ArrayList<RoleEntity>();
        for (RoleEntity rel : entities) {
            if (!RealmAdapter.contains(rel.getName(), defaultRoles)) {
                remove.add(rel);
                continue;
            }
            already.add(rel.getName());
        }
        for (RoleEntity entity : remove) {
            entities.remove(entity);
        }
        this.em.flush();
        for (String roleName : defaultRoles) {
            if (already.contains(roleName)) continue;
            this.addDefaultRole(roleName);
        }
        this.em.flush();
    }

    public ClientModel findClient(String clientId) {
        ApplicationModel model = this.getApplicationByName(clientId);
        if (model != null) {
            return model;
        }
        return this.getOAuthClient(clientId);
    }

    public ClientModel findClientById(String id) {
        ApplicationModel model = this.getApplicationById(id);
        if (model != null) {
            return model;
        }
        return this.getOAuthClientById(id);
    }

    public Map<String, ApplicationModel> getApplicationNameMap() {
        HashMap<String, ApplicationModel> map = new HashMap<String, ApplicationModel>();
        for (ApplicationModel app : this.getApplications()) {
            map.put(app.getName(), app);
        }
        return map;
    }

    public List<ApplicationModel> getApplications() {
        ArrayList<ApplicationModel> list = new ArrayList<ApplicationModel>();
        if (this.realm.getApplications() == null) {
            return list;
        }
        for (ApplicationEntity entity : this.realm.getApplications()) {
            list.add(new ApplicationAdapter((RealmModel)this, this.em, entity));
        }
        return list;
    }

    public ApplicationModel addApplication(String name) {
        return this.addApplication(KeycloakModelUtils.generateId(), name);
    }

    public ApplicationModel addApplication(String id, String name) {
        ApplicationEntity applicationData = new ApplicationEntity();
        applicationData.setId(id);
        applicationData.setName(name);
        applicationData.setEnabled(true);
        applicationData.setRealm(this.realm);
        this.realm.getApplications().add(applicationData);
        this.em.persist((Object)applicationData);
        this.em.flush();
        ApplicationAdapter resource = new ApplicationAdapter((RealmModel)this, this.em, applicationData);
        this.em.flush();
        return resource;
    }

    public boolean removeApplication(String id) {
        if (id == null) {
            return false;
        }
        ApplicationModel application = this.getApplicationById(id);
        if (application == null) {
            return false;
        }
        ((ApplicationAdapter)application).deleteUserSessionAssociation();
        for (RoleModel role : application.getRoles()) {
            application.removeRole(role);
        }
        ApplicationEntity applicationEntity = null;
        Iterator<ApplicationEntity> it = this.realm.getApplications().iterator();
        while (it.hasNext()) {
            ApplicationEntity ae = it.next();
            if (!ae.getId().equals(id)) continue;
            applicationEntity = ae;
            it.remove();
            break;
        }
        for (ApplicationEntity a : this.realm.getApplications()) {
            if (!a.getId().equals(id)) continue;
            applicationEntity = a;
        }
        if (application == null) {
            return false;
        }
        this.em.remove((Object)applicationEntity);
        this.em.createQuery("delete from " + ScopeMappingEntity.class.getSimpleName() + " where client = :client").setParameter("client", (Object)applicationEntity).executeUpdate();
        return true;
    }

    public ApplicationModel getApplicationById(String id) {
        ApplicationEntity app = (ApplicationEntity)this.em.find(ApplicationEntity.class, (Object)id);
        if (app == null || !this.realm.equals(app.getRealm())) {
            return null;
        }
        return new ApplicationAdapter((RealmModel)this, this.em, app);
    }

    public ApplicationModel getApplicationByName(String name) {
        return this.getApplicationNameMap().get(name);
    }

    public UserModel getUserBySocialLink(SocialLinkModel socialLink) {
        TypedQuery query = this.em.createNamedQuery("findUserByLinkAndRealm", UserEntity.class);
        query.setParameter("realm", (Object)this.realm);
        query.setParameter("socialProvider", (Object)socialLink.getSocialProvider());
        query.setParameter("socialUserId", (Object)socialLink.getSocialUserId());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More results found for socialProvider=" + socialLink.getSocialProvider() + ", socialUserId=" + socialLink.getSocialUserId() + ", results=" + results);
        }
        UserEntity user = (UserEntity)results.get(0);
        return new UserAdapter(user);
    }

    public Set<SocialLinkModel> getSocialLinks(UserModel user) {
        TypedQuery query = this.em.createNamedQuery("findSocialLinkByUser", SocialLinkEntity.class);
        query.setParameter("user", (Object)((UserAdapter)user).getUser());
        List results = query.getResultList();
        HashSet<SocialLinkModel> set = new HashSet<SocialLinkModel>();
        for (SocialLinkEntity entity : results) {
            set.add(new SocialLinkModel(entity.getSocialProvider(), entity.getSocialUserId(), entity.getSocialUsername()));
        }
        return set;
    }

    public SocialLinkModel getSocialLink(UserModel user, String socialProvider) {
        SocialLinkEntity entity = this.findSocialLink(user, socialProvider);
        return entity != null ? new SocialLinkModel(entity.getSocialProvider(), entity.getSocialUserId(), entity.getSocialUsername()) : null;
    }

    public void addSocialLink(UserModel user, SocialLinkModel socialLink) {
        SocialLinkEntity entity = new SocialLinkEntity();
        entity.setRealm(this.realm);
        entity.setSocialProvider(socialLink.getSocialProvider());
        entity.setSocialUserId(socialLink.getSocialUserId());
        entity.setSocialUsername(socialLink.getSocialUsername());
        entity.setUser(((UserAdapter)user).getUser());
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public boolean removeSocialLink(UserModel user, String socialProvider) {
        SocialLinkEntity entity = this.findSocialLink(user, socialProvider);
        if (entity != null) {
            this.em.remove((Object)entity);
            this.em.flush();
            return true;
        }
        return false;
    }

    private SocialLinkEntity findSocialLink(UserModel user, String socialProvider) {
        TypedQuery query = this.em.createNamedQuery("findSocialLinkByUserAndProvider", SocialLinkEntity.class);
        query.setParameter("user", (Object)((UserAdapter)user).getUser());
        query.setParameter("socialProvider", (Object)socialProvider);
        List results = query.getResultList();
        return results.size() > 0 ? (SocialLinkEntity)results.get(0) : null;
    }

    public AuthenticationLinkModel getAuthenticationLink(UserModel user) {
        UserEntity userEntity = ((UserAdapter)user).getUser();
        AuthenticationLinkEntity authLinkEntity = userEntity.getAuthenticationLink();
        return authLinkEntity == null ? null : new AuthenticationLinkModel(authLinkEntity.getAuthProvider(), authLinkEntity.getAuthUserId());
    }

    public void setAuthenticationLink(UserModel user, AuthenticationLinkModel authenticationLink) {
        AuthenticationLinkEntity entity = new AuthenticationLinkEntity();
        entity.setAuthProvider(authenticationLink.getAuthProvider());
        entity.setAuthUserId(authenticationLink.getAuthUserId());
        UserEntity userEntity = ((UserAdapter)user).getUser();
        userEntity.setAuthenticationLink(entity);
        this.em.persist((Object)entity);
        this.em.persist((Object)userEntity);
        this.em.flush();
    }

    public boolean isSocial() {
        return this.realm.isSocial();
    }

    public void setSocial(boolean social) {
        this.realm.setSocial(social);
        this.em.flush();
    }

    public boolean isUpdateProfileOnInitialSocialLogin() {
        return this.realm.isUpdateProfileOnInitialSocialLogin();
    }

    public void setUpdateProfileOnInitialSocialLogin(boolean updateProfileOnInitialSocialLogin) {
        this.realm.setUpdateProfileOnInitialSocialLogin(updateProfileOnInitialSocialLogin);
        this.em.flush();
    }

    public List<UserModel> getUsers() {
        TypedQuery query = this.em.createQuery("select u from UserEntity u where u.realm = :realm", UserEntity.class);
        query.setParameter("realm", (Object)this.realm);
        List results = query.getResultList();
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (UserEntity entity : results) {
            users.add(new UserAdapter(entity));
        }
        return users;
    }

    public List<UserModel> searchForUser(String search) {
        TypedQuery query = this.em.createQuery("select u from UserEntity u where u.realm = :realm and ( lower(u.loginName) like :search or lower(concat(u.firstName, ' ', u.lastName)) like :search or u.email like :search )", UserEntity.class);
        query.setParameter("realm", (Object)this.realm);
        query.setParameter("search", (Object)("%" + search.toLowerCase() + "%"));
        List results = query.getResultList();
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (UserEntity entity : results) {
            users.add(new UserAdapter(entity));
        }
        return users;
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes) {
        StringBuilder builder = new StringBuilder("select u from UserEntity u");
        boolean first = true;
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String attribute = null;
            if (entry.getKey().equals("username")) {
                attribute = "lower(loginName)";
            } else if (entry.getKey().equalsIgnoreCase("firstName")) {
                attribute = "lower(firstName)";
            } else if (entry.getKey().equalsIgnoreCase("lastName")) {
                attribute = "lower(lastName)";
            } else if (entry.getKey().equalsIgnoreCase("email")) {
                attribute = "lower(email)";
            }
            if (attribute == null) continue;
            if (first) {
                first = false;
                builder.append(" where ");
            } else {
                builder.append(" and ");
            }
            builder.append(attribute).append(" like '%").append(entry.getValue().toLowerCase()).append("%'");
        }
        String q = builder.toString();
        TypedQuery query = this.em.createQuery(q, UserEntity.class);
        List results = query.getResultList();
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (UserEntity entity : results) {
            users.add(new UserAdapter(entity));
        }
        return users;
    }

    public OAuthClientModel addOAuthClient(String name) {
        return this.addOAuthClient(KeycloakModelUtils.generateId(), name);
    }

    public OAuthClientModel addOAuthClient(String id, String name) {
        OAuthClientEntity data = new OAuthClientEntity();
        data.setId(id);
        data.setEnabled(true);
        data.setName(name);
        data.setRealm(this.realm);
        this.em.persist((Object)data);
        this.em.flush();
        return new OAuthClientAdapter((RealmModel)this, data, this.em);
    }

    public boolean removeOAuthClient(String id) {
        OAuthClientModel oauth = this.getOAuthClientById(id);
        if (oauth == null) {
            return false;
        }
        ((OAuthClientAdapter)oauth).deleteUserSessionAssociation();
        OAuthClientEntity client = (OAuthClientEntity)((OAuthClientAdapter)oauth).getEntity();
        this.em.createQuery("delete from " + ScopeMappingEntity.class.getSimpleName() + " where client = :client").setParameter("client", (Object)client).executeUpdate();
        this.em.remove((Object)client);
        return true;
    }

    public OAuthClientModel getOAuthClient(String name) {
        TypedQuery query = this.em.createNamedQuery("findOAuthClientByName", OAuthClientEntity.class);
        query.setParameter("name", (Object)name);
        query.setParameter("realm", (Object)this.realm);
        List entities = query.getResultList();
        if (entities.size() == 0) {
            return null;
        }
        return new OAuthClientAdapter((RealmModel)this, (OAuthClientEntity)entities.get(0), this.em);
    }

    public OAuthClientModel getOAuthClientById(String id) {
        OAuthClientEntity client = (OAuthClientEntity)this.em.find(OAuthClientEntity.class, (Object)id);
        if (client == null || !this.realm.getId().equals(client.getRealm().getId())) {
            return null;
        }
        return new OAuthClientAdapter((RealmModel)this, client, this.em);
    }

    public List<OAuthClientModel> getOAuthClients() {
        TypedQuery query = this.em.createNamedQuery("findOAuthClientByRealm", OAuthClientEntity.class);
        query.setParameter("realm", (Object)this.realm);
        List entities = query.getResultList();
        ArrayList<OAuthClientModel> list = new ArrayList<OAuthClientModel>();
        for (OAuthClientEntity entity : entities) {
            list.add(new OAuthClientAdapter((RealmModel)this, entity, this.em));
        }
        return list;
    }

    public Map<String, String> getSmtpConfig() {
        return this.realm.getSmtpConfig();
    }

    public void setSmtpConfig(Map<String, String> smtpConfig) {
        this.realm.setSmtpConfig(smtpConfig);
        this.em.flush();
    }

    public Map<String, String> getSocialConfig() {
        return this.realm.getSocialConfig();
    }

    public void setSocialConfig(Map<String, String> socialConfig) {
        this.realm.setSocialConfig(socialConfig);
        this.em.flush();
    }

    public Map<String, String> getLdapServerConfig() {
        return this.realm.getLdapServerConfig();
    }

    public void setLdapServerConfig(Map<String, String> ldapServerConfig) {
        this.realm.setLdapServerConfig(ldapServerConfig);
        this.em.flush();
    }

    public List<AuthenticationProviderModel> getAuthenticationProviders() {
        List<AuthenticationProviderEntity> entities = this.realm.getAuthenticationProviders();
        Collections.sort(entities, new Comparator<AuthenticationProviderEntity>(){

            @Override
            public int compare(AuthenticationProviderEntity o1, AuthenticationProviderEntity o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        ArrayList<AuthenticationProviderModel> result = new ArrayList<AuthenticationProviderModel>();
        for (AuthenticationProviderEntity entity : entities) {
            result.add(new AuthenticationProviderModel(entity.getProviderName(), entity.isPasswordUpdateSupported(), entity.getConfig()));
        }
        return result;
    }

    public void setAuthenticationProviders(List<AuthenticationProviderModel> authenticationProviders) {
        ArrayList<AuthenticationProviderEntity> newEntities = new ArrayList<AuthenticationProviderEntity>();
        int counter = 1;
        for (AuthenticationProviderModel model : authenticationProviders) {
            AuthenticationProviderEntity entity = new AuthenticationProviderEntity();
            entity.setProviderName(model.getProviderName());
            entity.setPasswordUpdateSupported(model.isPasswordUpdateSupported());
            entity.setConfig(model.getConfig());
            entity.setPriority(counter++);
            newEntities.add(entity);
        }
        List<AuthenticationProviderEntity> existing = this.realm.getAuthenticationProviders();
        ArrayList<AuthenticationProviderEntity> copy = new ArrayList<AuthenticationProviderEntity>(existing);
        for (AuthenticationProviderEntity apToRemove : copy) {
            existing.remove(apToRemove);
            this.em.remove((Object)apToRemove);
        }
        for (AuthenticationProviderEntity apToAdd : newEntities) {
            existing.add(apToAdd);
            this.em.persist((Object)apToAdd);
        }
        this.em.flush();
    }

    public RoleModel getRole(String name) {
        TypedQuery query = this.em.createNamedQuery("getRealmRoleByName", RealmRoleEntity.class);
        query.setParameter("name", (Object)name);
        query.setParameter("realm", (Object)this.realm);
        List roles = query.getResultList();
        if (roles.size() == 0) {
            return null;
        }
        return new RoleAdapter(this, this.em, (RoleEntity)roles.get(0));
    }

    public RoleModel addRole(String name) {
        return this.addRole(KeycloakModelUtils.generateId(), name);
    }

    public RoleModel addRole(String id, String name) {
        RealmRoleEntity entity = new RealmRoleEntity();
        entity.setId(id);
        entity.setName(name);
        entity.setRealm(this.realm);
        this.realm.getRoles().add(entity);
        this.em.persist((Object)entity);
        this.em.flush();
        return new RoleAdapter(this, this.em, entity);
    }

    public boolean removeRole(RoleModel role) {
        if (role == null) {
            return false;
        }
        if (!role.getContainer().equals(this)) {
            return false;
        }
        RoleEntity roleEntity = ((RoleAdapter)role).getRole();
        this.realm.getRoles().remove(role);
        this.realm.getDefaultRoles().remove(role);
        this.em.createNativeQuery("delete from CompositeRole where role = :role").setParameter("role", (Object)roleEntity).executeUpdate();
        this.em.createQuery("delete from " + UserRoleMappingEntity.class.getSimpleName() + " where role = :role").setParameter("role", (Object)roleEntity).executeUpdate();
        this.em.createQuery("delete from " + ScopeMappingEntity.class.getSimpleName() + " where role = :role").setParameter("role", (Object)roleEntity).executeUpdate();
        this.em.remove((Object)roleEntity);
        return true;
    }

    public Set<RoleModel> getRoles() {
        HashSet<RoleModel> list = new HashSet<RoleModel>();
        Collection<RealmRoleEntity> roles = this.realm.getRoles();
        if (roles == null) {
            return list;
        }
        for (RoleEntity roleEntity : roles) {
            list.add(new RoleAdapter(this, this.em, roleEntity));
        }
        return list;
    }

    public RoleModel getRoleById(String id) {
        RealmRoleEntity roleEntity;
        RoleEntity entity = (RoleEntity)this.em.find(RoleEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        if (entity instanceof RealmRoleEntity ? !(roleEntity = (RealmRoleEntity)entity).getRealm().getId().equals(this.getId()) : !(roleEntity = (ApplicationRoleEntity)entity).getApplication().getRealm().getId().equals(this.getId())) {
            return null;
        }
        return new RoleAdapter(this, this.em, entity);
    }

    public boolean removeRoleById(String id) {
        RoleModel role = this.getRoleById(id);
        if (role == null) {
            return false;
        }
        return role.getContainer().removeRole(role);
    }

    public boolean hasRole(UserModel user, RoleModel role) {
        Set<RoleModel> roles = this.getRoleMappings(user);
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public boolean hasScope(ClientModel client, RoleModel role) {
        Set<RoleModel> roles = this.getScopeMappings(client);
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    protected TypedQuery<UserRoleMappingEntity> getUserRoleMappingEntityTypedQuery(UserAdapter user, RoleAdapter role) {
        TypedQuery query = this.em.createNamedQuery("userHasRole", UserRoleMappingEntity.class);
        query.setParameter("user", (Object)user.getUser());
        query.setParameter("role", (Object)role.getRole());
        return query;
    }

    public void grantRole(UserModel user, RoleModel role) {
        if (this.hasRole(user, role)) {
            return;
        }
        UserRoleMappingEntity entity = new UserRoleMappingEntity();
        entity.setUser(((UserAdapter)user).getUser());
        entity.setRole(((RoleAdapter)role).getRole());
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public Set<RoleModel> getRealmRoleMappings(UserModel user) {
        Set<RoleModel> roleMappings = this.getRoleMappings(user);
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof RealmModel)) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    public Set<RoleModel> getRoleMappings(UserModel user) {
        TypedQuery query = this.em.createNamedQuery("userRoleMappings", UserRoleMappingEntity.class);
        query.setParameter("user", (Object)((UserAdapter)user).getUser());
        List entities = query.getResultList();
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (UserRoleMappingEntity entity : entities) {
            roles.add(new RoleAdapter(this, this.em, entity.getRole()));
        }
        return roles;
    }

    public void deleteRoleMapping(UserModel user, RoleModel role) {
        if (user == null || role == null) {
            return;
        }
        TypedQuery<UserRoleMappingEntity> query = this.getUserRoleMappingEntityTypedQuery((UserAdapter)user, (RoleAdapter)role);
        List results = query.getResultList();
        if (results.size() == 0) {
            return;
        }
        for (UserRoleMappingEntity entity : results) {
            this.em.remove((Object)entity);
        }
        this.em.flush();
    }

    public Set<RoleModel> getRealmScopeMappings(ClientModel client) {
        Set<RoleModel> roleMappings = this.getScopeMappings(client);
        HashSet<RoleModel> appRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof RealmModel) || !((RealmModel)container).getId().equals(this.getId())) continue;
            appRoles.add(role);
        }
        return appRoles;
    }

    public Set<RoleModel> getScopeMappings(ClientModel client) {
        TypedQuery query = this.em.createNamedQuery("clientScopeMappings", ScopeMappingEntity.class);
        query.setParameter("client", (Object)((ClientAdapter)client).getEntity());
        List entities = query.getResultList();
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (ScopeMappingEntity entity : entities) {
            roles.add(new RoleAdapter(this, this.em, entity.getRole()));
        }
        return roles;
    }

    public void addScopeMapping(ClientModel client, RoleModel role) {
        if (this.hasScope(client, role)) {
            return;
        }
        ScopeMappingEntity entity = new ScopeMappingEntity();
        entity.setClient(((ClientAdapter)client).getEntity());
        entity.setRole(((RoleAdapter)role).getRole());
        this.em.persist((Object)entity);
    }

    public void deleteScopeMapping(ClientModel client, RoleModel role) {
        TypedQuery<ScopeMappingEntity> query = this.getRealmScopeMappingQuery((ClientAdapter)client, (RoleAdapter)role);
        List results = query.getResultList();
        if (results.size() == 0) {
            return;
        }
        for (ScopeMappingEntity entity : results) {
            this.em.remove((Object)entity);
        }
    }

    protected TypedQuery<ScopeMappingEntity> getRealmScopeMappingQuery(ClientAdapter client, RoleAdapter role) {
        TypedQuery query = this.em.createNamedQuery("hasScope", ScopeMappingEntity.class);
        query.setParameter("client", (Object)client.getEntity());
        query.setParameter("role", (Object)role.getRole());
        return query;
    }

    public boolean validatePassword(UserModel user, String password) {
        for (CredentialEntity cred : ((UserAdapter)user).getUser().getCredentials()) {
            if (!cred.getType().equals("password")) continue;
            return new Pbkdf2PasswordEncoder(cred.getSalt()).verify(password, cred.getValue());
        }
        return false;
    }

    public boolean validateTOTP(UserModel user, String password, String token) {
        if (!this.validatePassword(user, password)) {
            return false;
        }
        for (CredentialEntity cred : ((UserAdapter)user).getUser().getCredentials()) {
            if (!cred.getType().equals("totp")) continue;
            return new TimeBasedOTP().validate(token, cred.getValue().getBytes());
        }
        return false;
    }

    public void updateCredential(UserModel user, UserCredentialModel cred) {
        UserEntity userEntity = ((UserAdapter)user).getUser();
        CredentialEntity credentialEntity = this.getCredentialEntity(userEntity, cred.getType());
        if (credentialEntity == null) {
            credentialEntity = new CredentialEntity();
            credentialEntity.setType(cred.getType());
            credentialEntity.setDevice(cred.getDevice());
            credentialEntity.setUser(userEntity);
            this.em.persist((Object)credentialEntity);
            userEntity.getCredentials().add(credentialEntity);
        }
        if (cred.getType().equals("password")) {
            byte[] salt = Pbkdf2PasswordEncoder.getSalt();
            credentialEntity.setValue(new Pbkdf2PasswordEncoder(salt).encode(cred.getValue()));
            credentialEntity.setSalt(salt);
        } else {
            credentialEntity.setValue(cred.getValue());
        }
        credentialEntity.setDevice(cred.getDevice());
        this.em.flush();
    }

    private CredentialEntity getCredentialEntity(UserEntity userEntity, String credType) {
        for (CredentialEntity entity : userEntity.getCredentials()) {
            if (!entity.getType().equals(credType)) continue;
            return entity;
        }
        return null;
    }

    public List<UserCredentialValueModel> getCredentialsDirectly(UserModel user) {
        UserEntity userEntity = ((UserAdapter)user).getUser();
        ArrayList<CredentialEntity> credentials = new ArrayList<CredentialEntity>(userEntity.getCredentials());
        ArrayList<UserCredentialValueModel> result = new ArrayList<UserCredentialValueModel>();
        if (credentials != null) {
            for (CredentialEntity credEntity : credentials) {
                UserCredentialValueModel credModel = new UserCredentialValueModel();
                credModel.setType(credEntity.getType());
                credModel.setDevice(credEntity.getDevice());
                credModel.setValue(credEntity.getValue());
                credModel.setSalt(credEntity.getSalt());
                result.add(credModel);
            }
        }
        return result;
    }

    public void updateCredentialDirectly(UserModel user, UserCredentialValueModel credModel) {
        UserEntity userEntity = ((UserAdapter)user).getUser();
        CredentialEntity credentialEntity = this.getCredentialEntity(userEntity, credModel.getType());
        if (credentialEntity == null) {
            credentialEntity = new CredentialEntity();
            credentialEntity.setType(credModel.getType());
            credentialEntity.setUser(userEntity);
            this.em.persist((Object)credentialEntity);
            userEntity.getCredentials().add(credentialEntity);
        }
        credentialEntity.setValue(credModel.getValue());
        credentialEntity.setSalt(credModel.getSalt());
        credentialEntity.setDevice(credModel.getDevice());
        this.em.flush();
    }

    public PasswordPolicy getPasswordPolicy() {
        if (this.passwordPolicy == null) {
            this.passwordPolicy = new PasswordPolicy(this.realm.getPasswordPolicy());
        }
        return this.passwordPolicy;
    }

    public void setPasswordPolicy(PasswordPolicy policy) {
        this.passwordPolicy = policy;
        this.realm.setPasswordPolicy(policy.toString());
        this.em.flush();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof RealmAdapter)) {
            return false;
        }
        RealmAdapter r = (RealmAdapter)o;
        return r.getId().equals(this.getId());
    }

    public String getLoginTheme() {
        return this.realm.getLoginTheme();
    }

    public void setLoginTheme(String name) {
        this.realm.setLoginTheme(name);
        this.em.flush();
    }

    public String getAccountTheme() {
        return this.realm.getAccountTheme();
    }

    public void setAccountTheme(String name) {
        this.realm.setAccountTheme(name);
        this.em.flush();
    }

    public String getAdminTheme() {
        return this.realm.getAdminTheme();
    }

    public void setAdminTheme(String name) {
        this.realm.setAdminTheme(name);
        this.em.flush();
    }

    public String getEmailTheme() {
        return this.realm.getEmailTheme();
    }

    public void setEmailTheme(String name) {
        this.realm.setEmailTheme(name);
        this.em.flush();
    }

    public boolean isAuditEnabled() {
        return this.realm.isAuditEnabled();
    }

    public void setAuditEnabled(boolean enabled) {
        this.realm.setAuditEnabled(enabled);
        this.em.flush();
    }

    public long getAuditExpiration() {
        return this.realm.getAuditExpiration();
    }

    public void setAuditExpiration(long expiration) {
        this.realm.setAuditExpiration(expiration);
        this.em.flush();
    }

    public Set<String> getAuditListeners() {
        return this.realm.getAuditListeners();
    }

    public void setAuditListeners(Set<String> listeners) {
        this.realm.setAuditListeners(listeners);
        this.em.flush();
    }

    public ApplicationModel getMasterAdminApp() {
        return new ApplicationAdapter((RealmModel)this, this.em, this.realm.getMasterAdminApp());
    }

    public void setMasterAdminApp(ApplicationModel app) {
        this.realm.setMasterAdminApp(((ApplicationAdapter)app).getJpaEntity());
        this.em.flush();
    }

    public UserSessionModel createUserSession(UserModel user, String ipAddress) {
        UserSessionEntity entity = new UserSessionEntity();
        entity.setRealm(this.realm);
        entity.setUser(((UserAdapter)user).getUser());
        entity.setIpAddress(ipAddress);
        int currentTime = Time.currentTime();
        entity.setStarted(currentTime);
        entity.setLastSessionRefresh(currentTime);
        this.em.persist((Object)entity);
        return new UserSessionAdapter(this.em, this, entity);
    }

    public UserSessionModel getUserSession(String id) {
        UserSessionEntity entity = (UserSessionEntity)this.em.find(UserSessionEntity.class, (Object)id);
        return entity != null ? new UserSessionAdapter(this.em, this, entity) : null;
    }

    public List<UserSessionModel> getUserSessions(UserModel user) {
        LinkedList<UserSessionModel> sessions = new LinkedList<UserSessionModel>();
        for (UserSessionEntity e : this.em.createNamedQuery("getUserSessionByUser", UserSessionEntity.class).setParameter("user", (Object)((UserAdapter)user).getUser()).getResultList()) {
            sessions.add(new UserSessionAdapter(this.em, this, e));
        }
        return sessions;
    }

    public void removeUserSession(UserSessionModel session) {
        this.em.remove((Object)((UserSessionAdapter)session).getEntity());
    }

    public void removeUserSessions() {
        this.em.createNamedQuery("removeClientUserSessionByRealm").setParameter("realm", (Object)this.realm).executeUpdate();
        this.em.createNamedQuery("removeRealmUserSessions").setParameter("realm", (Object)this.realm).executeUpdate();
    }

    public void removeUserSessions(UserModel user) {
        this.removeUserSessions(((UserAdapter)user).getUser());
    }

    private void removeUserSessions(UserEntity user) {
        this.em.createNamedQuery("removeClientUserSessionByUser").setParameter("user", (Object)user).executeUpdate();
        this.em.createNamedQuery("removeUserSessionByUser").setParameter("user", (Object)user).executeUpdate();
    }

    public void removeExpiredUserSessions() {
        TypedQuery query = this.em.createNamedQuery("getUserSessionExpired", UserSessionEntity.class).setParameter("maxTime", (Object)(Time.currentTime() - this.getSsoSessionMaxLifespan())).setParameter("idleTime", (Object)(Time.currentTime() - this.getSsoSessionIdleTimeout()));
        List results = query.getResultList();
        for (UserSessionEntity entity : results) {
            this.em.remove((Object)entity);
        }
    }
}

