/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UsernameLoginFailureModel;
import org.keycloak.models.entities.SocialLinkEntity;
import org.keycloak.models.mongo.api.MongoStore;
import org.keycloak.models.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.mongo.impl.context.TransactionMongoStoreInvocationContext;
import org.keycloak.models.mongo.keycloak.adapters.ApplicationAdapter;
import org.keycloak.models.mongo.keycloak.adapters.MongoKeycloakTransaction;
import org.keycloak.models.mongo.keycloak.adapters.OAuthClientAdapter;
import org.keycloak.models.mongo.keycloak.adapters.RealmAdapter;
import org.keycloak.models.mongo.keycloak.adapters.RoleAdapter;
import org.keycloak.models.mongo.keycloak.adapters.UserAdapter;
import org.keycloak.models.mongo.keycloak.adapters.UserSessionAdapter;
import org.keycloak.models.mongo.keycloak.adapters.UsernameLoginFailureAdapter;
import org.keycloak.models.mongo.keycloak.entities.MongoApplicationEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoOAuthClientEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoRealmEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoRoleEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoUserEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoUserSessionEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoUsernameLoginFailureEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.util.Time;

public class MongoKeycloakSession
implements KeycloakSession {
    private final MongoStoreInvocationContext invocationContext;
    private final MongoKeycloakTransaction transaction;

    public MongoKeycloakSession(MongoStore mongoStore) {
        this.invocationContext = new TransactionMongoStoreInvocationContext(mongoStore);
        this.transaction = new MongoKeycloakTransaction(this.invocationContext);
    }

    public KeycloakTransaction getTransaction() {
        return this.transaction;
    }

    public void close() {
    }

    public void removeAllData() {
        this.getMongoStore().removeAllEntities();
    }

    public RealmModel createRealm(String name) {
        return this.createRealm(KeycloakModelUtils.generateId(), name);
    }

    public RealmModel createRealm(String id, String name) {
        MongoRealmEntity newRealm = new MongoRealmEntity();
        newRealm.setId(id);
        newRealm.setName(name);
        this.getMongoStore().insertEntity(newRealm, this.invocationContext);
        return new RealmAdapter(this, newRealm, this.invocationContext);
    }

    public RealmModel getRealm(String id) {
        MongoRealmEntity realmEntity = this.getMongoStore().loadEntity(MongoRealmEntity.class, id, this.invocationContext);
        return realmEntity != null ? new RealmAdapter(this, realmEntity, this.invocationContext) : null;
    }

    public List<RealmModel> getRealms() {
        BasicDBObject query = new BasicDBObject();
        List<MongoRealmEntity> realms = this.getMongoStore().loadEntities(MongoRealmEntity.class, (DBObject)query, this.invocationContext);
        ArrayList<RealmModel> results = new ArrayList<RealmModel>();
        for (MongoRealmEntity realmEntity : realms) {
            results.add(new RealmAdapter(this, realmEntity, this.invocationContext));
        }
        return results;
    }

    public RealmModel getRealmByName(String name) {
        DBObject query = new QueryBuilder().and("name").is((Object)name).get();
        MongoRealmEntity realm = this.getMongoStore().loadSingleEntity(MongoRealmEntity.class, query, this.invocationContext);
        if (realm == null) {
            return null;
        }
        return new RealmAdapter(this, realm, this.invocationContext);
    }

    public UserModel getUserById(String id, RealmModel realm) {
        MongoUserEntity user = this.getMongoStore().loadEntity(MongoUserEntity.class, id, this.invocationContext);
        if (user == null || !realm.getId().equals(user.getRealmId())) {
            return null;
        }
        return new UserAdapter(this, realm, user, this.invocationContext);
    }

    public UserModel getUserByUsername(String username, RealmModel realm) {
        DBObject query = new QueryBuilder().and("loginName").is((Object)username).and("realmId").is((Object)realm.getId()).get();
        MongoUserEntity user = this.getMongoStore().loadSingleEntity(MongoUserEntity.class, query, this.invocationContext);
        if (user == null) {
            return null;
        }
        return new UserAdapter(this, realm, user, this.invocationContext);
    }

    public UserModel getUserByEmail(String email, RealmModel realm) {
        DBObject query = new QueryBuilder().and("email").is((Object)email).and("realmId").is((Object)realm.getId()).get();
        MongoUserEntity user = this.getMongoStore().loadSingleEntity(MongoUserEntity.class, query, this.invocationContext);
        if (user == null) {
            return null;
        }
        return new UserAdapter(this, realm, user, this.invocationContext);
    }

    public boolean removeRealm(String id) {
        return this.getMongoStore().removeEntity(MongoRealmEntity.class, id, this.invocationContext);
    }

    protected MongoStore getMongoStore() {
        return this.invocationContext.getMongoStore();
    }

    public UserModel getUserBySocialLink(SocialLinkModel socialLink, RealmModel realm) {
        DBObject query = new QueryBuilder().and("socialLinks.socialProvider").is((Object)socialLink.getSocialProvider()).and("socialLinks.socialUserId").is((Object)socialLink.getSocialUserId()).and("realmId").is((Object)realm.getId()).get();
        MongoUserEntity userEntity = this.getMongoStore().loadSingleEntity(MongoUserEntity.class, query, this.invocationContext);
        return userEntity == null ? null : new UserAdapter(this, realm, userEntity, this.invocationContext);
    }

    protected List<UserModel> convertUserEntities(RealmModel realm, List<MongoUserEntity> userEntities) {
        ArrayList<UserModel> userModels = new ArrayList<UserModel>();
        for (MongoUserEntity user : userEntities) {
            userModels.add(new UserAdapter(this, realm, user, this.invocationContext));
        }
        return userModels;
    }

    public List<UserModel> getUsers(RealmModel realm) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).get();
        List<MongoUserEntity> users = this.getMongoStore().loadEntities(MongoUserEntity.class, query, this.invocationContext);
        return this.convertUserEntities(realm, users);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm) {
        QueryBuilder nameBuilder;
        search = search.trim();
        Pattern caseInsensitivePattern = Pattern.compile("(?i:" + search + ")");
        int spaceInd = search.lastIndexOf(" ");
        if (spaceInd != -1) {
            String firstName = search.substring(0, spaceInd);
            String lastName = search.substring(spaceInd + 1);
            Pattern firstNamePattern = Pattern.compile("(?i:" + firstName + "$)");
            Pattern lastNamePattern = Pattern.compile("(?i:^" + lastName + ")");
            nameBuilder = new QueryBuilder().and(new DBObject[]{new QueryBuilder().put("firstName").regex(firstNamePattern).get(), new QueryBuilder().put("lastName").regex(lastNamePattern).get()});
        } else {
            nameBuilder = new QueryBuilder().or(new DBObject[]{new QueryBuilder().put("firstName").regex(caseInsensitivePattern).get(), new QueryBuilder().put("lastName").regex(caseInsensitivePattern).get()});
        }
        QueryBuilder builder = new QueryBuilder().and(new DBObject[]{new QueryBuilder().and("realmId").is((Object)realm.getId()).get(), new QueryBuilder().or(new DBObject[]{new QueryBuilder().put("loginName").regex(caseInsensitivePattern).get(), new QueryBuilder().put("email").regex(caseInsensitivePattern).get(), nameBuilder.get()}).get()});
        List<MongoUserEntity> users = this.getMongoStore().loadEntities(MongoUserEntity.class, builder.get(), this.invocationContext);
        return this.convertUserEntities(realm, users);
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes, RealmModel realm) {
        QueryBuilder queryBuilder = new QueryBuilder().and("realmId").is((Object)realm.getId());
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (entry.getKey().equals("username")) {
                queryBuilder.and("loginName").regex(Pattern.compile("(?i:" + entry.getValue() + "$)"));
                continue;
            }
            if (entry.getKey().equalsIgnoreCase("firstName")) {
                queryBuilder.and("firstName").regex(Pattern.compile("(?i:" + entry.getValue() + "$)"));
                continue;
            }
            if (entry.getKey().equalsIgnoreCase("lastName")) {
                queryBuilder.and("lastName").regex(Pattern.compile("(?i:" + entry.getValue() + "$)"));
                continue;
            }
            if (!entry.getKey().equalsIgnoreCase("email")) continue;
            queryBuilder.and("email").regex(Pattern.compile("(?i:" + entry.getValue() + "$)"));
        }
        List<MongoUserEntity> users = this.getMongoStore().loadEntities(MongoUserEntity.class, queryBuilder.get(), this.invocationContext);
        return this.convertUserEntities(realm, users);
    }

    public Set<SocialLinkModel> getSocialLinks(UserModel user, RealmModel realm) {
        MongoUserEntity userEntity = ((UserAdapter)user).getUser();
        List linkEntities = userEntity.getSocialLinks();
        if (linkEntities == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<SocialLinkModel> result = new HashSet<SocialLinkModel>();
        for (SocialLinkEntity socialLinkEntity : linkEntities) {
            SocialLinkModel model = new SocialLinkModel(socialLinkEntity.getSocialProvider(), socialLinkEntity.getSocialUserId(), socialLinkEntity.getSocialUsername());
            result.add(model);
        }
        return result;
    }

    private SocialLinkEntity findSocialLink(UserModel user, String socialProvider) {
        MongoUserEntity userEntity = ((UserAdapter)user).getUser();
        List linkEntities = userEntity.getSocialLinks();
        if (linkEntities == null) {
            return null;
        }
        for (SocialLinkEntity socialLinkEntity : linkEntities) {
            if (!socialLinkEntity.getSocialProvider().equals(socialProvider)) continue;
            return socialLinkEntity;
        }
        return null;
    }

    public SocialLinkModel getSocialLink(UserModel user, String socialProvider, RealmModel realm) {
        SocialLinkEntity socialLinkEntity = this.findSocialLink(user, socialProvider);
        return socialLinkEntity != null ? new SocialLinkModel(socialLinkEntity.getSocialProvider(), socialLinkEntity.getSocialUserId(), socialLinkEntity.getSocialUsername()) : null;
    }

    public RoleModel getRoleById(String id, RealmModel realm) {
        MongoRoleEntity role = this.getMongoStore().loadEntity(MongoRoleEntity.class, id, this.invocationContext);
        if (role == null) {
            return null;
        }
        if (role.getRealmId() != null && !role.getRealmId().equals(realm.getId())) {
            return null;
        }
        if (role.getApplicationId() != null && realm.getApplicationById(role.getApplicationId()) == null) {
            return null;
        }
        return new RoleAdapter(this, realm, role, null, this.invocationContext);
    }

    public ApplicationModel getApplicationById(String id, RealmModel realm) {
        MongoApplicationEntity appData = this.getMongoStore().loadEntity(MongoApplicationEntity.class, id, this.invocationContext);
        if (appData == null || !realm.getId().equals(appData.getRealmId())) {
            return null;
        }
        return new ApplicationAdapter((KeycloakSession)this, realm, appData, this.invocationContext);
    }

    public OAuthClientModel getOAuthClientById(String id, RealmModel realm) {
        MongoOAuthClientEntity clientEntity = this.getMongoStore().loadEntity(MongoOAuthClientEntity.class, id, this.invocationContext);
        if (clientEntity == null || !realm.getId().equals(clientEntity.getRealmId())) {
            return null;
        }
        return new OAuthClientAdapter((KeycloakSession)this, realm, clientEntity, this.invocationContext);
    }

    public UsernameLoginFailureModel getUserLoginFailure(String username, RealmModel realm) {
        DBObject query = new QueryBuilder().and("username").is((Object)username).and("realmId").is((Object)realm.getId()).get();
        MongoUsernameLoginFailureEntity user = this.getMongoStore().loadSingleEntity(MongoUsernameLoginFailureEntity.class, query, this.invocationContext);
        if (user == null) {
            return null;
        }
        return new UsernameLoginFailureAdapter(this.invocationContext, user);
    }

    public UsernameLoginFailureModel addUserLoginFailure(String username, RealmModel realm) {
        UsernameLoginFailureModel userLoginFailure = this.getUserLoginFailure(username, realm);
        if (userLoginFailure != null) {
            return userLoginFailure;
        }
        MongoUsernameLoginFailureEntity userEntity = new MongoUsernameLoginFailureEntity();
        userEntity.setUsername(username);
        userEntity.setRealmId(realm.getId());
        this.getMongoStore().insertEntity(userEntity, this.invocationContext);
        return new UsernameLoginFailureAdapter(this.invocationContext, userEntity);
    }

    public List<UsernameLoginFailureModel> getAllUserLoginFailures(RealmModel realm) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).get();
        List<MongoUsernameLoginFailureEntity> failures = this.getMongoStore().loadEntities(MongoUsernameLoginFailureEntity.class, query, this.invocationContext);
        ArrayList<UsernameLoginFailureModel> result = new ArrayList<UsernameLoginFailureModel>();
        if (failures == null) {
            return result;
        }
        for (MongoUsernameLoginFailureEntity failure : failures) {
            result.add(new UsernameLoginFailureAdapter(this.invocationContext, failure));
        }
        return result;
    }

    public UserSessionModel createUserSession(RealmModel realm, UserModel user, String ipAddress) {
        MongoUserSessionEntity entity = new MongoUserSessionEntity();
        entity.setRealmId(realm.getId());
        entity.setUser(user.getId());
        entity.setIpAddress(ipAddress);
        int currentTime = Time.currentTime();
        entity.setStarted(currentTime);
        entity.setLastSessionRefresh(currentTime);
        this.getMongoStore().insertEntity(entity, this.invocationContext);
        return new UserSessionAdapter(entity, realm, this.invocationContext);
    }

    public UserSessionModel getUserSession(String id, RealmModel realm) {
        MongoUserSessionEntity entity = this.getMongoStore().loadEntity(MongoUserSessionEntity.class, id, this.invocationContext);
        if (entity == null) {
            return null;
        }
        return new UserSessionAdapter(entity, realm, this.invocationContext);
    }

    public List<UserSessionModel> getUserSessions(UserModel user, RealmModel realm) {
        BasicDBObject query = new BasicDBObject("user", (Object)user.getId());
        LinkedList<UserSessionModel> sessions = new LinkedList<UserSessionModel>();
        for (MongoUserSessionEntity e : this.getMongoStore().loadEntities(MongoUserSessionEntity.class, (DBObject)query, this.invocationContext)) {
            sessions.add(new UserSessionAdapter(e, realm, this.invocationContext));
        }
        return sessions;
    }

    public Set<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client) {
        DBObject query = new QueryBuilder().and("associatedClientIds").is((Object)client.getId()).get();
        List<MongoUserSessionEntity> sessions = this.getMongoStore().loadEntities(MongoUserSessionEntity.class, query, this.invocationContext);
        HashSet<UserSessionModel> result = new HashSet<UserSessionModel>();
        for (MongoUserSessionEntity session : sessions) {
            result.add(new UserSessionAdapter(session, realm, this.invocationContext));
        }
        return result;
    }

    public int getActiveUserSessions(RealmModel realm, ClientModel client) {
        return this.getUserSessions(realm, client).size();
    }

    public void removeUserSession(UserSessionModel session) {
        this.getMongoStore().removeEntity(((UserSessionAdapter)session).getMongoEntity(), this.invocationContext);
    }

    public void removeUserSessions(RealmModel realm, UserModel user) {
        BasicDBObject query = new BasicDBObject("user", (Object)user.getId());
        this.getMongoStore().removeEntities(MongoUserSessionEntity.class, (DBObject)query, this.invocationContext);
    }

    public void removeUserSessions(RealmModel realm) {
        BasicDBObject query = new BasicDBObject("realmId", (Object)realm.getId());
        this.getMongoStore().removeEntities(MongoUserSessionEntity.class, (DBObject)query, this.invocationContext);
    }

    public void removeExpiredUserSessions(RealmModel realm) {
        int currentTime = Time.currentTime();
        DBObject query = new QueryBuilder().and("started").lessThan((Object)(currentTime - realm.getSsoSessionMaxLifespan())).get();
        this.getMongoStore().removeEntities(MongoUserSessionEntity.class, query, this.invocationContext);
        query = new QueryBuilder().and("lastSessionRefresh").lessThan((Object)(currentTime - realm.getSsoSessionIdleTimeout())).get();
        this.getMongoStore().removeEntities(MongoUserSessionEntity.class, query, this.invocationContext);
    }
}

