/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.login.freemarker.model;

import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.keycloak.models.ClaimMask;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RoleModel;

public class OAuthGrantBean {
    private List<RoleModel> realmRolesRequested;
    private MultivaluedMap<String, RoleModel> resourceRolesRequested;
    private String code;
    private ClientModel client;
    private List<String> claimsRequested;
    private String oAuthCode;
    private String action;

    public OAuthGrantBean(String code, ClientModel client, List<RoleModel> realmRolesRequested, MultivaluedMap<String, RoleModel> resourceRolesRequested) {
        this.code = code;
        this.client = client;
        this.realmRolesRequested = realmRolesRequested;
        this.resourceRolesRequested = resourceRolesRequested;
        LinkedList<String> claims = new LinkedList<String>();
        long mask = client.getAllowedClaimsMask();
        if (ClaimMask.hasEmail((long)mask)) {
            claims.add("email");
        }
        if (ClaimMask.hasUsername((long)mask)) {
            claims.add("username");
        }
        if (ClaimMask.hasName((long)mask)) {
            claims.add("name");
        }
        if (ClaimMask.hasGender((long)mask)) {
            claims.add("gender");
        }
        if (ClaimMask.hasAddress((long)mask)) {
            claims.add("address");
        }
        if (ClaimMask.hasPhone((long)mask)) {
            claims.add("phone");
        }
        if (ClaimMask.hasPicture((long)mask)) {
            claims.add("picture");
        }
        if (ClaimMask.hasProfile((long)mask)) {
            claims.add("profile page");
        }
        if (ClaimMask.hasLocale((long)mask)) {
            claims.add("locale");
        }
        if (ClaimMask.hasWebsite((long)mask)) {
            claims.add("website");
        }
        if (claims.size() > 0) {
            this.claimsRequested = claims;
        }
    }

    public String getCode() {
        return this.code;
    }

    public MultivaluedMap<String, RoleModel> getResourceRolesRequested() {
        return this.resourceRolesRequested;
    }

    public List<RoleModel> getRealmRolesRequested() {
        return this.realmRolesRequested;
    }

    public String getClient() {
        return this.client.getClientId();
    }

    public List<String> getClaimsRequested() {
        return this.claimsRequested;
    }
}

