/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.cache.CacheKeycloakSession;
import org.keycloak.provider.ProviderSession;
import org.keycloak.provider.ProviderSessionFactory;

public class KeycloakSessionServletFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        ProviderSessionFactory providerSessionFactory = (ProviderSessionFactory)servletRequest.getServletContext().getAttribute(ProviderSessionFactory.class.getName());
        ProviderSession providerSession = providerSessionFactory.createSession();
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        ResteasyProviderFactory.pushContext(ProviderSession.class, (Object)providerSession);
        KeycloakSession session = (KeycloakSession)providerSession.getProvider(CacheKeycloakSession.class);
        ResteasyProviderFactory.pushContext(KeycloakSession.class, (Object)session);
        KeycloakTransaction tx = session.getTransaction();
        ResteasyProviderFactory.pushContext(KeycloakTransaction.class, (Object)tx);
        tx.begin();
        try {
            filterChain.doFilter(servletRequest, servletResponse);
            if (tx.isActive()) {
                if (tx.getRollbackOnly()) {
                    tx.rollback();
                } else {
                    tx.commit();
                }
            }
        }
        catch (IOException ex) {
            if (tx.isActive()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (ServletException ex) {
            if (tx.isActive()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (tx.isActive()) {
                tx.rollback();
            }
            throw new RuntimeException("request path: " + request.getRequestURI(), ex);
        }
        finally {
            providerSession.close();
            ResteasyProviderFactory.clearContextData();
        }
    }

    public void destroy() {
    }
}

