/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.cache.CacheKeycloakSession;
import org.keycloak.models.cache.KeycloakCache;
import org.keycloak.models.cache.entities.CachedClient;

public abstract class ClientAdapter
implements ClientModel {
    protected CachedClient cachedClient;
    protected CacheKeycloakSession cacheSession;
    protected ClientModel updatedClient;
    protected RealmModel cachedRealm;
    protected KeycloakCache cache;

    public ClientAdapter(RealmModel cachedRealm, CachedClient cached, KeycloakCache cache, CacheKeycloakSession cacheSession) {
        this.cachedRealm = cachedRealm;
        this.cache = cache;
        this.cacheSession = cacheSession;
        this.cachedClient = cached;
    }

    protected abstract void getDelegateForUpdate();

    public String getId() {
        if (this.updatedClient != null) {
            return this.updatedClient.getId();
        }
        return this.cachedClient.getId();
    }

    public abstract String getClientId();

    public long getAllowedClaimsMask() {
        if (this.updatedClient != null) {
            return this.updatedClient.getAllowedClaimsMask();
        }
        return this.cachedClient.getAllowedClaimsMask();
    }

    public void setAllowedClaimsMask(long mask) {
        this.getDelegateForUpdate();
        this.updatedClient.setAllowedClaimsMask(mask);
    }

    public Set<String> getWebOrigins() {
        if (this.updatedClient != null) {
            return this.updatedClient.getWebOrigins();
        }
        return this.cachedClient.getWebOrigins();
    }

    public void setWebOrigins(Set<String> webOrigins) {
        this.getDelegateForUpdate();
        this.updatedClient.setWebOrigins(webOrigins);
    }

    public void addWebOrigin(String webOrigin) {
        this.getDelegateForUpdate();
        this.updatedClient.addWebOrigin(webOrigin);
    }

    public void removeWebOrigin(String webOrigin) {
        this.getDelegateForUpdate();
        this.updatedClient.removeWebOrigin(webOrigin);
    }

    public Set<String> getRedirectUris() {
        if (this.updatedClient != null) {
            return this.updatedClient.getRedirectUris();
        }
        return this.cachedClient.getRedirectUris();
    }

    public void setRedirectUris(Set<String> redirectUris) {
        this.getDelegateForUpdate();
        this.updatedClient.setRedirectUris(redirectUris);
    }

    public void addRedirectUri(String redirectUri) {
        this.getDelegateForUpdate();
        this.updatedClient.addRedirectUri(redirectUri);
    }

    public void removeRedirectUri(String redirectUri) {
        this.getDelegateForUpdate();
        this.updatedClient.removeRedirectUri(redirectUri);
    }

    public boolean isEnabled() {
        if (this.updatedClient != null) {
            return this.updatedClient.isEnabled();
        }
        return this.cachedClient.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.getDelegateForUpdate();
        this.updatedClient.setEnabled(enabled);
    }

    public boolean validateSecret(String secret) {
        return secret.equals(this.getSecret());
    }

    public String getSecret() {
        if (this.updatedClient != null) {
            return this.updatedClient.getSecret();
        }
        return this.cachedClient.getSecret();
    }

    public void setSecret(String secret) {
        this.getDelegateForUpdate();
        this.updatedClient.setSecret(secret);
    }

    public boolean isPublicClient() {
        if (this.updatedClient != null) {
            return this.updatedClient.isPublicClient();
        }
        return this.cachedClient.isPublicClient();
    }

    public void setPublicClient(boolean flag) {
        this.getDelegateForUpdate();
        this.updatedClient.setPublicClient(flag);
    }

    public boolean isDirectGrantsOnly() {
        if (this.updatedClient != null) {
            return this.updatedClient.isDirectGrantsOnly();
        }
        return this.cachedClient.isDirectGrantsOnly();
    }

    public void setDirectGrantsOnly(boolean flag) {
        this.getDelegateForUpdate();
        this.updatedClient.setDirectGrantsOnly(flag);
    }

    public Set<RoleModel> getScopeMappings() {
        if (this.updatedClient != null) {
            return this.updatedClient.getScopeMappings();
        }
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (String id : this.cachedClient.getScope()) {
            roles.add(this.cacheSession.getRoleById(id, this.getRealm()));
        }
        return roles;
    }

    public void addScopeMapping(RoleModel role) {
        this.getDelegateForUpdate();
        this.updatedClient.addScopeMapping(role);
    }

    public void deleteScopeMapping(RoleModel role) {
        this.getDelegateForUpdate();
        this.updatedClient.deleteScopeMapping(role);
    }

    public Set<RoleModel> getRealmScopeMappings() {
        Set<RoleModel> roleMappings = this.getScopeMappings();
        HashSet<RoleModel> appRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof RealmModel) || !((RealmModel)container).getId().equals(this.cachedRealm.getId())) continue;
            appRoles.add(role);
        }
        return appRoles;
    }

    public boolean hasScope(RoleModel role) {
        if (this.updatedClient != null) {
            return this.updatedClient.hasScope(role);
        }
        Set<RoleModel> roles = this.getScopeMappings();
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public RealmModel getRealm() {
        return this.cachedRealm;
    }

    public int getNotBefore() {
        if (this.updatedClient != null) {
            return this.updatedClient.getNotBefore();
        }
        return this.cachedClient.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.getDelegateForUpdate();
        this.updatedClient.setNotBefore(notBefore);
    }

    public Set<UserSessionModel> getUserSessions() {
        if (this.updatedClient != null) {
            return this.updatedClient.getUserSessions();
        }
        return this.cacheSession.getUserSessions(this.cachedRealm, this);
    }

    public int getActiveUserSessions() {
        if (this.updatedClient != null) {
            return this.updatedClient.getActiveUserSessions();
        }
        return this.cacheSession.getActiveUserSessions(this.cachedRealm, this);
    }
}

