/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UsernameLoginFailureModel;
import org.keycloak.provider.Provider;

public interface KeycloakSession
extends Provider {
    public KeycloakTransaction getTransaction();

    public RealmModel createRealm(String var1);

    public RealmModel createRealm(String var1, String var2);

    public RealmModel getRealm(String var1);

    public RealmModel getRealmByName(String var1);

    public UserModel getUserById(String var1, RealmModel var2);

    public UserModel getUserByUsername(String var1, RealmModel var2);

    public UserModel getUserByEmail(String var1, RealmModel var2);

    public UserModel getUserBySocialLink(SocialLinkModel var1, RealmModel var2);

    public List<UserModel> getUsers(RealmModel var1);

    public List<UserModel> searchForUser(String var1, RealmModel var2);

    public List<UserModel> searchForUserByAttributes(Map<String, String> var1, RealmModel var2);

    public Set<SocialLinkModel> getSocialLinks(UserModel var1, RealmModel var2);

    public SocialLinkModel getSocialLink(UserModel var1, String var2, RealmModel var3);

    public RoleModel getRoleById(String var1, RealmModel var2);

    public ApplicationModel getApplicationById(String var1, RealmModel var2);

    public OAuthClientModel getOAuthClientById(String var1, RealmModel var2);

    public List<RealmModel> getRealms();

    public boolean removeRealm(String var1);

    public UsernameLoginFailureModel getUserLoginFailure(String var1, RealmModel var2);

    public UsernameLoginFailureModel addUserLoginFailure(String var1, RealmModel var2);

    public List<UsernameLoginFailureModel> getAllUserLoginFailures(RealmModel var1);

    public UserSessionModel createUserSession(RealmModel var1, UserModel var2, String var3);

    public UserSessionModel getUserSession(String var1, RealmModel var2);

    public List<UserSessionModel> getUserSessions(UserModel var1, RealmModel var2);

    public Set<UserSessionModel> getUserSessions(RealmModel var1, ClientModel var2);

    public int getActiveUserSessions(RealmModel var1, ClientModel var2);

    public void removeUserSession(UserSessionModel var1);

    public void removeUserSessions(RealmModel var1, UserModel var2);

    public void removeExpiredUserSessions(RealmModel var1);

    public void removeUserSessions(RealmModel var1);

    public void removeAllData();

    public void close();
}

