/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.mongo.impl.types;

import com.mongodb.BasicDBObject;
import java.util.Map;
import java.util.Set;
import org.keycloak.connections.mongo.api.types.Mapper;
import org.keycloak.connections.mongo.api.types.MapperContext;

public class MapMapper<T extends Map>
implements Mapper<T, BasicDBObject> {
    static final String DOT_PLACEHOLDER = "###";
    private final Class<T> mapType;

    public MapMapper(Class<T> mapType) {
        this.mapType = mapType;
    }

    @Override
    public BasicDBObject convertObject(MapperContext<T, BasicDBObject> context) {
        Map objectToConvert = (Map)context.getObjectToConvert();
        BasicDBObject dbObject = new BasicDBObject();
        Set entries = objectToConvert.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.contains(".")) {
                key = key.replaceAll("\\.", DOT_PLACEHOLDER);
            }
            dbObject.put(key, (Object)value);
        }
        return dbObject;
    }

    @Override
    public Class<? extends T> getTypeOfObjectToConvert() {
        return this.mapType;
    }

    @Override
    public Class<BasicDBObject> getExpectedReturnType() {
        return BasicDBObject.class;
    }
}

