/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.zip;

import de.idyl.winzipaes.AesZipFileEncrypter;
import de.idyl.winzipaes.impl.AESEncrypter;
import de.idyl.winzipaes.impl.AESEncrypterBC;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.logging.Logger;
import org.keycloak.exportimport.util.ExportUtils;
import org.keycloak.exportimport.util.MultipleStepsExportProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.util.JsonSerialization;

public class ZipExportProvider
extends MultipleStepsExportProvider {
    private static final Logger logger = Logger.getLogger(ZipExportProvider.class);
    private final AesZipFileEncrypter encrypter;
    private final String password;

    public ZipExportProvider(File zipFile, String password) {
        if (zipFile.exists()) {
            throw new IllegalStateException("File " + zipFile.getAbsolutePath() + " already exists");
        }
        this.password = password;
        try {
            AESEncrypterBC encrypter = new AESEncrypterBC();
            this.encrypter = new AesZipFileEncrypter(zipFile, (AESEncrypter)encrypter);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        logger.infof("Exporting into zip file %s", (Object)zipFile.getAbsolutePath());
    }

    protected void writeRealm(String fileName, RealmRepresentation rep) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        JsonSerialization.mapper.writeValue((OutputStream)stream, (Object)rep);
        byte[] byteArray = stream.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
        this.encrypter.add(fileName, (InputStream)bis, this.password);
    }

    protected void writeUsers(String fileName, KeycloakSession session, RealmModel realm, List<UserModel> users) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ExportUtils.exportUsersToStream((KeycloakSession)session, (RealmModel)realm, users, (ObjectMapper)JsonSerialization.mapper, (OutputStream)stream);
        byte[] byteArray = stream.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
        this.encrypter.add(fileName, (InputStream)bis, this.password);
    }

    public void close() {
        try {
            this.encrypter.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

