/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderFactory;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.timer.TimerProvider;
import org.keycloak.util.Time;

public class UsersSyncManager {
    protected static final Logger logger = Logger.getLogger(UsersSyncManager.class);

    public void bootstrapPeriodic(final KeycloakSessionFactory sessionFactory, final TimerProvider timer) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                List realms = session.realms().getRealms();
                for (RealmModel realm : realms) {
                    List federationProviders = realm.getUserFederationProviders();
                    for (UserFederationProviderModel fedProvider : federationProviders) {
                        UsersSyncManager.this.refreshPeriodicSyncForProvider(sessionFactory, timer, fedProvider, realm.getId());
                    }
                }
            }
        });
    }

    public void syncAllUsers(KeycloakSessionFactory sessionFactory, String realmId, UserFederationProviderModel fedProvider) {
        UserFederationProviderFactory fedProviderFactory = (UserFederationProviderFactory)sessionFactory.getProviderFactory(UserFederationProvider.class, fedProvider.getProviderName());
        this.updateLastSyncInterval(sessionFactory, fedProvider, realmId);
        fedProviderFactory.syncAllUsers(sessionFactory, realmId, fedProvider);
    }

    public void syncChangedUsers(KeycloakSessionFactory sessionFactory, String realmId, UserFederationProviderModel fedProvider) {
        UserFederationProviderFactory fedProviderFactory = (UserFederationProviderFactory)sessionFactory.getProviderFactory(UserFederationProvider.class, fedProvider.getProviderName());
        int oldLastSync = fedProvider.getLastSync();
        this.updateLastSyncInterval(sessionFactory, fedProvider, realmId);
        fedProviderFactory.syncChangedUsers(sessionFactory, realmId, fedProvider, Time.toDate((int)oldLastSync));
    }

    public void refreshPeriodicSyncForProvider(final KeycloakSessionFactory sessionFactory, TimerProvider timer, final UserFederationProviderModel fedProvider, final String realmId) {
        if (fedProvider.getFullSyncPeriod() > 0) {
            timer.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        UsersSyncManager.this.syncAllUsers(sessionFactory, realmId, fedProvider);
                    }
                    catch (Throwable t) {
                        logger.error((Object)"Error occured during full sync of users", t);
                    }
                }
            }, (long)(fedProvider.getFullSyncPeriod() * 1000), fedProvider.getId() + "-FULL");
        } else {
            timer.cancelTask(fedProvider.getId() + "-FULL");
        }
        if (fedProvider.getChangedSyncPeriod() > 0) {
            timer.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        UsersSyncManager.this.syncChangedUsers(sessionFactory, realmId, fedProvider);
                    }
                    catch (Throwable t) {
                        logger.error((Object)"Error occured during sync of changed users", t);
                    }
                }
            }, (long)(fedProvider.getChangedSyncPeriod() * 1000), fedProvider.getId() + "-CHANGED");
        } else {
            timer.cancelTask(fedProvider.getId() + "-CHANGED");
        }
    }

    public void removePeriodicSyncForProvider(TimerProvider timer, UserFederationProviderModel fedProvider) {
        timer.cancelTask(fedProvider.getId() + "-FULL");
        timer.cancelTask(fedProvider.getId() + "-CHANGED");
    }

    private void updateLastSyncInterval(KeycloakSessionFactory sessionFactory, final UserFederationProviderModel fedProvider, final String realmId) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                RealmModel persistentRealm = session.realms().getRealm(realmId);
                List persistentFedProviders = persistentRealm.getUserFederationProviders();
                for (UserFederationProviderModel persistentFedProvider : persistentFedProviders) {
                    if (!fedProvider.getId().equals(persistentFedProvider.getId())) continue;
                    int lastSync = Time.currentTime();
                    persistentFedProvider.setLastSync(lastSync);
                    persistentRealm.updateUserFederationProvider(persistentFedProvider);
                    fedProvider.setLastSync(lastSync);
                }
            }
        });
    }
}

