/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.net.URI;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.ClientConnection;
import org.keycloak.audit.Audit;
import org.keycloak.audit.EventType;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailProvider;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.services.managers.AccessCode;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.services.resources.flows.Urls;
import org.keycloak.services.validation.Validation;

public class RequiredActionsService {
    protected static final Logger logger = Logger.getLogger(RequiredActionsService.class);
    private RealmModel realm;
    @Context
    private HttpRequest request;
    @Context
    protected HttpHeaders headers;
    @Context
    private UriInfo uriInfo;
    @Context
    private ClientConnection clientConnection;
    @Context
    protected Providers providers;
    @Context
    protected KeycloakSession session;
    private TokenManager tokenManager;
    private Audit audit;

    public RequiredActionsService(RealmModel realm, TokenManager tokenManager, Audit audit) {
        this.realm = realm;
        this.tokenManager = tokenManager;
        this.audit = audit;
    }

    @Path(value="profile")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response updateProfile(MultivaluedMap<String, String> formData) {
        AccessCode accessCode = this.getAccessCodeEntry(UserModel.RequiredAction.UPDATE_PROFILE);
        if (accessCode == null) {
            return this.unauthorized();
        }
        UserModel user = this.getUser(accessCode);
        this.initAudit(accessCode);
        String error = Validation.validateUpdateProfileForm(formData);
        if (error != null) {
            return Flows.forms(this.session, this.realm, null, this.uriInfo).setUser(user).setError(error).createResponse(UserModel.RequiredAction.UPDATE_PROFILE);
        }
        user.setFirstName((String)formData.getFirst((Object)"firstName"));
        user.setLastName((String)formData.getFirst((Object)"lastName"));
        String email = (String)formData.getFirst((Object)"email");
        String oldEmail = user.getEmail();
        boolean emailChanged = oldEmail != null ? !oldEmail.equals(email) : email != null;
        user.setEmail(email);
        user.removeRequiredAction(UserModel.RequiredAction.UPDATE_PROFILE);
        this.audit.clone().event(EventType.UPDATE_PROFILE).success();
        if (emailChanged) {
            user.setEmailVerified(false);
            this.audit.clone().event(EventType.UPDATE_EMAIL).detail("previous_email", oldEmail).detail("updated_email", email).success();
        }
        return this.redirectOauth(user, accessCode);
    }

    @Path(value="totp")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response updateTotp(MultivaluedMap<String, String> formData) {
        AccessCode accessCode = this.getAccessCodeEntry(UserModel.RequiredAction.CONFIGURE_TOTP);
        if (accessCode == null) {
            return this.unauthorized();
        }
        UserModel user = this.getUser(accessCode);
        this.initAudit(accessCode);
        String totp = (String)formData.getFirst((Object)"totp");
        String totpSecret = (String)formData.getFirst((Object)"totpSecret");
        LoginFormsProvider loginForms = Flows.forms(this.session, this.realm, null, this.uriInfo).setUser(user);
        if (Validation.isEmpty(totp)) {
            return loginForms.setError("missingTotp").createResponse(UserModel.RequiredAction.CONFIGURE_TOTP);
        }
        if (!new TimeBasedOTP().validate(totp, totpSecret.getBytes())) {
            return loginForms.setError("invalidTotp").createResponse(UserModel.RequiredAction.CONFIGURE_TOTP);
        }
        UserCredentialModel credentials = new UserCredentialModel();
        credentials.setType("totp");
        credentials.setValue(totpSecret);
        this.session.users().updateCredential(this.realm, user, credentials);
        user.setTotp(true);
        user.removeRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP);
        this.audit.clone().event(EventType.UPDATE_TOTP).success();
        return this.redirectOauth(user, accessCode);
    }

    @Path(value="password")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response updatePassword(MultivaluedMap<String, String> formData) {
        logger.debug((Object)"updatePassword");
        AccessCode accessCode = this.getAccessCodeEntry(UserModel.RequiredAction.UPDATE_PASSWORD);
        if (accessCode == null) {
            logger.debug((Object)"updatePassword access code is null");
            return this.unauthorized();
        }
        logger.debug((Object)"updatePassword has access code");
        UserModel user = this.getUser(accessCode);
        this.initAudit(accessCode);
        String passwordNew = (String)formData.getFirst((Object)"password-new");
        String passwordConfirm = (String)formData.getFirst((Object)"password-confirm");
        LoginFormsProvider loginForms = Flows.forms(this.session, this.realm, null, this.uriInfo).setUser(user);
        if (Validation.isEmpty(passwordNew)) {
            return loginForms.setError("missingPassword").createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
        }
        if (!passwordNew.equals(passwordConfirm)) {
            return loginForms.setError("notMatchPassword").createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
        }
        try {
            this.session.users().updateCredential(this.realm, user, UserCredentialModel.password((String)passwordNew));
        }
        catch (Exception ape) {
            return loginForms.setError(ape.getMessage()).createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
        }
        logger.debug((Object)"updatePassword updated credential");
        user.removeRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
        this.audit.clone().event(EventType.UPDATE_PASSWORD).success();
        if (accessCode.getSessionState() == null) {
            return Response.seeOther((URI)Urls.accountPage(this.uriInfo.getBaseUri(), this.realm.getId())).build();
        }
        return this.redirectOauth(user, accessCode);
    }

    @Path(value="email-verification")
    @GET
    public Response emailVerification() {
        if (this.uriInfo.getQueryParameters().containsKey((Object)"key")) {
            AccessCode accessCode = AccessCode.parse((String)this.uriInfo.getQueryParameters().getFirst((Object)"key"), this.session, this.realm);
            if (accessCode == null || !accessCode.isValid(UserModel.RequiredAction.VERIFY_EMAIL)) {
                return this.unauthorized();
            }
            UserModel user = this.getUser(accessCode);
            this.initAudit(accessCode);
            user.setEmailVerified(true);
            user.removeRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
            this.audit.clone().event(EventType.VERIFY_EMAIL).detail("email", accessCode.getUser().getEmail()).success();
            return this.redirectOauth(user, accessCode);
        }
        AccessCode accessCode = this.getAccessCodeEntry(UserModel.RequiredAction.VERIFY_EMAIL);
        if (accessCode == null) {
            return this.unauthorized();
        }
        this.initAudit(accessCode);
        return Flows.forms(this.session, this.realm, null, this.uriInfo).setAccessCode(accessCode.getCode()).setUser(accessCode.getUser()).createResponse(UserModel.RequiredAction.VERIFY_EMAIL);
    }

    @Path(value="password-reset")
    @GET
    public Response passwordReset() {
        if (this.uriInfo.getQueryParameters().containsKey((Object)"key")) {
            AccessCode accessCode = AccessCode.parse((String)this.uriInfo.getQueryParameters().getFirst((Object)"key"), this.session, this.realm);
            if (accessCode == null || !accessCode.isValid(UserModel.RequiredAction.UPDATE_PASSWORD)) {
                return this.unauthorized();
            }
            return Flows.forms(this.session, this.realm, null, this.uriInfo).setAccessCode(accessCode.getCode()).createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
        }
        return Flows.forms(this.session, this.realm, null, this.uriInfo).createPasswordReset();
    }

    @Path(value="password-reset")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response sendPasswordReset(MultivaluedMap<String, String> formData) {
        String username = (String)formData.getFirst((Object)"username");
        String scopeParam = (String)this.uriInfo.getQueryParameters().getFirst((Object)"scope");
        String state = (String)this.uriInfo.getQueryParameters().getFirst((Object)"state");
        String redirect = (String)this.uriInfo.getQueryParameters().getFirst((Object)"redirect_uri");
        String clientId = (String)this.uriInfo.getQueryParameters().getFirst((Object)"client_id");
        AuthenticationManager authManager = new AuthenticationManager();
        ClientModel client = this.realm.findClient(clientId);
        if (client == null) {
            return Flows.oauth(this.session, this.realm, this.request, this.uriInfo, this.clientConnection, authManager, this.tokenManager).forwardToSecurityFailure("Unknown login requester.");
        }
        if (!client.isEnabled()) {
            return Flows.oauth(this.session, this.realm, this.request, this.uriInfo, this.clientConnection, authManager, this.tokenManager).forwardToSecurityFailure("Login requester not enabled.");
        }
        this.audit.event(EventType.SEND_RESET_PASSWORD).client(clientId).detail("redirect_uri", redirect).detail("response_type", "code").detail("auth_method", "form").detail("username", username);
        UserModel user = this.session.users().getUserByUsername(username, this.realm);
        if (user == null && username.contains("@")) {
            user = this.session.users().getUserByEmail(username, this.realm);
        }
        if (user == null) {
            logger.warn((Object)"Failed to send password reset email: user not found");
            this.audit.error("user_not_found");
        } else {
            UserSessionModel userSession = this.session.sessions().createUserSession(this.realm, user, username, this.clientConnection.getRemoteAddr(), "form", false);
            this.audit.session(userSession);
            AccessCode accessCode = this.tokenManager.createAccessCode(scopeParam, state, redirect, this.session, this.realm, client, user, userSession);
            accessCode.setRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
            try {
                UriBuilder builder = Urls.loginPasswordResetBuilder(this.uriInfo.getBaseUri());
                builder.queryParam("key", new Object[]{accessCode.getCode()});
                String link = builder.build(new Object[]{this.realm.getName()}).toString();
                long expiration = TimeUnit.SECONDS.toMinutes(this.realm.getAccessCodeLifespanUserAction());
                ((EmailProvider)this.session.getProvider(EmailProvider.class)).setRealm(this.realm).setUser(user).sendPasswordReset(link, expiration);
                this.audit.user(user).detail("email", user.getEmail()).detail("code_id", accessCode.getCodeId()).success();
            }
            catch (EmailException e) {
                logger.error((Object)"Failed to send password reset email", (Throwable)e);
                return Flows.forms(this.session, this.realm, client, this.uriInfo).setError("emailSendError").createErrorPage();
            }
        }
        return Flows.forms(this.session, this.realm, client, this.uriInfo).setSuccess("emailSent").createPasswordReset();
    }

    private AccessCode getAccessCodeEntry(UserModel.RequiredAction requiredAction) {
        String code = (String)this.uriInfo.getQueryParameters().getFirst((Object)"code");
        if (code == null) {
            logger.debug((Object)"getAccessCodeEntry code as not in query param");
            return null;
        }
        AccessCode accessCode = AccessCode.parse(code, this.session, this.realm);
        if (accessCode == null) {
            logger.debug((Object)"getAccessCodeEntry access code entry null");
            return null;
        }
        if (!accessCode.isValid(requiredAction)) {
            logger.debugv("getAccessCodeEntry: access code id: {0}", (Object)accessCode.getCodeId());
            logger.debugv("getAccessCodeEntry access code not valid", new Object[0]);
            return null;
        }
        return accessCode;
    }

    private UserModel getUser(AccessCode accessCode) {
        return this.session.users().getUserByUsername(accessCode.getUser().getUsername(), this.realm);
    }

    private Response redirectOauth(UserModel user, AccessCode accessCode) {
        if (accessCode == null) {
            return null;
        }
        Set requiredActions = user.getRequiredActions();
        if (!requiredActions.isEmpty()) {
            accessCode.setRequiredAction((UserModel.RequiredAction)requiredActions.iterator().next());
            return Flows.forms(this.session, this.realm, null, this.uriInfo).setAccessCode(accessCode.getCode()).setUser(user).createResponse((UserModel.RequiredAction)requiredActions.iterator().next());
        }
        logger.debugv("redirectOauth: redirecting to: {0}", (Object)accessCode.getRedirectUri());
        accessCode.setAction(ClientSessionModel.Action.CODE_TO_TOKEN);
        AuthenticationManager authManager = new AuthenticationManager();
        UserSessionModel userSession = this.session.sessions().getUserSession(this.realm, accessCode.getSessionState());
        if (!AuthenticationManager.isSessionValid(this.realm, userSession)) {
            AuthenticationManager.logout(this.session, this.realm, userSession, this.uriInfo, this.clientConnection);
            return Flows.oauth(this.session, this.realm, this.request, this.uriInfo, this.clientConnection, authManager, this.tokenManager).redirectError(accessCode.getClient(), "access_denied", accessCode.getState(), accessCode.getRedirectUri());
        }
        this.audit.session(userSession);
        this.audit.success();
        return Flows.oauth(this.session, this.realm, this.request, this.uriInfo, this.clientConnection, authManager, this.tokenManager).redirectAccessCode(accessCode, userSession, accessCode.getState(), accessCode.getRedirectUri());
    }

    private void initAudit(AccessCode accessCode) {
        UserSessionModel userSession;
        this.audit.event(EventType.LOGIN).client(accessCode.getClient()).user(accessCode.getUser()).session(accessCode.getSessionState()).detail("code_id", accessCode.getCodeId()).detail("redirect_uri", accessCode.getRedirectUri()).detail("response_type", "code");
        UserSessionModel userSessionModel = userSession = accessCode.getSessionState() != null ? this.session.sessions().getUserSession(this.realm, accessCode.getSessionState()) : null;
        if (userSession != null) {
            this.audit.detail("auth_method", userSession.getAuthMethod());
            this.audit.detail("username", userSession.getLoginUsername());
            if (userSession.isRememberMe()) {
                this.audit.detail("remember_me", "true");
            }
        }
    }

    private Response unauthorized() {
        return Flows.forms(this.session, this.realm, null, this.uriInfo).setError("Unauthorized request").createErrorPage();
    }
}

