/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.net.URI;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.NotAcceptableException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.UnauthorizedException;
import org.keycloak.ClientConnection;
import org.keycloak.OAuthErrorException;
import org.keycloak.RSATokenVerifier;
import org.keycloak.audit.Audit;
import org.keycloak.audit.EventType;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.RefreshToken;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.managers.AccessCode;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.RequiredActionsService;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.services.resources.flows.OAuthFlows;
import org.keycloak.services.resources.flows.Urls;
import org.keycloak.services.validation.Validation;
import org.keycloak.util.Base64Url;
import org.keycloak.util.BasicAuthHelper;

public class TokenService {
    protected static final Logger logger = Logger.getLogger(TokenService.class);
    protected RealmModel realm;
    protected TokenManager tokenManager;
    private Audit audit;
    protected AuthenticationManager authManager;
    @Context
    protected Providers providers;
    @Context
    protected SecurityContext securityContext;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders headers;
    @Context
    protected HttpRequest request;
    @Context
    protected HttpResponse response;
    @Context
    protected KeycloakSession session;
    @Context
    protected ClientConnection clientConnection;
    private ResourceAdminManager resourceAdminManager = new ResourceAdminManager();

    public TokenService(RealmModel realm, TokenManager tokenManager, Audit audit, AuthenticationManager authManager) {
        this.realm = realm;
        this.tokenManager = tokenManager;
        this.audit = audit;
        this.authManager = authManager;
    }

    public static UriBuilder tokenServiceBaseUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return TokenService.tokenServiceBaseUrl(baseUriBuilder);
    }

    public static UriBuilder tokenServiceBaseUrl(UriBuilder baseUriBuilder) {
        return baseUriBuilder.path(RealmsResource.class).path(RealmsResource.class, "getTokenService");
    }

    public static UriBuilder accessCodeToTokenUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return TokenService.accessCodeToTokenUrl(baseUriBuilder);
    }

    public static UriBuilder accessCodeToTokenUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = TokenService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(TokenService.class, "accessCodeToToken");
    }

    public static UriBuilder validateAccessTokenUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = TokenService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(TokenService.class, "validateAccessToken");
    }

    public static UriBuilder grantAccessTokenUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return TokenService.grantAccessTokenUrl(baseUriBuilder);
    }

    public static UriBuilder grantAccessTokenUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = TokenService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(TokenService.class, "grantAccessToken");
    }

    public static UriBuilder loginPageUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return TokenService.loginPageUrl(baseUriBuilder);
    }

    public static UriBuilder loginPageUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = TokenService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(TokenService.class, "loginPage");
    }

    public static UriBuilder logoutUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return TokenService.logoutUrl(baseUriBuilder);
    }

    public static UriBuilder logoutUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = TokenService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(TokenService.class, "logout");
    }

    public static UriBuilder processLoginUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return TokenService.processLoginUrl(baseUriBuilder);
    }

    public static UriBuilder processLoginUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = TokenService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(TokenService.class, "processLogin");
    }

    public static UriBuilder processOAuthUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return TokenService.processOAuthUrl(baseUriBuilder);
    }

    public static UriBuilder processOAuthUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = TokenService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(TokenService.class, "processOAuth");
    }

    public static UriBuilder refreshUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = TokenService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(TokenService.class, "refreshAccessToken");
    }

    @Path(value="grants/access")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response grantAccessToken(@HeaderParam(value="Authorization") String authorizationHeader, MultivaluedMap<String, String> form) {
        if (!this.checkSsl()) {
            return this.createError("https_required", "HTTPS required", Response.Status.FORBIDDEN);
        }
        if (!this.realm.isPasswordCredentialGrantAllowed()) {
            return this.createError("not_enabled", "Direct Grant REST API not enabled", Response.Status.FORBIDDEN);
        }
        this.audit.event(EventType.LOGIN).detail("auth_method", "oauth_credentials").detail("response_type", "token");
        String username = (String)form.getFirst((Object)"username");
        if (username == null) {
            this.audit.error("username_missing");
            throw new UnauthorizedException("No username");
        }
        this.audit.detail("username", username);
        UserModel user = this.session.users().getUserByUsername(username, this.realm);
        if (user != null) {
            this.audit.user(user);
        }
        ClientModel client = this.authorizeClient(authorizationHeader, form, this.audit);
        if (!this.realm.isEnabled()) {
            this.audit.error("realm_disabled");
            return this.createError("realm_disabled", "Realm is disabled", Response.Status.UNAUTHORIZED);
        }
        AuthenticationManager.AuthenticationStatus authenticationStatus = this.authManager.authenticateForm(this.session, this.clientConnection, this.realm, form);
        switch (authenticationStatus) {
            case SUCCESS: {
                break;
            }
            case ACCOUNT_TEMPORARILY_DISABLED: 
            case ACTIONS_REQUIRED: {
                HashMap<String, String> err = new HashMap<String, String>();
                err.put("error", "invalid_grant");
                err.put("error_description", "AccountProvider temporarily disabled");
                this.audit.error("user_temporarily_disabled");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
            }
            case ACCOUNT_DISABLED: {
                HashMap<String, String> err = new HashMap<String, String>();
                err.put("error", "invalid_grant");
                err.put("error_description", "AccountProvider disabled");
                this.audit.error("user_disabled");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
            }
            default: {
                HashMap<String, String> err = new HashMap<String, String>();
                err.put("error", "invalid_grant");
                err.put("error_description", "Invalid user credentials");
                this.audit.error("invalid_user_credentials");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
            }
        }
        String scope = (String)form.getFirst((Object)"scope");
        UserSessionModel userSession = this.session.sessions().createUserSession(this.realm, user, username, this.clientConnection.getRemoteAddr(), "oauth_credentials", false);
        this.audit.session(userSession);
        AccessTokenResponse res = this.tokenManager.responseBuilder(this.realm, client, this.audit).generateAccessToken(scope, client, user, userSession).generateRefreshToken().generateIDToken().build();
        this.audit.success();
        return Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @Path(value="validate")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response validateAccessToken(@QueryParam(value="access_token") String tokenString) {
        if (!this.checkSsl()) {
            return this.createError("https_required", "HTTPS required", Response.Status.FORBIDDEN);
        }
        this.audit.event(EventType.VALIDATE_ACCESS_TOKEN);
        AccessToken token = null;
        try {
            token = RSATokenVerifier.verifyToken((String)tokenString, (PublicKey)this.realm.getPublicKey(), (String)this.realm.getName());
        }
        catch (Exception e) {
            HashMap<String, String> err = new HashMap<String, String>();
            err.put("error", "invalid_grant");
            err.put("error_description", "Token invalid");
            this.audit.error("invalid_token");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
        }
        this.audit.user(token.getSubject()).session(token.getSessionState()).detail("validate_access_token", token.getId());
        if (token.isExpired() || token.getIssuedAt() < this.realm.getNotBefore()) {
            HashMap<String, String> err = new HashMap<String, String>();
            err.put("error", "invalid_grant");
            err.put("error_description", "Token expired");
            this.audit.error("invalid_token");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
        }
        UserModel user = this.session.users().getUserById(token.getSubject(), this.realm);
        if (user == null) {
            HashMap<String, String> err = new HashMap<String, String>();
            err.put("error", "invalid_grant");
            err.put("error_description", "User does not exist");
            this.audit.error("user_not_found");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
        }
        if (!user.isEnabled()) {
            HashMap<String, String> err = new HashMap<String, String>();
            err.put("error", "invalid_grant");
            err.put("error_description", "User disabled");
            this.audit.error("user_disabled");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
        }
        UserSessionModel userSession = this.session.sessions().getUserSession(this.realm, token.getSessionState());
        if (!AuthenticationManager.isSessionValid(this.realm, userSession)) {
            HashMap<String, String> err = new HashMap<String, String>();
            err.put("error", "invalid_grant");
            err.put("error_description", "Expired session");
            this.audit.error("user_session_not_found");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
        }
        ClientModel client = this.realm.findClient(token.getIssuedFor());
        if (client == null) {
            HashMap<String, String> err = new HashMap<String, String>();
            err.put("error", "invalid_client");
            err.put("error_description", "Issued for client no longer exists");
            this.audit.error("client_not_found");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
        }
        if (token.getIssuedAt() < client.getNotBefore()) {
            HashMap<String, String> err = new HashMap<String, String>();
            err.put("error", "invalid_client");
            err.put("error_description", "Issued for client no longer exists");
            this.audit.error("invalid_token");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
        }
        try {
            this.tokenManager.verifyAccess(token, this.realm, client, user);
        }
        catch (OAuthErrorException e) {
            HashMap<String, String> err = new HashMap<String, String>();
            err.put("error", "invalid_grant");
            err.put("error_description", "Role mappings have changed");
            this.audit.error("invalid_token");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
        }
        return Response.ok((Object)token, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @Path(value="refresh")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response refreshAccessToken(@HeaderParam(value="Authorization") String authorizationHeader, MultivaluedMap<String, String> form) {
        AccessToken accessToken;
        logger.info((Object)"--> refreshAccessToken");
        if (!this.checkSsl()) {
            return this.createError("https_required", "HTTPS required", Response.Status.FORBIDDEN);
        }
        this.audit.event(EventType.REFRESH_TOKEN);
        ClientModel client = this.authorizeClient(authorizationHeader, form, this.audit);
        String refreshToken = (String)form.getFirst((Object)"refresh_token");
        if (refreshToken == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_request");
            error.put("error_description", "No refresh token");
            this.audit.error("invalid_token");
            logger.error((Object)"OAuth Error: no refresh token");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build();
        }
        try {
            accessToken = this.tokenManager.refreshAccessToken(this.session, this.uriInfo, this.clientConnection, this.realm, client, refreshToken, this.audit);
        }
        catch (OAuthErrorException e) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", e.getError());
            if (e.getDescription() != null) {
                error.put("error_description", e.getDescription());
            }
            this.audit.error("invalid_token");
            logger.error((Object)"OAuth Error", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build();
        }
        AccessTokenResponse res = this.tokenManager.responseBuilder(this.realm, client, this.audit).accessToken(accessToken).generateIDToken().generateRefreshToken().build();
        this.audit.success();
        return Cors.add(this.request, Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE)).auth().allowedOrigins(client).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
    }

    @Path(value="auth/request/login")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processLogin(@QueryParam(value="client_id") String clientId, @QueryParam(value="scope") String scopeParam, @QueryParam(value="state") String state, @QueryParam(value="redirect_uri") String redirect, MultivaluedMap<String, String> formData) {
        logger.debug((Object)"TokenService.processLogin");
        String username = (String)formData.getFirst((Object)"username");
        String rememberMe = (String)formData.getFirst((Object)"rememberMe");
        boolean remember = rememberMe != null && rememberMe.equalsIgnoreCase("on");
        logger.debug((Object)("*** Remember me: " + remember));
        this.audit.event(EventType.LOGIN).client(clientId).detail("redirect_uri", redirect).detail("response_type", "code").detail("auth_method", "form").detail("username", username);
        if (remember) {
            this.audit.detail("remember_me", "true");
        }
        OAuthFlows oauth = Flows.oauth(this.session, this.realm, this.request, this.uriInfo, this.clientConnection, this.authManager, this.tokenManager);
        if (!this.checkSsl()) {
            return oauth.forwardToSecurityFailure("HTTPS required");
        }
        if (!this.realm.isEnabled()) {
            this.audit.error("realm_disabled");
            return oauth.forwardToSecurityFailure("Realm not enabled.");
        }
        ClientModel client = this.realm.findClient(clientId);
        if (client == null) {
            this.audit.error("client_not_found");
            return oauth.forwardToSecurityFailure("Unknown login requester.");
        }
        if (!client.isEnabled()) {
            this.audit.error("client_not_found");
            return oauth.forwardToSecurityFailure("Login requester not enabled.");
        }
        if ((redirect = TokenService.verifyRedirectUri(this.uriInfo, redirect, this.realm, client)) == null) {
            this.audit.error("invalid_redirect_uri");
            return oauth.forwardToSecurityFailure("Invalid redirect_uri.");
        }
        if (formData.containsKey((Object)"cancel")) {
            this.audit.error("rejected_by_user");
            return oauth.redirectError(client, "access_denied", state, redirect);
        }
        AuthenticationManager.AuthenticationStatus status = this.authManager.authenticateForm(this.session, this.clientConnection, this.realm, formData);
        if (remember) {
            this.authManager.createRememberMeCookie(this.realm, this.uriInfo, this.clientConnection);
        } else {
            AuthenticationManager.expireRememberMeCookie(this.realm, this.uriInfo, this.clientConnection);
        }
        UserModel user = KeycloakModelUtils.findUserByNameOrEmail((KeycloakSession)this.session, (RealmModel)this.realm, (String)username);
        if (user != null) {
            this.audit.user(user);
        }
        switch (status) {
            case SUCCESS: 
            case ACTIONS_REQUIRED: {
                UserSessionModel userSession = this.session.sessions().createUserSession(this.realm, user, username, this.clientConnection.getRemoteAddr(), "form", remember);
                this.audit.session(userSession);
                return oauth.processAccessCode(scopeParam, state, redirect, client, user, userSession, this.audit);
            }
            case ACCOUNT_TEMPORARILY_DISABLED: {
                this.audit.error("user_temporarily_disabled");
                return Flows.forms(this.session, this.realm, client, this.uriInfo).setError("accountTemporarilyDisabled").setFormData(formData).createLogin();
            }
            case ACCOUNT_DISABLED: {
                this.audit.error("user_disabled");
                return Flows.forms(this.session, this.realm, client, this.uriInfo).setError("accountDisabled").setFormData(formData).createLogin();
            }
            case MISSING_TOTP: {
                return Flows.forms(this.session, this.realm, client, this.uriInfo).setFormData(formData).createLoginTotp();
            }
            case INVALID_USER: {
                this.audit.error("user_not_found");
                return Flows.forms(this.session, this.realm, client, this.uriInfo).setError("invalidUser").setFormData(formData).createLogin();
            }
        }
        this.audit.error("invalid_user_credentials");
        return Flows.forms(this.session, this.realm, client, this.uriInfo).setError("invalidUser").setFormData(formData).createLogin();
    }

    @Path(value="auth/request/login-actions")
    public RequiredActionsService getRequiredActionsService() {
        RequiredActionsService service = new RequiredActionsService(this.realm, this.tokenManager, this.audit);
        ResteasyProviderFactory.getInstance().injectProperties((Object)service);
        return service;
    }

    @Path(value="registrations")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processRegister(@QueryParam(value="client_id") String clientId, @QueryParam(value="scope") String scopeParam, @QueryParam(value="state") String state, @QueryParam(value="redirect_uri") String redirect, MultivaluedMap<String, String> formData) {
        String username = (String)formData.getFirst((Object)"username");
        String email = (String)formData.getFirst((Object)"email");
        this.audit.event(EventType.REGISTER).client(clientId).detail("redirect_uri", redirect).detail("response_type", "code").detail("username", username).detail("email", email).detail("register_method", "form");
        OAuthFlows oauth = Flows.oauth(this.session, this.realm, this.request, this.uriInfo, this.clientConnection, this.authManager, this.tokenManager);
        if (!this.realm.isEnabled()) {
            logger.warn((Object)"Realm not enabled");
            this.audit.error("realm_disabled");
            return oauth.forwardToSecurityFailure("Realm not enabled");
        }
        ClientModel client = this.realm.findClient(clientId);
        if (client == null) {
            logger.warn((Object)"Unknown login requester.");
            this.audit.error("client_not_found");
            return oauth.forwardToSecurityFailure("Unknown login requester.");
        }
        if (!client.isEnabled()) {
            logger.warn((Object)"Login requester not enabled.");
            this.audit.error("client_disabled");
            return oauth.forwardToSecurityFailure("Login requester not enabled.");
        }
        if ((redirect = TokenService.verifyRedirectUri(this.uriInfo, redirect, this.realm, client)) == null) {
            this.audit.error("invalid_redirect_uri");
            return oauth.forwardToSecurityFailure("Invalid redirect_uri.");
        }
        if (!this.realm.isRegistrationAllowed()) {
            logger.warn((Object)"Registration not allowed");
            this.audit.error("registration_disabled");
            return oauth.forwardToSecurityFailure("Registration not allowed");
        }
        LinkedList<String> requiredCredentialTypes = new LinkedList<String>();
        for (RequiredCredentialModel m : this.realm.getRequiredCredentials()) {
            requiredCredentialTypes.add(m.getType());
        }
        String error = Validation.validateRegistrationForm(formData, requiredCredentialTypes);
        if (error == null) {
            error = Validation.validatePassword(formData, this.realm.getPasswordPolicy());
        }
        if (error != null) {
            this.audit.error("invalid_registration");
            return Flows.forms(this.session, this.realm, client, this.uriInfo).setError(error).setFormData(formData).createRegistration();
        }
        if (this.session.users().getUserByUsername(username, this.realm) != null) {
            this.audit.error("username_in_use");
            return Flows.forms(this.session, this.realm, client, this.uriInfo).setError("usernameExists").setFormData(formData).createRegistration();
        }
        UserModel user = this.session.users().addUser(this.realm, username);
        user.setEnabled(true);
        user.setFirstName((String)formData.getFirst((Object)"firstName"));
        user.setLastName((String)formData.getFirst((Object)"lastName"));
        user.setEmail(email);
        if (requiredCredentialTypes.contains("password")) {
            boolean passwordUpdateSuccessful;
            UserCredentialModel credentials = new UserCredentialModel();
            credentials.setType("password");
            credentials.setValue((String)formData.getFirst((Object)"password"));
            String passwordUpdateError = null;
            try {
                this.session.users().updateCredential(this.realm, user, UserCredentialModel.password((String)((String)formData.getFirst((Object)"password"))));
                passwordUpdateSuccessful = true;
            }
            catch (Exception ape) {
                passwordUpdateSuccessful = false;
                passwordUpdateError = ape.getMessage();
            }
            if (!passwordUpdateSuccessful) {
                user.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
                return Flows.forms(this.session, this.realm, client, this.uriInfo).setError(passwordUpdateError).createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
            }
        }
        this.audit.user(user).success();
        this.audit.reset();
        return this.processLogin(clientId, scopeParam, state, redirect, formData);
    }

    @Path(value="access/codes")
    @OPTIONS
    @Produces(value={"application/json"})
    public Response accessCodeToTokenPreflight() {
        logger.debugv("cors request from: {0}", this.request.getHttpHeaders().getRequestHeaders().getFirst((Object)"Origin"));
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @Path(value="access/codes")
    @POST
    @Produces(value={"application/json"})
    public Response accessCodeToToken(@HeaderParam(value="Authorization") String authorizationHeader, MultivaluedMap<String, String> formData) {
        logger.debug((Object)"accessRequest <---");
        if (!this.checkSsl()) {
            throw new ForbiddenException("HTTPS required");
        }
        this.audit.event(EventType.CODE_TO_TOKEN);
        if (!this.realm.isEnabled()) {
            this.audit.error("realm_disabled");
            throw new UnauthorizedException("Realm not enabled");
        }
        String code = (String)formData.getFirst((Object)"code");
        if (code == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_request");
            error.put("error_description", "code not specified");
            this.audit.error("invalid_code");
            throw new BadRequestException("Code not specified", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build());
        }
        AccessCode accessCode = AccessCode.parse(code, this.session, this.realm);
        if (accessCode == null) {
            String[] parts = code.split("\\.");
            if (parts.length == 2) {
                try {
                    this.audit.detail("code_id", new String(Base64Url.decode((String)parts[1])));
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Code not found");
            this.audit.error("invalid_code");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        this.audit.detail("code_id", accessCode.getCodeId());
        if (!accessCode.isValid(ClientSessionModel.Action.CODE_TO_TOKEN)) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Code is expired");
            this.audit.error("invalid_code");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        accessCode.setAction(null);
        this.audit.user(accessCode.getUser());
        this.audit.session(accessCode.getSessionState());
        ClientModel client = this.authorizeClient(authorizationHeader, formData, this.audit);
        if (!client.getClientId().equals(accessCode.getClient().getClientId())) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Auth error");
            this.audit.error("invalid_code");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        UserModel user = this.session.users().getUserById(accessCode.getUser().getId(), this.realm);
        if (user == null) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "User not found");
            this.audit.error("invalid_code");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        if (!user.isEnabled()) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "User disabled");
            this.audit.error("invalid_code");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        UserSessionModel userSession = this.session.sessions().getUserSession(this.realm, accessCode.getSessionState());
        if (!AuthenticationManager.isSessionValid(this.realm, userSession)) {
            AuthenticationManager.logout(this.session, this.realm, userSession, this.uriInfo, this.clientConnection);
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Session not active");
            this.audit.error("invalid_code");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        logger.debug((Object)"accessRequest SUCCESS");
        AccessToken token = this.tokenManager.createClientAccessToken(accessCode.getRequestedRoles(), this.realm, client, user, userSession);
        try {
            this.tokenManager.verifyAccess(token, this.realm, client, user);
        }
        catch (OAuthErrorException e) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", e.getError());
            if (e.getDescription() != null) {
                error.put("error_description", e.getDescription());
            }
            this.audit.error("invalid_code");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build();
        }
        AccessTokenResponse res = this.tokenManager.responseBuilder(this.realm, client, this.audit).accessToken(token).generateIDToken().generateRefreshToken().build();
        this.audit.success();
        return Cors.add(this.request, Response.ok((Object)res)).auth().allowedOrigins(client).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
    }

    protected ClientModel authorizeClient(String authorizationHeader, MultivaluedMap<String, String> formData, Audit audit) {
        String clientSecret;
        String client_id;
        if (authorizationHeader != null) {
            String[] usernameSecret = BasicAuthHelper.parseHeader((String)authorizationHeader);
            if (usernameSecret == null) {
                throw new UnauthorizedException("Bad Authorization header", Response.status((int)401).header("WWW-Authenticate", (Object)("Basic realm=\"" + this.realm.getName() + "\"")).build());
            }
            client_id = usernameSecret[0];
            clientSecret = usernameSecret[1];
        } else {
            logger.info((Object)"no authorization header");
            client_id = (String)formData.getFirst((Object)"client_id");
            clientSecret = (String)formData.getFirst((Object)"client_secret");
        }
        if (client_id == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_client");
            error.put("error_description", "Could not find client");
            throw new BadRequestException("Could not find client", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build());
        }
        audit.client(client_id);
        ClientModel client = this.realm.findClient(client_id);
        if (client == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_client");
            error.put("error_description", "Could not find client");
            audit.error("client_not_found");
            throw new BadRequestException("Could not find client", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build());
        }
        if (!client.isEnabled()) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_client");
            error.put("error_description", "Client is not enabled");
            audit.error("client_disabled");
            throw new BadRequestException("Client is not enabled", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build());
        }
        if (client instanceof ApplicationModel && ((ApplicationModel)client).isBearerOnly()) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_client");
            error.put("error_description", "Bearer-only not allowed");
            audit.error("invalid_client");
            throw new BadRequestException("Bearer-only not allowed", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build());
        }
        if (!(client.isPublicClient() || clientSecret != null && client.validateSecret(clientSecret))) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "unauthorized_client");
            audit.error("invalid_client_credentials");
            throw new BadRequestException("Unauthorized Client", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build());
        }
        return client;
    }

    @Path(value="login")
    @GET
    public Response loginPage(@QueryParam(value="response_type") String responseType, @QueryParam(value="redirect_uri") String redirect, @QueryParam(value="client_id") String clientId, @QueryParam(value="scope") String scopeParam, @QueryParam(value="state") String state, @QueryParam(value="prompt") String prompt, @QueryParam(value="login_hint") String loginHint) {
        logger.info((Object)"TokenService.loginPage");
        this.audit.event(EventType.LOGIN).client(clientId).detail("redirect_uri", redirect).detail("response_type", "code");
        OAuthFlows oauth = Flows.oauth(this.session, this.realm, this.request, this.uriInfo, this.clientConnection, this.authManager, this.tokenManager);
        if (!this.checkSsl()) {
            return oauth.forwardToSecurityFailure("HTTPS required");
        }
        if (!this.realm.isEnabled()) {
            logger.warn((Object)"Realm not enabled");
            this.audit.error("realm_disabled");
            return oauth.forwardToSecurityFailure("Realm not enabled");
        }
        ClientModel client = this.realm.findClient(clientId);
        if (client == null) {
            logger.warn((Object)("Unknown login requester: " + clientId));
            this.audit.error("client_not_found");
            return oauth.forwardToSecurityFailure("Unknown login requester.");
        }
        if (!client.isEnabled()) {
            logger.warn((Object)"Login requester not enabled.");
            this.audit.error("client_disabled");
            return oauth.forwardToSecurityFailure("Login requester not enabled.");
        }
        if (client instanceof ApplicationModel && ((ApplicationModel)client).isBearerOnly()) {
            this.audit.error("not_allowed");
            return oauth.forwardToSecurityFailure("Bearer-only applications are not allowed to initiate browser login");
        }
        if (client.isDirectGrantsOnly()) {
            this.audit.error("not_allowed");
            return oauth.forwardToSecurityFailure("direct-grants-only clients are not allowed to initiate browser login");
        }
        if ((redirect = TokenService.verifyRedirectUri(this.uriInfo, redirect, this.realm, client)) == null) {
            this.audit.error("invalid_redirect_uri");
            return oauth.forwardToSecurityFailure("Invalid redirect_uri.");
        }
        logger.info((Object)"Checking cookie...");
        AuthenticationManager.AuthResult authResult = this.authManager.authenticateIdentityCookie(this.session, this.realm, this.uriInfo, this.clientConnection, this.headers);
        if (authResult != null) {
            UserModel user = authResult.getUser();
            UserSessionModel session = authResult.getSession();
            logger.debug((Object)(user.getUsername() + " already logged in."));
            this.audit.user(user).session(session).detail("auth_method", "sso");
            return oauth.processAccessCode(scopeParam, state, redirect, client, user, session, this.audit);
        }
        if (prompt != null && prompt.equals("none")) {
            return oauth.redirectError(client, "access_denied", state, redirect);
        }
        LoginFormsProvider forms = Flows.forms(this.session, this.realm, client, this.uriInfo);
        if (loginHint != null) {
            MultivaluedMapImpl formData = new MultivaluedMapImpl();
            formData.add((Object)"username", (Object)loginHint);
            forms.setFormData((MultivaluedMap)formData);
        }
        return forms.createLogin();
    }

    @Path(value="registrations")
    @GET
    public Response registerPage(@QueryParam(value="response_type") String responseType, @QueryParam(value="redirect_uri") String redirect, @QueryParam(value="client_id") String clientId, @QueryParam(value="scope") String scopeParam, @QueryParam(value="state") String state) {
        logger.info((Object)"**********registerPage()");
        this.audit.event(EventType.REGISTER).client(clientId).detail("redirect_uri", redirect).detail("response_type", "code");
        OAuthFlows oauth = Flows.oauth(this.session, this.realm, this.request, this.uriInfo, this.clientConnection, this.authManager, this.tokenManager);
        if (!this.checkSsl()) {
            return oauth.forwardToSecurityFailure("HTTPS required");
        }
        if (!this.realm.isEnabled()) {
            logger.warn((Object)"Realm not enabled");
            this.audit.error("realm_disabled");
            return oauth.forwardToSecurityFailure("Realm not enabled");
        }
        ClientModel client = this.realm.findClient(clientId);
        if (client == null) {
            logger.warn((Object)"Unknown login requester.");
            this.audit.error("client_not_found");
            return oauth.forwardToSecurityFailure("Unknown login requester.");
        }
        if (!client.isEnabled()) {
            logger.warn((Object)"Login requester not enabled.");
            this.audit.error("client_disabled");
            return oauth.forwardToSecurityFailure("Login requester not enabled.");
        }
        if ((redirect = TokenService.verifyRedirectUri(this.uriInfo, redirect, this.realm, client)) == null) {
            this.audit.error("invalid_redirect_uri");
            return oauth.forwardToSecurityFailure("Invalid redirect_uri.");
        }
        if (!this.realm.isRegistrationAllowed()) {
            logger.warn((Object)"Registration not allowed");
            this.audit.error("registration_disabled");
            return oauth.forwardToSecurityFailure("Registration not allowed");
        }
        AuthenticationManager.expireIdentityCookie(this.realm, this.uriInfo, this.clientConnection);
        return Flows.forms(this.session, this.realm, client, this.uriInfo).createRegistration();
    }

    @Path(value="logout")
    @GET
    @NoCache
    public Response logout(@QueryParam(value="redirect_uri") String redirectUri) {
        AuthenticationManager.AuthResult authResult;
        this.audit.event(EventType.LOGOUT);
        if (redirectUri != null) {
            this.audit.detail("redirect_uri", redirectUri);
        }
        if ((authResult = this.authManager.authenticateIdentityCookie(this.session, this.realm, this.uriInfo, this.clientConnection, this.headers, false)) != null) {
            this.logout(authResult.getSession());
        }
        if (redirectUri != null) {
            String validatedRedirect = TokenService.verifyRealmRedirectUri(this.uriInfo, redirectUri, this.realm);
            if (validatedRedirect == null) {
                OAuthFlows oauth = Flows.oauth(this.session, this.realm, this.request, this.uriInfo, this.clientConnection, this.authManager, this.tokenManager);
                return oauth.forwardToSecurityFailure("Invalid redirect uri.");
            }
            return Response.status((int)302).location(UriBuilder.fromUri((String)validatedRedirect).build(new Object[0])).build();
        }
        return Response.ok().build();
    }

    @Path(value="logout")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response logoutToken(@HeaderParam(value="Authorization") String authorizationHeader, MultivaluedMap<String, String> form) {
        logger.info((Object)"--> logoutToken");
        if (!this.checkSsl()) {
            throw new NotAcceptableException("HTTPS required");
        }
        this.audit.event(EventType.LOGOUT);
        ClientModel client = this.authorizeClient(authorizationHeader, form, this.audit);
        String refreshToken = (String)form.getFirst((Object)"refresh_token");
        if (refreshToken == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_request");
            error.put("error_description", "No refresh token");
            this.audit.error("invalid_token");
            logger.error((Object)"OAuth Error: no refresh token");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build();
        }
        try {
            RefreshToken token = this.tokenManager.verifyRefreshToken(this.realm, refreshToken);
            UserSessionModel userSessionModel = this.session.sessions().getUserSession(this.realm, token.getSessionState());
            if (userSessionModel != null) {
                this.logout(userSessionModel);
            }
        }
        catch (OAuthErrorException e) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", e.getError());
            if (e.getDescription() != null) {
                error.put("error_description", e.getDescription());
            }
            this.audit.error("invalid_token");
            logger.error((Object)"OAuth Error", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build();
        }
        return Cors.add(this.request, Response.noContent()).auth().allowedOrigins(client).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
    }

    private void logout(UserSessionModel userSession) {
        AuthenticationManager.logout(this.session, this.realm, userSession, this.uriInfo, this.clientConnection);
        this.audit.user(userSession.getUser()).session(userSession).success();
    }

    @Path(value="oauth/grant")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processOAuth(MultivaluedMap<String, String> formData) {
        this.audit.event(EventType.LOGIN).detail("response_type", "code");
        OAuthFlows oauth = Flows.oauth(this.session, this.realm, this.request, this.uriInfo, this.clientConnection, this.authManager, this.tokenManager);
        if (!this.checkSsl()) {
            return oauth.forwardToSecurityFailure("HTTPS required");
        }
        String code = (String)formData.getFirst((Object)"code");
        AccessCode accessCode = AccessCode.parse(code, this.session, this.realm);
        if (accessCode == null || !accessCode.isValid(ClientSessionModel.Action.OAUTH_GRANT)) {
            this.audit.error("invalid_code");
            return oauth.forwardToSecurityFailure("Invalid access code.");
        }
        this.audit.detail("code_id", accessCode.getCodeId());
        String redirect = accessCode.getRedirectUri();
        String state = accessCode.getState();
        this.audit.client(accessCode.getClient()).user(accessCode.getUser()).detail("response_type", "code").detail("redirect_uri", redirect);
        UserSessionModel userSession = this.session.sessions().getUserSession(this.realm, accessCode.getSessionState());
        if (userSession != null) {
            this.audit.detail("auth_method", userSession.getAuthMethod());
            this.audit.detail("username", userSession.getLoginUsername());
            if (userSession.isRememberMe()) {
                this.audit.detail("remember_me", "true");
            }
        }
        if (!AuthenticationManager.isSessionValid(this.realm, userSession)) {
            AuthenticationManager.logout(this.session, this.realm, userSession, this.uriInfo, this.clientConnection);
            this.audit.error("invalid_code");
            return oauth.forwardToSecurityFailure("Session not active");
        }
        this.audit.session(userSession);
        if (formData.containsKey((Object)"cancel")) {
            this.audit.error("rejected_by_user");
            return this.redirectAccessDenied(redirect, state);
        }
        this.audit.success();
        accessCode.setAction(ClientSessionModel.Action.CODE_TO_TOKEN);
        return oauth.redirectAccessCode(accessCode, userSession, state, redirect);
    }

    @Path(value="oauth/oob")
    @GET
    public Response installedAppUrnCallback(@QueryParam(value="code") String code, @QueryParam(value="error") String error, @QueryParam(value="error_description") String errorDescription) {
        LoginFormsProvider forms = Flows.forms(this.session, this.realm, null, this.uriInfo);
        if (code != null) {
            return forms.setAccessCode(code).createCode();
        }
        return forms.setError(error).createCode();
    }

    protected Response redirectAccessDenied(String redirect, String state) {
        UriBuilder redirectUri = UriBuilder.fromUri((String)redirect).queryParam("error", new Object[]{"access_denied"});
        if (state != null) {
            redirectUri.queryParam("state", new Object[]{state});
        }
        Response.ResponseBuilder location = Response.status((int)302).location(redirectUri.build(new Object[0]));
        return location.build();
    }

    public static boolean matchesRedirects(Set<String> validRedirects, String redirect) {
        for (String validRedirect : validRedirects) {
            if (validRedirect.endsWith("*")) {
                int length = validRedirect.length() - 1;
                if (redirect.startsWith(validRedirect = validRedirect.substring(0, length))) {
                    return true;
                }
                if (length - 1 > 0 && validRedirect.charAt(length - 1) == '/') {
                    --length;
                }
                if (!(validRedirect = validRedirect.substring(0, length)).equals(redirect)) continue;
                return true;
            }
            if (!validRedirect.equals(redirect)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getValidateRedirectUris(RealmModel realm) {
        HashSet<String> redirects = new HashSet<String>();
        for (ApplicationModel client : realm.getApplications()) {
            for (String redirect : client.getRedirectUris()) {
                redirects.add(redirect);
            }
        }
        for (ApplicationModel client : realm.getOAuthClients()) {
            for (String redirect : client.getRedirectUris()) {
                redirects.add(redirect);
            }
        }
        return redirects;
    }

    public static String verifyRealmRedirectUri(UriInfo uriInfo, String redirectUri, RealmModel realm) {
        Set<String> validRedirects = TokenService.getValidateRedirectUris(realm);
        return TokenService.verifyRedirectUri(uriInfo, redirectUri, realm, validRedirects);
    }

    public static String verifyRedirectUri(UriInfo uriInfo, String redirectUri, RealmModel realm, ClientModel client) {
        Set validRedirects = client.getRedirectUris();
        return TokenService.verifyRedirectUri(uriInfo, redirectUri, realm, validRedirects);
    }

    public static String verifyRedirectUri(UriInfo uriInfo, String redirectUri, RealmModel realm, Set<String> validRedirects) {
        if (redirectUri == null) {
            if (validRedirects.size() != 1) {
                return null;
            }
            String validRedirect = validRedirects.iterator().next();
            int idx = validRedirect.indexOf("/*");
            if (idx > -1) {
                validRedirect = validRedirect.substring(0, idx);
            }
            redirectUri = validRedirect;
        } else if (validRedirects.isEmpty()) {
            logger.error((Object)"No Redirect URIs supplied");
            redirectUri = null;
        } else {
            String r = redirectUri.indexOf(63) != -1 ? redirectUri.substring(0, redirectUri.indexOf(63)) : redirectUri;
            Set<String> resolveValidRedirects = TokenService.resolveValidRedirects(uriInfo, validRedirects);
            boolean valid = TokenService.matchesRedirects(resolveValidRedirects, r);
            if (!valid && r.startsWith("http://localhost") && r.indexOf(58, "http://localhost".length()) >= 0) {
                int i = r.indexOf(58, "http://localhost".length());
                StringBuilder sb = new StringBuilder();
                sb.append(r.substring(0, i));
                i = r.indexOf(47, i);
                if (i >= 0) {
                    sb.append(r.substring(i));
                }
                r = sb.toString();
                valid = TokenService.matchesRedirects(resolveValidRedirects, r);
            }
            if (valid && redirectUri.startsWith("/")) {
                redirectUri = TokenService.relativeToAbsoluteURI(uriInfo, redirectUri);
            }
            String string = redirectUri = valid ? redirectUri : null;
        }
        if ("urn:ietf:wg:oauth:2.0:oob".equals(redirectUri)) {
            return Urls.realmInstalledAppUrnCallback(uriInfo.getBaseUri(), realm.getName()).toString();
        }
        return redirectUri;
    }

    public static Set<String> resolveValidRedirects(UriInfo uriInfo, Set<String> validRedirects) {
        HashSet<String> resolveValidRedirects = new HashSet<String>();
        for (String validRedirect : validRedirects) {
            resolveValidRedirects.add(validRedirect);
            if (!validRedirect.startsWith("/")) continue;
            validRedirect = TokenService.relativeToAbsoluteURI(uriInfo, validRedirect);
            logger.debugv("replacing relative valid redirect with: {0}", (Object)validRedirect);
            resolveValidRedirects.add(validRedirect);
        }
        return resolveValidRedirects;
    }

    public static String relativeToAbsoluteURI(UriInfo uriInfo, String relative) {
        URI baseUri = uriInfo.getBaseUri();
        String uri = baseUri.getScheme() + "://" + baseUri.getHost();
        if (baseUri.getPort() != -1) {
            uri = uri + ":" + baseUri.getPort();
        }
        relative = uri + relative;
        return relative;
    }

    private boolean checkSsl() {
        if (this.uriInfo.getBaseUri().getScheme().equals("https")) {
            return true;
        }
        return !this.realm.getSslRequired().isRequired(this.clientConnection);
    }

    private Response createError(String error, String errorDescription, Response.Status status) {
        HashMap<String, String> e = new HashMap<String, String>();
        e.put("error", error);
        if (errorDescription != null) {
            e.put("error_description", errorDescription);
        }
        return Response.status((Response.Status)status).entity(e).type("application/json").build();
    }
}

