/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.mongo;

import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.util.Collections;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.mongo.DefaultMongoConnectionProvider;
import org.keycloak.connections.mongo.MongoConnectionProvider;
import org.keycloak.connections.mongo.MongoConnectionProviderFactory;
import org.keycloak.connections.mongo.MongoKeycloakTransaction;
import org.keycloak.connections.mongo.api.MongoStore;
import org.keycloak.connections.mongo.impl.MongoStoreImpl;
import org.keycloak.connections.mongo.impl.context.TransactionMongoStoreInvocationContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;

public class DefaultMongoConnectionFactoryProvider
implements MongoConnectionProviderFactory {
    private String[] entities = new String[]{"org.keycloak.models.mongo.keycloak.entities.MongoRealmEntity", "org.keycloak.models.mongo.keycloak.entities.MongoUserEntity", "org.keycloak.models.mongo.keycloak.entities.MongoRoleEntity", "org.keycloak.models.entities.RequiredCredentialEntity", "org.keycloak.models.entities.CredentialEntity", "org.keycloak.models.entities.SocialLinkEntity", "org.keycloak.models.mongo.keycloak.entities.MongoApplicationEntity", "org.keycloak.models.mongo.keycloak.entities.MongoOAuthClientEntity", "org.keycloak.models.sessions.mongo.entities.MongoUsernameLoginFailureEntity", "org.keycloak.models.sessions.mongo.entities.MongoUserSessionEntity", "org.keycloak.models.sessions.mongo.entities.MongoClientSessionEntity", "org.keycloak.models.entities.UserFederationProviderEntity"};
    private static final Logger logger = Logger.getLogger(DefaultMongoConnectionFactoryProvider.class);
    private volatile MongoClient client;
    private MongoStore mongoStore;
    private DB db;
    private Config.Scope config;

    public MongoConnectionProvider create(KeycloakSession session) {
        this.lazyInit();
        TransactionMongoStoreInvocationContext invocationContext = new TransactionMongoStoreInvocationContext(this.mongoStore);
        session.getTransaction().enlist((KeycloakTransaction)new MongoKeycloakTransaction(invocationContext));
        return new DefaultMongoConnectionProvider(this.db, this.mongoStore, invocationContext);
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit() {
        if (this.client == null) {
            DefaultMongoConnectionFactoryProvider defaultMongoConnectionFactoryProvider = this;
            synchronized (defaultMongoConnectionFactoryProvider) {
                if (this.client == null) {
                    try {
                        String host = this.config.get("host", ServerAddress.defaultHost());
                        int port = this.config.getInt("port", Integer.valueOf(ServerAddress.defaultPort()));
                        String dbName = this.config.get("db", "keycloak");
                        boolean clearOnStartup = this.config.getBoolean("clearOnStartup", Boolean.valueOf(false));
                        String user = this.config.get("user");
                        String password = this.config.get("password");
                        if (user != null && password != null) {
                            MongoCredential credential = MongoCredential.createMongoCRCredential((String)user, (String)dbName, (char[])password.toCharArray());
                            this.client = new MongoClient(new ServerAddress(host, port), Collections.singletonList(credential));
                        } else {
                            this.client = new MongoClient(host, port);
                        }
                        this.db = this.client.getDB(dbName);
                        this.mongoStore = new MongoStoreImpl(this.db, clearOnStartup, this.getManagedEntities());
                        logger.infof("Initialized mongo model. host: %s, port: %d, db: %s, clearOnStartup: %b", new Object[]{host, port, dbName, clearOnStartup});
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    private Class[] getManagedEntities() throws ClassNotFoundException {
        Class[] entityClasses = new Class[this.entities.length];
        for (int i = 0; i < this.entities.length; ++i) {
            entityClasses[i] = Thread.currentThread().getContextClassLoader().loadClass(this.entities[i]);
        }
        return entityClasses;
    }

    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    public String getId() {
        return "default";
    }
}

