/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.mem;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.UsernameLoginFailureModel;
import org.keycloak.models.sessions.mem.ClientSessionAdapter;
import org.keycloak.models.sessions.mem.UserSessionAdapter;
import org.keycloak.models.sessions.mem.UsernameLoginFailureAdapter;
import org.keycloak.models.sessions.mem.entities.ClientSessionEntity;
import org.keycloak.models.sessions.mem.entities.UserSessionEntity;
import org.keycloak.models.sessions.mem.entities.UsernameLoginFailureEntity;
import org.keycloak.models.sessions.mem.entities.UsernameLoginFailureKey;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.util.Time;

public class MemUserSessionProvider
implements UserSessionProvider {
    private final KeycloakSession session;
    private final ConcurrentHashMap<String, UserSessionEntity> userSessions;
    private final ConcurrentHashMap<String, ClientSessionEntity> clientSessions;
    private final ConcurrentHashMap<UsernameLoginFailureKey, UsernameLoginFailureEntity> loginFailures;

    public MemUserSessionProvider(KeycloakSession session, ConcurrentHashMap<String, UserSessionEntity> userSessions, ConcurrentHashMap<String, ClientSessionEntity> clientSessions, ConcurrentHashMap<UsernameLoginFailureKey, UsernameLoginFailureEntity> loginFailures) {
        this.session = session;
        this.userSessions = userSessions;
        this.clientSessions = clientSessions;
        this.loginFailures = loginFailures;
    }

    public ClientSessionModel createClientSession(RealmModel realm, ClientModel client, UserSessionModel userSession, String redirectUri, String state, Set<String> roles) {
        UserSessionEntity userSessionEntity = this.getUserSessionEntity(realm, userSession.getId());
        ClientSessionEntity entity = new ClientSessionEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setTimestamp(Time.currentTime());
        entity.setClientId(client.getId());
        entity.setSession(userSessionEntity);
        entity.setRedirectUri(redirectUri);
        entity.setState(state);
        entity.setRoles(roles);
        userSessionEntity.addClientSession(entity);
        this.clientSessions.put(entity.getId(), entity);
        return new ClientSessionAdapter(this.session, this, realm, entity);
    }

    public ClientSessionModel getClientSession(RealmModel realm, String id) {
        ClientSessionEntity entity = this.clientSessions.get(id);
        return entity != null ? new ClientSessionAdapter(this.session, this, realm, entity) : null;
    }

    public UserSessionModel createUserSession(RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe) {
        String id = KeycloakModelUtils.generateId();
        UserSessionEntity entity = new UserSessionEntity();
        entity.setId(id);
        entity.setRealm(realm.getId());
        entity.setUser(user.getId());
        entity.setLoginUsername(loginUsername);
        entity.setIpAddress(ipAddress);
        entity.setAuthMethod(authMethod);
        entity.setRememberMe(rememberMe);
        int currentTime = Time.currentTime();
        entity.setStarted(currentTime);
        entity.setLastSessionRefresh(currentTime);
        this.userSessions.put(id, entity);
        return new UserSessionAdapter(this.session, this, realm, entity);
    }

    public UserSessionModel getUserSession(RealmModel realm, String id) {
        UserSessionEntity entity = this.getUserSessionEntity(realm, id);
        return entity != null ? new UserSessionAdapter(this.session, this, realm, entity) : null;
    }

    UserSessionEntity getUserSessionEntity(RealmModel realm, String id) {
        UserSessionEntity entity = this.userSessions.get(id);
        if (entity != null && entity.getRealm().equals(realm.getId())) {
            return entity;
        }
        return null;
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, UserModel user) {
        LinkedList<UserSessionModel> userSessions = new LinkedList<UserSessionModel>();
        for (UserSessionEntity s : this.userSessions.values()) {
            if (!s.getRealm().equals(realm.getId()) || !s.getUser().equals(user.getId())) continue;
            userSessions.add(new UserSessionAdapter(this.session, this, realm, s));
        }
        return userSessions;
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client) {
        LinkedList<UserSessionEntity> userSessionEntities = new LinkedList<UserSessionEntity>();
        for (ClientSessionEntity s : this.clientSessions.values()) {
            if (!s.getSession().getRealm().equals(realm.getId()) || !s.getClientId().equals(client.getId()) || userSessionEntities.contains(s.getSession())) continue;
            userSessionEntities.add(s.getSession());
        }
        LinkedList<UserSessionModel> userSessions = new LinkedList<UserSessionModel>();
        for (UserSessionEntity e : userSessionEntities) {
            userSessions.add(new UserSessionAdapter(this.session, this, realm, e));
        }
        Collections.sort(userSessions, new UserSessionSort());
        return userSessions;
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client, int firstResult, int maxResults) {
        List<UserSessionModel> userSessions = this.getUserSessions(realm, client);
        if (firstResult > userSessions.size()) {
            return Collections.emptyList();
        }
        int toIndex = firstResult + maxResults < userSessions.size() ? firstResult + maxResults : userSessions.size();
        return userSessions.subList(firstResult, toIndex);
    }

    public int getActiveUserSessions(RealmModel realm, ClientModel client) {
        return this.getUserSessions(realm, client).size();
    }

    public void removeUserSession(RealmModel realm, UserSessionModel session) {
        UserSessionEntity entity = this.getUserSessionEntity(realm, session.getId());
        if (entity != null) {
            this.userSessions.remove(entity.getId());
            for (ClientSessionEntity clientSession : entity.getClientSessions()) {
                this.clientSessions.remove(clientSession.getId());
            }
        }
    }

    public void removeUserSessions(RealmModel realm, UserModel user) {
        Iterator<UserSessionEntity> itr = this.userSessions.values().iterator();
        while (itr.hasNext()) {
            UserSessionEntity s = itr.next();
            if (!s.getRealm().equals(realm.getId()) || !s.getUser().equals(user.getId())) continue;
            itr.remove();
            for (ClientSessionEntity clientSession : s.getClientSessions()) {
                this.clientSessions.remove(clientSession.getId());
            }
        }
    }

    public void removeExpiredUserSessions(RealmModel realm) {
        Iterator<UserSessionEntity> itr = this.userSessions.values().iterator();
        while (itr.hasNext()) {
            UserSessionEntity s = itr.next();
            if (!s.getRealm().equals(realm.getId()) || s.getLastSessionRefresh() >= Time.currentTime() - realm.getSsoSessionIdleTimeout() && s.getStarted() >= Time.currentTime() - realm.getSsoSessionMaxLifespan()) continue;
            itr.remove();
            for (ClientSessionEntity clientSession : s.getClientSessions()) {
                this.clientSessions.remove(clientSession.getId());
            }
        }
    }

    public void removeUserSessions(RealmModel realm) {
        Iterator<UserSessionEntity> itr = this.userSessions.values().iterator();
        while (itr.hasNext()) {
            UserSessionEntity s = itr.next();
            if (!s.getRealm().equals(realm.getId())) continue;
            itr.remove();
            for (ClientSessionEntity clientSession : s.getClientSessions()) {
                this.clientSessions.remove(clientSession.getId());
            }
        }
    }

    public UsernameLoginFailureModel getUserLoginFailure(RealmModel realm, String username) {
        UsernameLoginFailureEntity entity = this.loginFailures.get(new UsernameLoginFailureKey(username, realm.getId()));
        return entity != null ? new UsernameLoginFailureAdapter(entity) : null;
    }

    public UsernameLoginFailureModel addUserLoginFailure(RealmModel realm, String username) {
        UsernameLoginFailureEntity entity;
        UsernameLoginFailureKey key = new UsernameLoginFailureKey(username, realm.getId());
        if (this.loginFailures.putIfAbsent(key, entity = new UsernameLoginFailureEntity(username, realm.getId())) != null) {
            throw new ModelDuplicateException();
        }
        return new UsernameLoginFailureAdapter(entity);
    }

    public List<UsernameLoginFailureModel> getAllUserLoginFailures(RealmModel realm) {
        LinkedList<UsernameLoginFailureModel> failures = new LinkedList<UsernameLoginFailureModel>();
        for (UsernameLoginFailureEntity entity : this.loginFailures.values()) {
            if (!entity.getRealm().equals(realm.getId())) continue;
            failures.add(new UsernameLoginFailureAdapter(entity));
        }
        return failures;
    }

    public void onRealmRemoved(RealmModel realm) {
        this.removeUserSessions(realm);
        Iterator<UsernameLoginFailureEntity> itr = this.loginFailures.values().iterator();
        while (itr.hasNext()) {
            if (!itr.next().getRealm().equals(realm.getId())) continue;
            itr.remove();
        }
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
        for (ClientSessionEntity e : this.clientSessions.values()) {
            if (!e.getSession().getRealm().equals(realm.getId()) || !e.getClientId().equals(client.getId())) continue;
            this.clientSessions.remove(e.getId());
            e.getSession().removeClientSession(e);
        }
    }

    public void onUserRemoved(RealmModel realm, UserModel user) {
        this.removeUserSessions(realm, user);
        this.loginFailures.remove(new UsernameLoginFailureKey(realm.getId(), user.getUsername()));
    }

    public void close() {
    }

    private class UserSessionSort
    implements Comparator<UserSessionModel> {
        private UserSessionSort() {
        }

        @Override
        public int compare(UserSessionModel o1, UserSessionModel o2) {
            int r = o1.getStarted() - o2.getStarted();
            if (r == 0) {
                return o1.getId().compareTo(o2.getId());
            }
            return r;
        }
    }
}

