/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.events.mongo;

import com.mongodb.DBCollection;
import com.mongodb.WriteConcern;
import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.mongo.MongoConnectionProvider;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.EventStoreProviderFactory;
import org.keycloak.events.EventType;
import org.keycloak.events.mongo.MongoEventStoreProvider;
import org.keycloak.models.KeycloakSession;

public class MongoEventStoreProviderFactory
implements EventStoreProviderFactory {
    protected static final Logger logger = Logger.getLogger(MongoEventStoreProviderFactory.class);
    public static final String ID = "mongo";
    private Set<EventType> includedEvents = new HashSet<EventType>();

    public EventStoreProvider create(KeycloakSession session) {
        MongoConnectionProvider connection = (MongoConnectionProvider)session.getProvider(MongoConnectionProvider.class);
        DBCollection collection = connection.getDB().getCollection("events");
        collection.setWriteConcern(WriteConcern.UNACKNOWLEDGED);
        return new MongoEventStoreProvider(collection, this.includedEvents);
    }

    /*
     * WARNING - void declaration
     */
    public void init(Config.Scope config) {
        String[] exclude;
        String[] include = config.getArray("include-events");
        if (include != null) {
            for (String string : include) {
                this.includedEvents.add(EventType.valueOf((String)string.toUpperCase()));
            }
        } else {
            for (String string : EventType.values()) {
                this.includedEvents.add((EventType)string);
            }
        }
        if ((exclude = config.getArray("exclude-events")) != null) {
            void var6_11;
            String[] arr$ = exclude;
            int len$ = arr$.length;
            boolean bl = false;
            while (var6_11 < len$) {
                String e = arr$[var6_11];
                this.includedEvents.remove(EventType.valueOf((String)e.toUpperCase()));
                ++var6_11;
            }
        }
    }

    public void close() {
    }

    public String getId() {
        return ID;
    }
}

