/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.mongo;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.mongo.MongoUserSessionProvider;
import org.keycloak.models.sessions.mongo.UserSessionAdapter;
import org.keycloak.models.sessions.mongo.entities.MongoClientSessionEntity;
import org.keycloak.models.sessions.mongo.entities.MongoUserSessionEntity;

public class ClientSessionAdapter
implements ClientSessionModel {
    private KeycloakSession session;
    private MongoUserSessionProvider provider;
    private RealmModel realm;
    private MongoClientSessionEntity entity;
    private MongoUserSessionEntity userSessionEntity;
    private MongoStoreInvocationContext invContext;

    public ClientSessionAdapter(KeycloakSession session, MongoUserSessionProvider provider, RealmModel realm, MongoClientSessionEntity entity, MongoUserSessionEntity userSessionEntity, MongoStoreInvocationContext invContext) {
        this.session = session;
        this.provider = provider;
        this.realm = realm;
        this.entity = entity;
        this.userSessionEntity = userSessionEntity;
        this.invContext = invContext;
    }

    public String getId() {
        return this.entity.getId();
    }

    public ClientModel getClient() {
        return this.realm.findClientById(this.entity.getClientId());
    }

    public String getState() {
        return this.entity.getState();
    }

    public UserSessionModel getUserSession() {
        return new UserSessionAdapter(this.session, this.provider, this.userSessionEntity, this.realm, this.invContext);
    }

    public String getRedirectUri() {
        return this.entity.getRedirectUri();
    }

    public int getTimestamp() {
        return this.entity.getTimestamp();
    }

    public void setTimestamp(int timestamp) {
        this.entity.setTimestamp(timestamp);
        this.invContext.getMongoStore().updateEntity((MongoIdentifiableEntity)this.userSessionEntity, this.invContext);
    }

    public ClientSessionModel.Action getAction() {
        return this.entity.getAction();
    }

    public void setAction(ClientSessionModel.Action action) {
        this.entity.setAction(action);
        this.invContext.getMongoStore().updateEntity((MongoIdentifiableEntity)this.userSessionEntity, this.invContext);
    }

    public Set<String> getRoles() {
        return this.entity.getRoles() != null ? new HashSet<String>(this.entity.getRoles()) : null;
    }
}

