/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.token.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.reflection.Reflections;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.TokenStoreConfiguration;
import org.picketlink.idm.credential.Token;
import org.picketlink.idm.credential.TokenCredential;
import org.picketlink.idm.credential.handler.TokenCredentialHandler;
import org.picketlink.idm.credential.handler.annotations.CredentialHandlers;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.internal.AbstractIdentityStore;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.annotation.IdentityStereotype;
import org.picketlink.idm.model.annotation.RelationshipStereotype;
import org.picketlink.idm.model.annotation.StereotypeProperty;
import org.picketlink.idm.model.basic.Realm;
import org.picketlink.idm.query.AttributeParameter;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.query.RelationshipQueryParameter;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.PartitionStore;

@CredentialHandlers(value={TokenCredentialHandler.class})
public class TokenIdentityStore
extends AbstractIdentityStore<TokenStoreConfiguration>
implements CredentialStore<TokenStoreConfiguration>,
PartitionStore<TokenStoreConfiguration> {
    private List<Token.Consumer> tokenConsumers;

    @Override
    public void setup(TokenStoreConfiguration config) {
        super.setup(config);
        this.tokenConsumers = config.getTokenConsumer();
    }

    @Override
    protected void removeFromRelationships(IdentityContext context, IdentityType identityType) {
    }

    @Override
    protected void removeCredentials(IdentityContext context, Account account) {
    }

    @Override
    protected void updateAttributedType(IdentityContext context, AttributedType attributedType) {
    }

    @Override
    protected void removeAttributedType(IdentityContext context, AttributedType attributedType) {
    }

    public <V extends IdentityType> List<V> fetchQueryResults(IdentityContext context, IdentityQuery<V> query) {
        ArrayList<IdentityType> identityTypes = new ArrayList<IdentityType>();
        Class identityTypeType = query.getIdentityType();
        IdentityStereotype stereotype = identityTypeType.getAnnotation(IdentityStereotype.class);
        if (stereotype == null) {
            throw new IdentityManagementException("Type [" + identityTypeType + "] does not define a " + IdentityStereotype.class + ".");
        }
        Token currentToken = this.getCurrentToken(context);
        IdentityType identityType = null;
        for (QueryParameter queryParameter : query.getParameters().keySet()) {
            String queryParameterName = ((AttributeParameter)queryParameter).getName();
            if (IdentityType.PARTITION.equals(queryParameter)) continue;
            Object[] queryParameterValues = query.getParameter(queryParameter);
            if (queryParameterValues == null || queryParameterValues.length == 0) {
                throw new IdentityManagementException("Query parameter [" + queryParameterName + "] does not have any value.");
            }
            if (queryParameterValues.length > 1) {
                throw new IdentityManagementException("Query parameter [" + queryParameterName + "] value must be single-valued.");
            }
            if (IdentityType.ID.equals(queryParameter)) {
                identityType = this.getTokenConsumer(currentToken).extractIdentity(currentToken, identityTypeType, StereotypeProperty.Property.IDENTITY_ID, queryParameterValues[0]);
                continue;
            }
            Property mappedProperty = PropertyQueries.createQuery((Class)identityTypeType).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{queryParameterName})).getFirstResult();
            if (mappedProperty == null) {
                throw new IdentityManagementException("IdentityType [" + identityTypeType + "] does not have a property with name [" + queryParameterName + "].");
            }
            StereotypeProperty stereotypeProperty = mappedProperty.getAnnotatedElement().getAnnotation(StereotypeProperty.class);
            if (stereotypeProperty == null) {
                throw new IdentityManagementException("Query parameter [" + queryParameterName + "] does not maps to a " + StereotypeProperty.Property.class + ".");
            }
            Object queryParameterValue = queryParameterValues[0];
            if (queryParameterValue == null) {
                throw new IdentityManagementException("Query parameter [" + queryParameterName + "] value can not be null.");
            }
            identityType = this.getTokenConsumer(currentToken).extractIdentity(currentToken, identityTypeType, stereotypeProperty.value(), queryParameterValue);
        }
        if (identityType != null) {
            identityTypes.add(identityType);
        }
        return Collections.unmodifiableList(identityTypes);
    }

    public <V extends Relationship> List<V> fetchQueryResults(IdentityContext context, RelationshipQuery<V> query) {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        Class relationshipType = query.getRelationshipClass();
        RelationshipStereotype stereotype = relationshipType.getAnnotation(RelationshipStereotype.class);
        if (stereotype == null) {
            throw new IdentityManagementException("Type [" + relationshipType + "] does not define a " + RelationshipStereotype.class + ".");
        }
        Relationship relationshipInstance = null;
        for (QueryParameter queryParameter : query.getParameters().keySet()) {
            String queryParameterName = ((RelationshipQueryParameter)queryParameter).getName();
            Property nameProperty = PropertyQueries.createQuery((Class)relationshipType).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{queryParameterName})).getFirstResult();
            if (nameProperty == null) {
                throw new IdentityManagementException("Type [" + relationshipType + "] does not have a property with name [" + queryParameterName + "].");
            }
            StereotypeProperty stereotypeProperty = nameProperty.getAnnotatedElement().getAnnotation(StereotypeProperty.class);
            if (stereotypeProperty == null) {
                throw new IdentityManagementException("Query parameter [" + queryParameterName + "] does not maps to a " + StereotypeProperty.Property.class + " for type [" + relationshipType + ".");
            }
            Object[] queryParameterValues = query.getParameter(queryParameter);
            if (queryParameterValues == null || queryParameterValues.length == 0) {
                throw new IdentityManagementException("Query parameter [" + queryParameterName + "] does not have any value.");
            }
            if (queryParameterValues.length > 1) {
                throw new IdentityManagementException("Query parameter [" + queryParameterName + "] value must be single-valued.");
            }
            Token currentToken = this.getCurrentToken(context);
            if (currentToken == null) continue;
            IdentityType identityType = this.resolveIdentityTypeFromToken(currentToken, queryParameterValues, stereotypeProperty);
            if (identityType == null) {
                return Collections.emptyList();
            }
            if (relationshipInstance == null) {
                try {
                    relationshipInstance = (Relationship)Reflections.newInstance((Class)relationshipType);
                }
                catch (Exception e) {
                    throw new IdentityManagementException("Could not create Relationship type [" + relationshipType + "].");
                }
            }
            Property property = this.resolveProperty(relationshipType, stereotypeProperty.value());
            property.setValue((Object)relationshipInstance, (Object)identityType);
        }
        if (relationshipInstance != null) {
            relationships.add(relationshipInstance);
        }
        return Collections.unmodifiableList(relationships);
    }

    public void storeCredential(IdentityContext context, Account account, CredentialStorage storage) {
    }

    public <T extends CredentialStorage> T retrieveCurrentCredential(IdentityContext context, Account account, Class<T> storageClass) {
        return null;
    }

    public <T extends CredentialStorage> List<T> retrieveCredentials(IdentityContext context, Account account, Class<T> storageClass) {
        return Collections.emptyList();
    }

    public void removeCredential(IdentityContext identityContext, Account account, Class<? extends CredentialStorage> aClass) {
    }

    private IdentityType resolveIdentityTypeFromToken(Token currentToken, Object[] queryParameterValues, StereotypeProperty stereotypeProperty) {
        IdentityType identityType;
        try {
            identityType = (IdentityType)queryParameterValues[0];
        }
        catch (ClassCastException cce) {
            throw new IdentityManagementException("Query parameter value is not an IdentityType instance.", (Throwable)cce);
        }
        if (identityType == null) {
            throw new IdentityManagementException("Query parameter value can not be null.");
        }
        if (StereotypeProperty.Property.RELATIONSHIP_GRANT_ROLE.equals((Object)stereotypeProperty.value())) {
            return this.extractIdentityTypeFromToken(currentToken, identityType, StereotypeProperty.Property.IDENTITY_ROLE_NAME);
        }
        if (StereotypeProperty.Property.RELATIONSHIP_GRANT_ASSIGNEE.equals((Object)stereotypeProperty.value()) || StereotypeProperty.Property.RELATIONSHIP_GROUP_MEMBERSHIP_MEMBER.equals((Object)stereotypeProperty.value())) {
            return this.extractIdentityTypeFromToken(currentToken, identityType, StereotypeProperty.Property.IDENTITY_USER_NAME);
        }
        if (StereotypeProperty.Property.RELATIONSHIP_GROUP_MEMBERSHIP_GROUP.equals((Object)stereotypeProperty.value())) {
            return this.extractIdentityTypeFromToken(currentToken, identityType, StereotypeProperty.Property.IDENTITY_GROUP_NAME);
        }
        throw new IdentityManagementException("Could not resolve any IdentityType [" + identityType + "] from Token [" + currentToken + ".");
    }

    private IdentityType extractIdentityTypeFromToken(Token token, IdentityType identityType, StereotypeProperty.Property stereotypeProperty) {
        Property mappedProperty = this.resolveProperty(identityType.getClass(), stereotypeProperty);
        Object identifier = mappedProperty.getValue((Object)identityType);
        if (identifier == null) {
            throw new IdentityManagementException("The IdentityType [" + identityType + "] does not have a value for property [" + mappedProperty.getName() + "].");
        }
        return this.getTokenConsumer(token).extractIdentity(token, identityType.getClass(), stereotypeProperty, identifier);
    }

    private Token.Consumer getTokenConsumer(Token token) {
        for (Token.Consumer consumer : this.tokenConsumers) {
            if (!consumer.getTokenType().isAssignableFrom(token.getClass())) continue;
            return consumer;
        }
        throw IDMMessages.MESSAGES.credentialNoConsumerForToken(token);
    }

    private Token getCurrentToken(IdentityContext context) {
        TokenCredential tokenCredential = this.getAuthenticatedAccountCredentials(context);
        return tokenCredential.getToken();
    }

    private TokenCredential getAuthenticatedAccountCredentials(IdentityContext context) {
        TokenCredential tokenCredential;
        try {
            tokenCredential = (TokenCredential)context.getParameter("CREDENTIALS");
        }
        catch (ClassCastException cce) {
            throw new IdentityManagementException("ContextParameter [CREDENTIALS does not reference a TokenCredential type instance.");
        }
        if (tokenCredential == null) {
            throw new IdentityManagementException("No TokenCredential found in the invocation context. Make sure you have a ContextInitializer which sets it.");
        }
        return tokenCredential;
    }

    private Property resolveProperty(Class<?> type, StereotypeProperty.Property stereotypeProperty) throws IdentityManagementException {
        List properties = PropertyQueries.createQuery(type).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(StereotypeProperty.class)).getResultList();
        if (properties.isEmpty()) {
            throw new IdentityManagementException("IdentityType [" + type + "] does not have any property mapped with " + StereotypeProperty.class + ".");
        }
        for (Property property : properties) {
            StereotypeProperty propertyStereotypeProperty = property.getAnnotatedElement().getAnnotation(StereotypeProperty.class);
            if (!stereotypeProperty.equals((Object)propertyStereotypeProperty.value())) continue;
            return property;
        }
        throw new IdentityManagementException("Could not resolve property in type [" + type + " for StereotypeProperty [" + stereotypeProperty + ".");
    }

    public String getConfigurationName(IdentityContext identityContext, Partition partition) {
        return null;
    }

    public <P extends Partition> P get(IdentityContext identityContext, Class<P> partitionClass, String name) {
        return (P)new Realm("default");
    }

    public <P extends Partition> List<P> get(IdentityContext identityContext, Class<P> partitionClass) {
        ArrayList<Realm> partitions = new ArrayList<Realm>();
        partitions.add(this.get(identityContext, Realm.class, "default"));
        return partitions;
    }

    public <P extends Partition> P lookupById(IdentityContext context, Class<P> partitionClass, String id) {
        return null;
    }

    public void add(IdentityContext identityContext, Partition partition, String configurationName) {
    }

    public void update(IdentityContext identityContext, Partition partition) {
    }

    public void remove(IdentityContext identityContext, Partition partition) {
    }
}

