/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.login.freemarker.model;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.models.RealmModel;
import org.keycloak.services.resources.flows.Urls;
import org.keycloak.social.SocialLoader;

public class SocialBean {
    private boolean displaySocial;
    private List<SocialProvider> providers;
    private RealmModel realm;

    public SocialBean(RealmModel realm, URI baseURI) {
        this.realm = realm;
        Map socialConfig = realm.getSocialConfig();
        if (realm.isSocial() && !socialConfig.isEmpty()) {
            this.displaySocial = true;
            this.providers = new LinkedList<SocialProvider>();
            UriBuilder socialLoginUrlBuilder = UriBuilder.fromUri((URI)Urls.socialRedirectToProviderAuth((URI)baseURI, (String)realm.getName()));
            for (org.keycloak.social.SocialProvider p : SocialLoader.load()) {
                if (!socialConfig.containsKey(p.getId() + ".key") || !socialConfig.containsKey(p.getId() + ".secret")) continue;
                String loginUrl = socialLoginUrlBuilder.replaceQueryParam("provider_id", new Object[]{p.getId()}).build(new Object[0]).toString();
                this.providers.add(new SocialProvider(p.getId(), p.getName(), loginUrl));
            }
        }
    }

    public List<SocialProvider> getProviders() {
        return this.providers;
    }

    public boolean isDisplayInfo() {
        return this.realm.isRegistrationAllowed() || this.displaySocial;
    }

    public boolean isDisplaySocialProviders() {
        return this.displaySocial;
    }

    public static class SocialProvider {
        private String id;
        private String name;
        private String loginUrl;

        public SocialProvider(String id, String name, String loginUrl) {
            this.id = id;
            this.name = name;
            this.loginUrl = loginUrl;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getLoginUrl() {
            return this.loginUrl;
        }
    }
}

