/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.representations.adapters.config.BaseRealmConfig;
import org.keycloak.services.managers.RealmManager;

public class OAuthClientManager {
    private RealmManager realmManager;

    public OAuthClientManager() {
    }

    public OAuthClientManager(RealmManager realmManager) {
        this.realmManager = realmManager;
    }

    public boolean removeClient(RealmModel realm, OAuthClientModel client) {
        if (realm.removeOAuthClient(client.getId())) {
            UserSessionProvider sessions = this.realmManager.getSession().sessions();
            if (sessions != null) {
                this.realmManager.getSession().sessions().onClientRemoved(realm, (ClientModel)client);
            }
            return true;
        }
        return false;
    }

    public InstallationAdapterConfig toInstallationRepresentation(RealmModel realmModel, OAuthClientModel model, URI baseUri) {
        InstallationAdapterConfig rep = new InstallationAdapterConfig();
        rep.setRealm(realmModel.getName());
        rep.setRealmKey(realmModel.getPublicKeyPem());
        rep.setSslRequired(realmModel.getSslRequired().name().toLowerCase());
        rep.setAuthServerUrl(baseUri.toString());
        if (model.isPublicClient()) {
            rep.setPublicClient(true);
        }
        rep.setResource(model.getClientId());
        if (!model.isPublicClient()) {
            HashMap<String, String> creds = new HashMap<String, String>();
            creds.put("secret", model.getSecret());
            rep.setCredentials(creds);
        }
        return rep;
    }

    @JsonPropertyOrder(value={"realm", "realm-public-key", "auth-server-url", "ssl-required", "resource", "public-client", "credentials"})
    public static class InstallationAdapterConfig
    extends BaseRealmConfig {
        @JsonProperty(value="public-client")
        protected Boolean publicClient;
        @JsonProperty(value="resource")
        protected String resource;
        @JsonProperty(value="credentials")
        protected Map<String, String> credentials;

        public String getResource() {
            return this.resource;
        }

        public void setResource(String resource) {
            this.resource = resource;
        }

        public Map<String, String> getCredentials() {
            return this.credentials;
        }

        public void setCredentials(Map<String, String> credentials) {
            this.credentials = credentials;
        }

        public Boolean getPublicClient() {
            return this.publicClient;
        }

        public void setPublicClient(Boolean publicClient) {
            this.publicClient = publicClient;
        }
    }
}

