/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.ClientConnection;
import org.keycloak.Config;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.EventsManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.AccountService;
import org.keycloak.services.resources.PublicRealmResource;
import org.keycloak.services.resources.TokenService;
import org.keycloak.util.StreamUtil;
import org.keycloak.util.UriUtils;

@Path(value="/realms")
public class RealmsResource {
    protected static Logger logger = Logger.getLogger(RealmsResource.class);
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders headers;
    @Context
    protected KeycloakSession session;
    @Context
    protected ClientConnection clientConnection;
    @Context
    protected BruteForceProtector protector;
    protected TokenManager tokenManager;

    public RealmsResource(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public static UriBuilder realmBaseUrl(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(RealmsResource.class, "getRealmResource");
    }

    public static UriBuilder realmBaseUrl(UriBuilder base) {
        return base.path(RealmsResource.class).path(RealmsResource.class, "getRealmResource");
    }

    public static UriBuilder accountUrl(UriBuilder base) {
        return base.path(RealmsResource.class).path(RealmsResource.class, "getAccountService");
    }

    @Path(value="{realm}/login-status-iframe.html")
    @GET
    @Produces(value={"text/html"})
    public Response getLoginStatusIframe(@PathParam(value="realm") String name, @QueryParam(value="client_id") String client_id, @QueryParam(value="origin") String origin) {
        if (!UriUtils.isOrigin((String)origin)) {
            throw new BadRequestException("Invalid origin");
        }
        AuthenticationManager auth = new AuthenticationManager();
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.locateRealm(name, realmManager);
        ClientModel client = realm.findClient(client_id);
        if (client == null) {
            throw new NotFoundException("could not find client: " + client_id);
        }
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("login-status-iframe.html");
        if (is == null) {
            throw new NotFoundException("Could not find login-status-iframe.html ");
        }
        boolean valid = false;
        for (String o : client.getWebOrigins()) {
            if (!o.equals("*") && !o.equals(origin)) continue;
            valid = true;
            break;
        }
        for (String r : TokenService.resolveValidRedirects(this.uriInfo, client.getRedirectUris())) {
            int i = r.indexOf(47, 8);
            if (i != -1) {
                r = r.substring(0, i);
            }
            if (!r.equals(origin)) continue;
            valid = true;
            break;
        }
        if (!valid) {
            throw new BadRequestException("Invalid origin");
        }
        try {
            String file = StreamUtil.readString((InputStream)is);
            file = file.replace("ORIGIN", origin);
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoTransform(false);
            cacheControl.setMaxAge(Config.scope((String[])new String[]{"theme"}).getInt("staticMaxAge", Integer.valueOf(-1)).intValue());
            return Response.ok((Object)file).cacheControl(cacheControl).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Path(value="{realm}/tokens")
    public TokenService getTokenService(@PathParam(value="realm") String name) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.locateRealm(name, realmManager);
        EventBuilder event = new EventsManager(realm, this.session, this.clientConnection).createEventBuilder();
        AuthenticationManager authManager = new AuthenticationManager(this.protector);
        TokenService tokenService = new TokenService(realm, this.tokenManager, event, authManager);
        ResteasyProviderFactory.getInstance().injectProperties((Object)tokenService);
        return tokenService;
    }

    protected RealmModel locateRealm(String name, RealmManager realmManager) {
        RealmModel realm = realmManager.getRealmByName(name);
        if (realm == null) {
            throw new NotFoundException("Realm " + name + " does not exist");
        }
        return realm;
    }

    @Path(value="{realm}/account")
    public AccountService getAccountService(@PathParam(value="realm") String name) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.locateRealm(name, realmManager);
        ApplicationModel application = (ApplicationModel)realm.getApplicationNameMap().get("account");
        if (application == null || !application.isEnabled()) {
            logger.debug((Object)"account management not enabled");
            throw new NotFoundException("account management not enabled");
        }
        EventBuilder event = new EventsManager(realm, this.session, this.clientConnection).createEventBuilder();
        AccountService accountService = new AccountService(realm, application, event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)accountService);
        accountService.init();
        return accountService;
    }

    @Path(value="{realm}")
    public PublicRealmResource getRealmResource(@PathParam(value="realm") String name) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.locateRealm(name, realmManager);
        PublicRealmResource realmResource = new PublicRealmResource(realm);
        ResteasyProviderFactory.getInstance().injectProperties((Object)realmResource);
        return realmResource;
    }
}

