/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.picketlink.idm;

import javax.naming.directory.SearchResult;
import org.picketlink.idm.IDMLog;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.config.LDAPMappingConfiguration;
import org.picketlink.idm.credential.UsernamePasswordCredentials;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.ldap.internal.LDAPIdentityStore;
import org.picketlink.idm.ldap.internal.LDAPPlainTextPasswordCredentialHandler;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.basic.BasicModel;
import org.picketlink.idm.model.basic.User;
import org.picketlink.idm.spi.IdentityContext;

public class LDAPKeycloakCredentialHandler
extends LDAPPlainTextPasswordCredentialHandler {
    protected User getAccount(IdentityContext context, String loginName) {
        IdentityManager identityManager = this.getIdentityManager(context);
        if (IDMLog.CREDENTIAL_LOGGER.isDebugEnabled()) {
            IDMLog.CREDENTIAL_LOGGER.debugf("Trying to find account [%s] using default account type [%s]", (Object)loginName, User.class);
        }
        return BasicModel.getUser((IdentityManager)identityManager, (String)loginName);
    }

    protected boolean validateCredential(IdentityContext context, CredentialStorage credentialStorage, UsernamePasswordCredentials credentials, LDAPIdentityStore ldapIdentityStore) {
        User account = this.getAccount(context, credentials.getUsername());
        char[] password = credentials.getPassword().getValue();
        String userDN = this.getDNOfUser(ldapIdentityStore, (Account)account);
        if (IDMLog.CREDENTIAL_LOGGER.isDebugEnabled()) {
            IDMLog.CREDENTIAL_LOGGER.debugf("Using DN [%s] for authentication of user [%s]", (Object)userDN, (Object)credentials.getUsername());
        }
        return ldapIdentityStore.getOperationManager().authenticate(userDN, new String(password));
    }

    protected String getDNOfUser(LDAPIdentityStore ldapIdentityStore, Account user) {
        LDAPMappingConfiguration userMappingConfig = ((LDAPIdentityStoreConfiguration)ldapIdentityStore.getConfig()).getMappingConfig(User.class);
        SearchResult sr = ldapIdentityStore.getOperationManager().lookupById(userMappingConfig.getBaseDN(), user.getId(), userMappingConfig);
        if (sr != null) {
            return sr.getNameInNamespace();
        }
        return ldapIdentityStore.getBindingDN((AttributedType)user, true);
    }
}

