/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.federation.ldap.LDAPUtils;
import org.keycloak.federation.ldap.ReadonlyLDAPUserModelDelegate;
import org.keycloak.federation.ldap.UnsyncedLDAPUserModelDelegate;
import org.keycloak.federation.ldap.WritableLDAPUserModelDelegate;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.model.basic.BasicModel;
import org.picketlink.idm.model.basic.User;
import org.picketlink.idm.query.IdentityQuery;

public class LDAPFederationProvider
implements UserFederationProvider {
    private static final Logger logger = Logger.getLogger(LDAPFederationProvider.class);
    public static final String LDAP_ID = "LDAP_ID";
    public static final String SYNC_REGISTRATIONS = "syncRegistrations";
    public static final String EDIT_MODE = "editMode";
    protected KeycloakSession session;
    protected UserFederationProviderModel model;
    protected PartitionManager partitionManager;
    protected UserFederationProvider.EditMode editMode;
    protected static final Set<String> supportedCredentialTypes = new HashSet<String>();

    public LDAPFederationProvider(KeycloakSession session, UserFederationProviderModel model, PartitionManager partitionManager) {
        this.session = session;
        this.model = model;
        this.partitionManager = partitionManager;
        String editModeString = (String)model.getConfig().get(EDIT_MODE);
        if (editModeString == null) {
            this.editMode = UserFederationProvider.EditMode.READ_ONLY;
        }
        this.editMode = UserFederationProvider.EditMode.valueOf((String)editModeString);
    }

    private ModelException convertIDMException(IdentityManagementException ie) {
        Throwable realCause = ie;
        while (realCause.getCause() != null) {
            realCause = realCause.getCause();
        }
        return new ModelException(realCause.getMessage(), (Throwable)ie);
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public UserFederationProviderModel getModel() {
        return this.model;
    }

    public PartitionManager getPartitionManager() {
        return this.partitionManager;
    }

    public UserModel proxy(UserModel local) {
        switch (this.editMode) {
            case READ_ONLY: {
                return new ReadonlyLDAPUserModelDelegate(local, this);
            }
            case WRITABLE: {
                return new WritableLDAPUserModelDelegate(local, this);
            }
            case UNSYNCED: {
                return new UnsyncedLDAPUserModelDelegate(local, this);
            }
        }
        return local;
    }

    public Set<String> getSupportedCredentialTypes(UserModel local) {
        if (this.editMode == UserFederationProvider.EditMode.UNSYNCED) {
            for (UserCredentialValueModel cred : local.getCredentialsDirectly()) {
                if (!cred.getType().equals("password")) continue;
                return Collections.emptySet();
            }
        }
        return supportedCredentialTypes;
    }

    public boolean synchronizeRegistrations() {
        return "true".equalsIgnoreCase((String)this.model.getConfig().get(SYNC_REGISTRATIONS)) && this.editMode == UserFederationProvider.EditMode.WRITABLE;
    }

    public UserModel register(RealmModel realm, UserModel user) {
        if (this.editMode == UserFederationProvider.EditMode.READ_ONLY || this.editMode == UserFederationProvider.EditMode.UNSYNCED) {
            throw new IllegalStateException("Registration is not supported by this ldap server");
        }
        if (!this.synchronizeRegistrations()) {
            throw new IllegalStateException("Registration is not supported by this ldap server");
        }
        try {
            User picketlinkUser = LDAPUtils.addUser(this.partitionManager, user.getUsername(), user.getFirstName(), user.getLastName(), user.getEmail());
            user.setAttribute(LDAP_ID, picketlinkUser.getId());
            return this.proxy(user);
        }
        catch (IdentityManagementException ie) {
            throw this.convertIDMException(ie);
        }
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        if (this.editMode == UserFederationProvider.EditMode.READ_ONLY || this.editMode == UserFederationProvider.EditMode.UNSYNCED) {
            logger.warnf("User '%s' can't be deleted in LDAP as editMode is '%s'", (Object)user.getUsername(), (Object)this.editMode.toString());
            return false;
        }
        try {
            return LDAPUtils.removeUser(this.partitionManager, user.getUsername());
        }
        catch (IdentityManagementException ie) {
            throw this.convertIDMException(ie);
        }
    }

    public List<UserModel> searchByAttributes(Map<String, String> attributes, RealmModel realm, int maxResults) {
        LinkedList<UserModel> searchResults = new LinkedList<UserModel>();
        try {
            Map<String, User> plUsers = this.searchPicketlink(attributes, maxResults);
            for (User user : plUsers.values()) {
                if (this.session.userStorage().getUserByUsername(user.getLoginName(), realm) != null) continue;
                UserModel imported = this.importUserFromPicketlink(realm, user);
                searchResults.add(imported);
            }
        }
        catch (IdentityManagementException ie) {
            throw this.convertIDMException(ie);
        }
        return searchResults;
    }

    protected Map<String, User> searchPicketlink(Map<String, String> attributes, int maxResults) {
        User user;
        IdentityManager identityManager = this.getIdentityManager();
        HashMap<String, User> results = new HashMap<String, User>();
        if (attributes.containsKey("username") && (user = BasicModel.getUser((IdentityManager)identityManager, (String)attributes.get("username"))) != null) {
            results.put(user.getLoginName(), user);
        }
        if (attributes.containsKey("email") && (user = this.queryByEmail(identityManager, attributes.get("email"))) != null) {
            results.put(user.getLoginName(), user);
        }
        if (attributes.containsKey("firstName") || attributes.containsKey("lastName")) {
            IdentityQuery query = identityManager.createIdentityQuery(User.class);
            if (attributes.containsKey("firstName")) {
                query.setParameter(User.FIRST_NAME, new Object[]{attributes.get("firstName")});
            }
            if (attributes.containsKey("lastName")) {
                query.setParameter(User.LAST_NAME, new Object[]{attributes.get("lastName")});
            }
            query.setLimit(maxResults);
            List agents = query.getResultList();
            for (User user2 : agents) {
                results.put(user2.getLoginName(), user2);
            }
        }
        return results;
    }

    public boolean isValid(UserModel local) {
        try {
            User picketlinkUser = LDAPUtils.getUser(this.partitionManager, local.getUsername());
            if (picketlinkUser == null) {
                return false;
            }
            return picketlinkUser.getId().equals(local.getAttribute(LDAP_ID));
        }
        catch (IdentityManagementException ie) {
            throw this.convertIDMException(ie);
        }
    }

    public UserModel getUserByUsername(RealmModel realm, String username) {
        try {
            User picketlinkUser = LDAPUtils.getUser(this.partitionManager, username);
            if (picketlinkUser == null) {
                return null;
            }
            if (!username.equals(picketlinkUser.getLoginName())) {
                logger.warnf("User found in LDAP but with different username. LDAP username: %s, Searched username: %s", (Object)username, (Object)picketlinkUser.getLoginName());
                return null;
            }
            return this.importUserFromPicketlink(realm, picketlinkUser);
        }
        catch (IdentityManagementException ie) {
            throw this.convertIDMException(ie);
        }
    }

    public IdentityManager getIdentityManager() {
        return this.partitionManager.createIdentityManager();
    }

    protected UserModel importUserFromPicketlink(RealmModel realm, User picketlinkUser) {
        String email;
        String string = email = picketlinkUser.getEmail() != null && picketlinkUser.getEmail().trim().length() > 0 ? picketlinkUser.getEmail() : null;
        if (picketlinkUser.getLoginName() == null) {
            throw new ModelException("User returned from LDAP has null username! Check configuration of your LDAP mappings. ID of user from LDAP: " + picketlinkUser.getId());
        }
        UserModel imported = this.session.userStorage().addUser(realm, picketlinkUser.getLoginName());
        imported.setEnabled(true);
        imported.setEmail(email);
        imported.setFirstName(picketlinkUser.getFirstName());
        imported.setLastName(picketlinkUser.getLastName());
        imported.setFederationLink(this.model.getId());
        imported.setAttribute(LDAP_ID, picketlinkUser.getId());
        return this.proxy(imported);
    }

    protected User queryByEmail(IdentityManager identityManager, String email) throws IdentityManagementException {
        return LDAPUtils.getUserByEmail(identityManager, email);
    }

    public UserModel getUserByEmail(RealmModel realm, String email) {
        IdentityManager identityManager = this.getIdentityManager();
        try {
            User picketlinkUser = this.queryByEmail(identityManager, email);
            if (picketlinkUser == null) {
                return null;
            }
            if (!email.equals(picketlinkUser.getEmail())) {
                logger.warnf("User found in LDAP but with different email. LDAP email: %s, Searched email: %s", (Object)email, (Object)picketlinkUser.getEmail());
                return null;
            }
            return this.importUserFromPicketlink(realm, picketlinkUser);
        }
        catch (IdentityManagementException ie) {
            throw this.convertIDMException(ie);
        }
    }

    public void preRemove(RealmModel realm) {
    }

    public void preRemove(RealmModel realm, RoleModel role) {
    }

    public boolean validPassword(String username, String password) {
        try {
            return LDAPUtils.validatePassword(this.partitionManager, username, password);
        }
        catch (IdentityManagementException ie) {
            throw this.convertIDMException(ie);
        }
    }

    public boolean validCredentials(RealmModel realm, UserModel user, List<UserCredentialModel> input) {
        Iterator<UserCredentialModel> i$ = input.iterator();
        if (i$.hasNext()) {
            UserCredentialModel cred = i$.next();
            if (cred.getType().equals("password")) {
                return this.validPassword(user.getUsername(), cred.getValue());
            }
            return false;
        }
        return true;
    }

    public boolean validCredentials(RealmModel realm, UserModel user, UserCredentialModel ... input) {
        int i$ = 0;
        UserCredentialModel[] arr$ = input;
        int len$ = arr$.length;
        if (i$ < len$) {
            UserCredentialModel cred = arr$[i$];
            if (cred.getType().equals("password")) {
                return this.validPassword(user.getUsername(), cred.getValue());
            }
            return false;
        }
        return true;
    }

    public void close() {
    }

    protected void importPicketlinkUsers(RealmModel realm, List<User> users, UserFederationProviderModel fedModel) {
        for (User picketlinkUser : users) {
            String username = picketlinkUser.getLoginName();
            UserModel currentUser = this.session.userStorage().getUserByUsername(username, realm);
            if (currentUser == null) {
                this.importUserFromPicketlink(realm, picketlinkUser);
                logger.debugf("Added new user from LDAP: %s", (Object)username);
                continue;
            }
            if (fedModel.getId().equals(currentUser.getFederationLink()) && picketlinkUser.getId().equals(currentUser.getAttribute(LDAP_ID))) {
                String email = picketlinkUser.getEmail() != null && picketlinkUser.getEmail().trim().length() > 0 ? picketlinkUser.getEmail() : null;
                currentUser.setEmail(email);
                currentUser.setFirstName(picketlinkUser.getFirstName());
                currentUser.setLastName(picketlinkUser.getLastName());
                logger.debugf("Updated user from LDAP: %s", (Object)currentUser.getUsername());
                continue;
            }
            logger.warnf("User '%s' is not updated during sync as he is not linked to federation provider '%s'", (Object)username, (Object)fedModel.getDisplayName());
        }
    }

    static {
        supportedCredentialTypes.add("password");
    }
}

