/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.impl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.impl.EmptyAttributeManager;
import org.picketlink.identity.federation.core.interfaces.AttributeManager;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2AttributeManager;
import org.picketlink.identity.federation.core.saml.v2.util.StatementUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;

public class DelegatedAttributeManager
implements SAML2AttributeManager {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private final List<String> attributeKeys = new ArrayList<String>();
    private final AttributeManager delegate;

    public DelegatedAttributeManager(AttributeManager delegate, List<String> attributeKeys) {
        this.delegate = delegate != null ? delegate : new EmptyAttributeManager();
        if (attributeKeys != null) {
            this.attributeKeys.addAll(attributeKeys);
        }
    }

    @Override
    public Map<String, Object> getAttributes(Principal userPrincipal, List<String> attributeKeys) {
        if (this.delegate == null) {
            throw logger.injectedValueMissing("Delegate");
        }
        return this.delegate.getAttributes(userPrincipal, attributeKeys);
    }

    public Map<String, Object> getAttributesMap(AuthnRequestType authnRequestType, Principal userPrincipal) {
        if (this.delegate == null) {
            throw logger.injectedValueMissing("Delegate");
        }
        Set<AttributeStatementType> attributeStatementTypes = this.getAttributes(authnRequestType, userPrincipal);
        Map<String, Object> attrMap = attributeStatementTypes != null && !attributeStatementTypes.isEmpty() ? StatementUtil.asMap(attributeStatementTypes) : this.delegate.getAttributes(userPrincipal, this.attributeKeys);
        return attrMap;
    }

    @Override
    public Set<AttributeStatementType> getAttributes(AuthnRequestType authnRequestType, Principal userPrincipal) {
        if (this.delegate == null) {
            throw logger.injectedValueMissing("Delegate");
        }
        HashSet<AttributeStatementType> attributeStatementTypes = new HashSet<AttributeStatementType>();
        if (SAML2AttributeManager.class.isInstance(this.delegate)) {
            SAML2AttributeManager saml2AttributeManager = (SAML2AttributeManager)this.delegate;
            attributeStatementTypes.addAll(saml2AttributeManager.getAttributes(authnRequestType, userPrincipal));
        } else {
            Map<String, Object> attributes = this.getAttributes(userPrincipal, this.attributeKeys);
            if (attributes != null) {
                attributeStatementTypes.add(StatementUtil.createAttributeStatement(attributes));
            }
        }
        return attributeStatementTypes;
    }
}

