/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.sts.registry;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.picketlink.identity.federation.core.sts.registry.AbstractJDBCRegistry;
import org.picketlink.identity.federation.core.sts.registry.RevocationRegistry;

public class JDBCRevocationRegistry
extends AbstractJDBCRegistry
implements RevocationRegistry {
    public JDBCRevocationRegistry() {
        super("jdbc/picketlink-sts");
    }

    public JDBCRevocationRegistry(String jndiName) {
        super(jndiName);
    }

    @Override
    public boolean isRevoked(String tokenType, String tokenID) {
        boolean bl;
        if (this.dataSource == null) {
            throw logger.datasourceIsNull();
        }
        String existsTableSQL = "SELECT COUNT(*) FROM REVOCATION_REGISTRY WHERE TOKEN_ID =? AND  TOKEN_TYPE = ?";
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            conn = this.dataSource.getConnection();
            Date tokenCreationDate = Calendar.getInstance().getTime();
            preparedStatement = conn.prepareStatement(existsTableSQL);
            preparedStatement.setString(1, tokenID);
            preparedStatement.setString(2, tokenType);
            resultSet = preparedStatement.executeQuery();
            bl = resultSet.getInt(1) > 0;
        }
        catch (SQLException e) {
            try {
                throw logger.runtimeException("revokeToken", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.safeClose(resultSet);
                this.safeClose(preparedStatement);
                this.safeClose(conn);
                throw throwable;
            }
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(conn);
        return bl;
    }

    @Override
    public void revokeToken(String tokenType, String tokenID) {
        if (this.dataSource == null) {
            throw logger.datasourceIsNull();
        }
        String insertTableSQL = "INSERT INTO REVOCATION_REGISTRY(TOKEN_ID, TOKEN_TYPE, CREATED_DATE) VALUES(?,?,?)";
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        try {
            conn = this.dataSource.getConnection();
            Date tokenCreationDate = Calendar.getInstance().getTime();
            preparedStatement = conn.prepareStatement(insertTableSQL);
            preparedStatement.setString(1, tokenID);
            preparedStatement.setString(2, tokenType);
            preparedStatement.setTimestamp(3, new Timestamp(tokenCreationDate.getTime()));
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw logger.runtimeException("revokeToken", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.safeClose(preparedStatement);
                this.safeClose(conn);
                throw throwable;
            }
        }
        this.safeClose(preparedStatement);
        this.safeClose(conn);
    }
}

