/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import org.infinispan.Cache;
import org.keycloak.Config;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.UserSessionProviderFactory;
import org.keycloak.models.sessions.infinispan.InfinispanUserSessionProvider;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureKey;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

public class InfinispanUserSessionProviderFactory
implements UserSessionProviderFactory {
    public UserSessionProvider create(KeycloakSession session) {
        InfinispanConnectionProvider connections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        Cache cache = connections.getCache("sessions");
        Cache loginFailures = connections.getCache("loginFailures");
        return new InfinispanUserSessionProvider(session, (Cache<String, SessionEntity>)cache, (Cache<LoginFailureKey, LoginFailureEntity>)loginFailures);
    }

    public void init(Config.Scope config) {
    }

    public void close() {
    }

    public String getId() {
        return "infinispan";
    }
}

