/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.infinispan.Cache;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.infinispan.InfinispanUserSessionProvider;
import org.keycloak.models.sessions.infinispan.entities.ClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;

public class UserSessionAdapter
implements UserSessionModel {
    private final KeycloakSession session;
    private final InfinispanUserSessionProvider provider;
    private final Cache<String, SessionEntity> cache;
    private final RealmModel realm;
    private final UserSessionEntity entity;

    public UserSessionAdapter(KeycloakSession session, InfinispanUserSessionProvider provider, Cache<String, SessionEntity> cache, RealmModel realm, UserSessionEntity entity) {
        this.session = session;
        this.provider = provider;
        this.cache = cache;
        this.realm = realm;
        this.entity = entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public UserModel getUser() {
        return this.session.users().getUserById(this.entity.getUser(), this.realm);
    }

    public String getLoginUsername() {
        return this.entity.getLoginUsername();
    }

    public String getIpAddress() {
        return this.entity.getIpAddress();
    }

    public String getAuthMethod() {
        return this.entity.getAuthMethod();
    }

    public boolean isRememberMe() {
        return this.entity.isRememberMe();
    }

    public int getStarted() {
        return this.entity.getStarted();
    }

    public int getLastSessionRefresh() {
        return this.entity.getLastSessionRefresh();
    }

    public void setLastSessionRefresh(int lastSessionRefresh) {
        this.entity.setLastSessionRefresh(lastSessionRefresh);
        this.update();
    }

    public List<ClientSessionModel> getClientSessions() {
        if (this.entity.getClientSessions() != null) {
            LinkedList<ClientSessionEntity> clientSessions = new LinkedList<ClientSessionEntity>();
            for (String c : this.entity.getClientSessions()) {
                ClientSessionEntity clientSession = (ClientSessionEntity)this.cache.get((Object)c);
                if (clientSession == null) continue;
                clientSessions.add(clientSession);
            }
            return this.provider.wrapClientSessions(this.realm, clientSessions);
        }
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserSessionModel)) {
            return false;
        }
        UserSessionModel that = (UserSessionModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    UserSessionEntity getEntity() {
        return this.entity;
    }

    void update() {
        this.provider.getTx().replace(this.cache, this.entity.getId(), this.entity);
    }
}

