/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.managers.ResourceAdminManager;

public class OpenIDConnect
implements LoginProtocol {
    public static final String LOGIN_PROTOCOL = "openid-connect";
    public static final String STATE_PARAM = "state";
    public static final String SCOPE_PARAM = "scope";
    public static final String RESPONSE_TYPE_PARAM = "response_type";
    public static final String REDIRECT_URI_PARAM = "redirect_uri";
    public static final String CLIENT_ID_PARAM = "client_id";
    public static final String PROMPT_PARAM = "prompt";
    public static final String LOGIN_HINT_PARAM = "login_hint";
    private static final Logger log = Logger.getLogger(OpenIDConnect.class);
    protected KeycloakSession session;
    protected RealmModel realm;
    protected UriInfo uriInfo;

    public OpenIDConnect(KeycloakSession session, RealmModel realm, UriInfo uriInfo) {
        this.session = session;
        this.realm = realm;
        this.uriInfo = uriInfo;
    }

    public OpenIDConnect() {
    }

    @Override
    public OpenIDConnect setSession(KeycloakSession session) {
        this.session = session;
        return this;
    }

    @Override
    public OpenIDConnect setRealm(RealmModel realm) {
        this.realm = realm;
        return this;
    }

    @Override
    public OpenIDConnect setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
        return this;
    }

    @Override
    public Response cancelLogin(ClientSessionModel clientSession) {
        String redirect = clientSession.getRedirectUri();
        String state = clientSession.getNote(STATE_PARAM);
        UriBuilder redirectUri = UriBuilder.fromUri((String)redirect).queryParam("error", new Object[]{"access_denied"});
        if (state != null) {
            redirectUri.queryParam(STATE_PARAM, new Object[]{state});
        }
        return Response.status((int)302).location(redirectUri.build(new Object[0])).build();
    }

    @Override
    public Response authenticated(UserSessionModel userSession, ClientSessionCode accessCode) {
        ClientSessionModel clientSession = accessCode.getClientSession();
        String redirect = clientSession.getRedirectUri();
        String state = clientSession.getNote(STATE_PARAM);
        accessCode.setAction(ClientSessionModel.Action.CODE_TO_TOKEN);
        UriBuilder redirectUri = UriBuilder.fromUri((String)redirect).queryParam("code", new Object[]{accessCode.getCode()});
        log.debugv("redirectAccessCode: state: {0}", (Object)state);
        if (state != null) {
            redirectUri.queryParam(STATE_PARAM, new Object[]{state});
        }
        Response.ResponseBuilder location = Response.status((int)302).location(redirectUri.build(new Object[0]));
        return location.build();
    }

    @Override
    public Response consentDenied(ClientSessionModel clientSession) {
        String redirect = clientSession.getRedirectUri();
        String state = clientSession.getNote(STATE_PARAM);
        UriBuilder redirectUri = UriBuilder.fromUri((String)redirect).queryParam("error", new Object[]{"access_denied"});
        if (state != null) {
            redirectUri.queryParam(STATE_PARAM, new Object[]{state});
        }
        Response.ResponseBuilder location = Response.status((int)302).location(redirectUri.build(new Object[0]));
        return location.build();
    }

    @Override
    public Response invalidSessionError(ClientSessionModel clientSession) {
        String redirect = clientSession.getRedirectUri();
        String state = clientSession.getNote(STATE_PARAM);
        UriBuilder redirectUri = UriBuilder.fromUri((String)redirect).queryParam("error", new Object[]{"access_denied"});
        if (state != null) {
            redirectUri.queryParam(STATE_PARAM, new Object[]{state});
        }
        return Response.status((int)302).location(redirectUri.build(new Object[0])).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backchannelLogout(UserSessionModel userSession, ClientSessionModel clientSession) {
        if (!(clientSession.getClient() instanceof ApplicationModel)) {
            return;
        }
        ApplicationModel app = (ApplicationModel)clientSession.getClient();
        ApacheHttpClient4Executor executor = ResourceAdminManager.createExecutor();
        try {
            new ResourceAdminManager().logoutClientSession(this.uriInfo.getRequestUri(), this.realm, app, clientSession, executor);
        }
        finally {
            executor.getHttpClient().getConnectionManager().shutdown();
        }
    }

    public void close() {
    }
}

