/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.mongo;

import java.util.LinkedList;
import java.util.List;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.mongo.AbstractMongoAdapter;
import org.keycloak.models.sessions.mongo.MongoUserSessionProvider;
import org.keycloak.models.sessions.mongo.entities.MongoUserSessionEntity;

public class UserSessionAdapter
extends AbstractMongoAdapter<MongoUserSessionEntity>
implements UserSessionModel {
    private final MongoUserSessionProvider provider;
    private MongoUserSessionEntity entity;
    private RealmModel realm;
    private KeycloakSession keycloakSession;
    private final MongoStoreInvocationContext invContext;

    public UserSessionAdapter(KeycloakSession keycloakSession, MongoUserSessionProvider provider, MongoUserSessionEntity entity, RealmModel realm, MongoStoreInvocationContext invContext) {
        super(invContext);
        this.provider = provider;
        this.entity = entity;
        this.realm = realm;
        this.keycloakSession = keycloakSession;
        this.invContext = invContext;
    }

    @Override
    protected MongoUserSessionEntity getMongoEntity() {
        return this.entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public UserModel getUser() {
        return this.keycloakSession.users().getUserById(this.entity.getUser(), this.realm);
    }

    public String getLoginUsername() {
        return this.entity.getLoginUsername();
    }

    public String getIpAddress() {
        return this.entity.getIpAddress();
    }

    public String getAuthMethod() {
        return this.entity.getAuthMethod();
    }

    public boolean isRememberMe() {
        return this.entity.isRememberMe();
    }

    public int getStarted() {
        return this.entity.getStarted();
    }

    public int getLastSessionRefresh() {
        return this.entity.getLastSessionRefresh();
    }

    public void setLastSessionRefresh(int seconds) {
        this.entity.setLastSessionRefresh(seconds);
        this.updateMongoEntity();
    }

    public List<ClientSessionModel> getClientSessions() {
        LinkedList<ClientSessionModel> sessions = new LinkedList<ClientSessionModel>();
        if (this.entity.getClientSessions() == null) {
            return sessions;
        }
        for (String id : this.entity.getClientSessions()) {
            ClientSessionModel clientSession = this.provider.getClientSession(this.realm, id);
            if (clientSession == null) continue;
            sessions.add(clientSession);
        }
        return sessions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserSessionModel)) {
            return false;
        }
        UserSessionModel that = (UserSessionModel)o;
        return that.getId().equals(this.getId());
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }
}

