/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import liquibase.util.StreamUtil;

public class FileUtil {
    public static void forceDeleteOnExit(final File file) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    FileUtil.deleteDirectory(file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FileUtil.cleanDirectory(directory);
        if (!directory.delete()) {
            throw new IOException("Cannot delete " + directory.getAbsolutePath());
        }
    }

    private static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        if (!directory.isDirectory()) {
            return;
        }
        IOException exception = null;
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                try {
                    FileUtil.cleanDirectory(file);
                    if (!file.delete()) {
                        throw new IOException("Cannot delete " + file.getAbsolutePath());
                    }
                }
                catch (IOException ioe) {
                    exception = ioe;
                }
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unzip(File zipFile) throws IOException {
        File tempDir = File.createTempFile("liquibase-unzip", ".dir");
        tempDir.delete();
        tempDir.mkdir();
        JarFile jarFile = new JarFile(zipFile);
        try {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                int len;
                JarEntry entry = entries.nextElement();
                File entryFile = new File(tempDir, entry.getName());
                if (entry.isDirectory()) continue;
                entryFile.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(entryFile);
                byte[] buf = new byte[1024];
                InputStream inputStream = jarFile.getInputStream(entry);
                while ((len = inputStream.read(buf)) > 0) {
                    if (!zipFile.exists()) {
                        zipFile.getParentFile().mkdirs();
                    }
                    out.write(buf, 0, len);
                }
                inputStream.close();
                out.close();
            }
            FileUtil.forceDeleteOnExit(tempDir);
        }
        finally {
            jarFile.close();
        }
        return tempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContents(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            String string = StreamUtil.getReaderContents(reader);
            return string;
        }
        catch (FileNotFoundException e) {
            String string = null;
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String contents, File file) throws IOException {
        file.getParentFile().mkdirs();
        FileOutputStream output = new FileOutputStream(file);
        try {
            StreamUtil.copy(new ByteArrayInputStream(contents.getBytes("UTF-8")), output);
        }
        finally {
            output.close();
        }
    }
}

