/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap;

import java.io.Serializable;
import java.util.List;
import org.keycloak.models.ModelDuplicateException;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.credential.UsernamePasswordCredentials;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.basic.BasicModel;
import org.picketlink.idm.model.basic.User;
import org.picketlink.idm.query.AttributeParameter;
import org.picketlink.idm.query.QueryParameter;

public class LDAPUtils {
    public static QueryParameter MODIFY_DATE = new AttributeParameter("modifyDate");

    public static User addUser(PartitionManager partitionManager, String username, String firstName, String lastName, String email) {
        IdentityManager identityManager = LDAPUtils.getIdentityManager(partitionManager);
        if (BasicModel.getUser((IdentityManager)identityManager, (String)username) != null) {
            throw new ModelDuplicateException("User with same username already exists");
        }
        if (LDAPUtils.getUserByEmail(identityManager, email) != null) {
            throw new ModelDuplicateException("User with same email already exists");
        }
        User picketlinkUser = new User(username);
        picketlinkUser.setFirstName(firstName);
        picketlinkUser.setLastName(lastName);
        picketlinkUser.setEmail(email);
        picketlinkUser.setAttribute(new Attribute("fullName", (Serializable)((Object)LDAPUtils.getFullName(username, firstName, lastName))));
        identityManager.add((IdentityType)picketlinkUser);
        return picketlinkUser;
    }

    public static User updateUser(PartitionManager partitionManager, String username, String firstName, String lastName, String email) {
        IdentityManager idmManager = LDAPUtils.getIdentityManager(partitionManager);
        User picketlinkUser = BasicModel.getUser((IdentityManager)idmManager, (String)username);
        picketlinkUser.setFirstName(firstName);
        picketlinkUser.setLastName(lastName);
        picketlinkUser.setEmail(email);
        idmManager.update((IdentityType)picketlinkUser);
        return picketlinkUser;
    }

    public static void updatePassword(PartitionManager partitionManager, User picketlinkUser, String password) {
        IdentityManager idmManager = LDAPUtils.getIdentityManager(partitionManager);
        idmManager.updateCredential((Account)picketlinkUser, (Object)new Password(password.toCharArray()));
    }

    public static boolean validatePassword(PartitionManager partitionManager, String username, String password) {
        IdentityManager idmManager = LDAPUtils.getIdentityManager(partitionManager);
        UsernamePasswordCredentials credential = new UsernamePasswordCredentials();
        credential.setUsername(username);
        credential.setPassword(new Password(password.toCharArray()));
        idmManager.validateCredentials((Credentials)credential);
        return credential.getStatus() == Credentials.Status.VALID;
    }

    public static User getUser(PartitionManager partitionManager, String username) {
        IdentityManager idmManager = LDAPUtils.getIdentityManager(partitionManager);
        return BasicModel.getUser((IdentityManager)idmManager, (String)username);
    }

    public static User getUserByEmail(IdentityManager idmManager, String email) throws IdentityManagementException {
        List agents = idmManager.createIdentityQuery(User.class).setParameter(User.EMAIL, new Object[]{email}).getResultList();
        if (agents.isEmpty()) {
            return null;
        }
        if (agents.size() == 1) {
            return (User)agents.get(0);
        }
        throw new IdentityManagementException("Error - multiple users found with same email");
    }

    public static boolean removeUser(PartitionManager partitionManager, String username) {
        IdentityManager idmManager = LDAPUtils.getIdentityManager(partitionManager);
        User picketlinkUser = BasicModel.getUser((IdentityManager)idmManager, (String)username);
        if (picketlinkUser == null) {
            return false;
        }
        idmManager.remove((IdentityType)picketlinkUser);
        return true;
    }

    public static void removeAllUsers(PartitionManager partitionManager) {
        IdentityManager idmManager = LDAPUtils.getIdentityManager(partitionManager);
        List users = idmManager.createIdentityQuery(User.class).getResultList();
        for (User user : users) {
            idmManager.remove((IdentityType)user);
        }
    }

    public static List<User> getAllUsers(PartitionManager partitionManager) {
        IdentityManager idmManager = LDAPUtils.getIdentityManager(partitionManager);
        return idmManager.createIdentityQuery(User.class).getResultList();
    }

    private static IdentityManager getIdentityManager(PartitionManager partitionManager) {
        return partitionManager.createIdentityManager();
    }

    private static String getFullName(String username, String firstName, String lastName) {
        String fullName = firstName != null && lastName != null ? firstName + " " + lastName : (firstName != null && firstName.trim().length() > 0 ? firstName : lastName);
        if (fullName == null || fullName.trim().length() == 0) {
            fullName = username;
        }
        return fullName;
    }
}

